/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.cluster.selector;

import io.vertx.core.eventbus.impl.clustered.selector.Weight;
import io.vertx.core.eventbus.impl.clustered.selector.WeightedRoundRobinSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WeightedRoundRobinSelectorTest {
    private final Map<String, Weight> weights;
    private final int totalWeight;
    private final WeightedRoundRobinSelector selector;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        HashMap<String, Weight> map = new HashMap<String, Weight>();
        map.put("foo", new Weight(38));
        map.put("bar", new Weight(13));
        objects.add(new Object[]{map});
        map = new HashMap();
        map.put("foo", new Weight(91));
        map.put("bar", new Weight(22));
        map.put("baz", new Weight(115));
        objects.add(new Object[]{map});
        map = new HashMap();
        map.put("foo", new Weight(28));
        map.put("bar", new Weight(91));
        map.put("baz", new Weight(28));
        map.put("qux", new Weight(13));
        map.put("quux", new Weight(28));
        objects.add(new Object[]{map});
        return objects;
    }

    public WeightedRoundRobinSelectorTest(Map<String, Weight> weights) {
        this.weights = weights;
        this.totalWeight = weights.values().stream().mapToInt(Weight::value).sum();
        this.selector = new WeightedRoundRobinSelector(weights);
    }

    @Test
    public void testSelectForSend() {
        List list = IntStream.range(0, this.totalWeight * 10).mapToObj(i -> this.selector.selectForSend()).collect(Collectors.toList());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String string : list) {
            Assert.assertTrue((boolean)this.weights.containsKey(string));
            counts.merge(string, 1, Math::addExact);
        }
        for (Map.Entry entry : counts.entrySet()) {
            Assert.assertEquals((long)(10 * this.weights.get(entry.getKey()).value()), (long)((Integer)entry.getValue()).intValue());
        }
    }

    @Test
    public void testSelectForPublish() {
        for (int i = 0; i < 10; ++i) {
            Iterable iterable = this.selector.selectForPublish();
            List list = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
            Assert.assertTrue((boolean)list.containsAll(this.weights.keySet()));
            Assert.assertTrue((boolean)this.weights.keySet().containsAll(list));
        }
    }
}

