/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.concurrent;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.internal.VertxInternal;
import io.vertx.tests.concurrent.InboundMessageQueueTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import org.junit.Test;

public class InboundMessageQueueSingleThreadTest
extends InboundMessageQueueTest {
    @Override
    protected Context createContext(VertxInternal vertx) {
        return vertx.createEventLoopContext();
    }

    @Test
    public void testEmitInElementHandler() {
        AtomicInteger events = new AtomicInteger();
        AtomicBoolean receiving = new AtomicBoolean();
        this.queue = this.buffer(elt -> {
            this.assertConsumer();
            this.assertFalse(receiving.getAndSet(true));
            events.incrementAndGet();
            if (elt == 0) {
                this.queue.emit(5);
            }
            receiving.set(false);
        }, 5, 5);
        this.producerTask(() -> {
            this.queue.pause();
            this.queue.fetch(1L);
            this.assertFalse(this.queue.emit());
            this.assertEquals(5L, this.queue.size());
            this.assertEquals(1L, events.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEmitInElementHandler1() {
        this.testEmitInElementHandler(n -> this.assertFalse(this.queue.emit(n)));
    }

    private void testEmitInElementHandler(IntConsumer emit) {
        AtomicInteger events = new AtomicInteger();
        AtomicInteger drained = new AtomicInteger();
        AtomicBoolean draining = new AtomicBoolean();
        this.queue = this.buffer(elt -> {
            this.assertConsumer();
            switch (elt) {
                case 5: {
                    emit.accept(9);
                    break;
                }
                case 9: {
                    this.vertx.runOnContext(v2 -> {
                        this.assertEquals(1L, drained.get());
                        this.assertEquals(10L, events.get());
                        this.assertEquals(5L, this.queue.size());
                        this.testComplete();
                    });
                }
            }
            events.incrementAndGet();
        }, 5, 5);
        this.queue.drainHandler((Handler<Void>)((Handler)v3 -> {
            this.assertFalse(draining.get());
            draining.set(true);
            this.assertEquals(0L, drained.getAndIncrement());
            this.assertFalse(this.queue.emit());
            draining.set(false);
        }));
        this.producerTask(() -> {
            this.queue.pause();
            this.queue.fill();
            this.queue.fetch(10L);
        });
        this.await();
    }

    @Test
    public void testEmitWhenHandlingLastItem() {
        int next = this.sequence.get();
        AtomicInteger received = new AtomicInteger(next);
        AtomicInteger writable = new AtomicInteger();
        this.queue = this.buffer(elt -> {
            if (received.decrementAndGet() == 0) {
                this.queue.write(next);
            }
        }, 4, 4).drainHandler((Handler<Void>)((Handler)v2 -> writable.incrementAndGet()));
        this.producerTask(() -> {
            this.queue.pause();
            this.queue.fill();
            this.queue.fetch(this.sequence.get());
            this.assertEquals(0L, writable.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEmitInDrainHandler1() {
        AtomicInteger drained = new AtomicInteger();
        AtomicInteger expectedDrained = new AtomicInteger();
        this.queue = this.buffer(elt -> {
            if (elt == 0) {
                this.queue.fill();
            }
            this.assertEquals(expectedDrained.get(), drained.get());
        }, 4, 4).drainHandler((Handler<Void>)((Handler)v2 -> {
            switch (drained.getAndIncrement()) {
                case 0: {
                    expectedDrained.set(1);
                    this.queue.fill();
                    this.assertEquals(1L, drained.get());
                    this.testComplete();
                }
            }
        }));
        this.producerTask(() -> {
            this.queue.pause();
            this.queue.fetch(1L);
            this.queue.emit();
            this.queue.fetch(4L);
        });
        this.await();
    }

    @Test
    public void testEmitInDrainHandler2() {
        this.waitFor(2);
        AtomicInteger drained = new AtomicInteger();
        AtomicBoolean draining = new AtomicBoolean();
        AtomicInteger emitted = new AtomicInteger();
        this.queue = this.buffer(elt -> {
            emitted.incrementAndGet();
            if (elt == 0) {
                this.assertEquals(0L, drained.get());
            } else if (elt == 6) {
                this.assertEquals(1L, drained.get());
            }
        }, 5, 5).drainHandler((Handler<Void>)((Handler)v2 -> {
            this.assertFalse(draining.get());
            draining.set(true);
            switch (drained.getAndIncrement()) {
                case 0: {
                    this.queue.fill();
                    this.queue.fetch(5L);
                    break;
                }
                case 1: {
                    this.assertEquals(10L, emitted.get());
                    this.complete();
                }
            }
            draining.set(false);
        }));
        this.producerTask(() -> {
            this.queue.pause();
            this.queue.fill();
            this.queue.fetch(5L);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testDrainAfter() {
        AtomicInteger events = new AtomicInteger();
        AtomicBoolean receiving = new AtomicBoolean();
        this.queue = this.buffer(elt -> {
            this.assertConsumer();
            this.assertFalse(receiving.getAndSet(true));
            events.incrementAndGet();
            if (elt == 0) {
                this.queue.emit(5);
            }
            receiving.set(false);
        }, 5, 5);
        this.producerTask(() -> {
            this.assertTrue(this.queue.emit());
            this.assertEquals(6L, this.sequence.get());
            this.assertEquals(6L, events.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPauseInElementHandler() {
        AtomicInteger events = new AtomicInteger();
        this.queue = this.buffer(elt -> {
            events.incrementAndGet();
            if (elt == 0) {
                this.queue.pause();
                this.queue.emit(5);
            }
        }, 5, 5);
        this.producerTask(() -> {
            this.assertFalse(this.queue.emit());
            this.assertEquals(1L, events.get());
            this.assertEquals(5L, this.queue.size());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAddAllEmitInHandler() {
        ArrayList emitted = new ArrayList();
        this.queue = this.buffer(elt -> {
            switch (elt) {
                case 0: {
                    this.queue.emit();
                }
            }
            emitted.add(elt);
        }, 4, 4);
        this.producerTask(() -> {
            this.assertTrue(this.queue.emit(3));
            this.assertEquals(Arrays.asList(0, 1, 2, 3), emitted);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAddAllWhenDelivering() {
        ArrayList emitted = new ArrayList();
        this.queue = this.buffer(elt -> {
            emitted.add(elt);
            if (elt == 2) {
                this.queue.write(Arrays.asList(4, 5));
                this.assertEquals(Arrays.asList(0, 1, 2), emitted);
            }
        }, 4, 4);
        this.producerTask(() -> {
            this.queue.emit(4);
            InboundMessageQueueSingleThreadTest.assertWaitUntil(() -> Arrays.asList(0, 1, 2, 3, 4, 5).equals(emitted));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPauseInHandlerSignalsFullImmediately() {
        this.queue = this.buffer(elt -> {
            this.queue.pause();
            this.queue.emit();
        }, 1, 1);
        this.producerTask(() -> {
            this.assertFalse(this.queue.emit());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testWriteWhenClosing() {
        AtomicInteger emitted = new AtomicInteger();
        final List dropped = Collections.synchronizedList(new ArrayList());
        this.queue = new InboundMessageQueueTest.TestChannel(elt -> emitted.incrementAndGet(), 4, 4){

            protected void handleDispose(Integer msg) {
                dropped.add(msg);
                if (msg == 0) {
                    InboundMessageQueueSingleThreadTest.this.queue.write(1);
                }
            }
        };
        this.producerTask(() -> {
            this.queue.pause();
            this.queue.write(0);
            this.queue.close();
            this.assertEquals(0L, emitted.get());
            this.assertEquals(Arrays.asList(0, 1), dropped);
            this.testComplete();
        });
    }

    @Test
    public void testCloseWhenDraining() {
        List emitted = Collections.synchronizedList(new ArrayList());
        final List dropped = Collections.synchronizedList(new ArrayList());
        this.queue = new InboundMessageQueueTest.TestChannel(elt -> {
            emitted.add(elt);
            if (elt == 0) {
                this.queue.close();
                this.assertEquals(Collections.emptyList(), dropped);
            }
        }, 4, 4){

            protected void handleDispose(Integer msg) {
                dropped.add(msg);
            }
        };
        this.producerTask(() -> {
            this.queue.fill();
            this.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), dropped);
            this.assertEquals(List.of(Integer.valueOf(0)), emitted);
            this.testComplete();
        });
        this.await();
    }
}

