/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.concurrent;

import io.vertx.core.streams.impl.MessagePassingQueue;
import io.vertx.test.core.AsyncTestBase;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class InboundReadQueueTest
extends AsyncTestBase {
    final MessagePassingQueue.Factory factory = MessagePassingQueue.SPSC;

    @Test
    public void testAdd() {
        MessagePassingQueue queue = this.factory.create(elt -> false);
        this.assertEquals(4L, queue.add((Object)0));
        for (int i = 1; i < 15; ++i) {
            this.assertEquals(0L, queue.add((Object)i));
        }
        this.assertEquals(1L, queue.add((Object)17));
    }

    @Test
    public void testDrainSingle() {
        MessagePassingQueue queue = this.factory.create(elt -> true);
        this.assertEquals(4L, queue.add((Object)0));
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)0, (boolean)false), queue.drain(17L));
    }

    @Test
    public void testFoo() {
        MessagePassingQueue queue = this.factory.create(elt -> false);
        this.assertEquals(4L, queue.add((Object)0));
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)1, (boolean)false), queue.drain());
    }

    @Test
    public void testDrainFully() {
        LinkedList consumed = new LinkedList();
        MessagePassingQueue queue = this.factory.create(elt -> {
            consumed.add(elt);
            return true;
        });
        this.assertEquals(4L, queue.add((Object)0));
        int idx = 1;
        while ((queue.add((Object)idx++) & 1) == 0) {
        }
        this.assertEquals(16L, idx);
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)0, (boolean)true), queue.drain() & 3);
        for (int i = 0; i < 16; ++i) {
            this.assertEquals(i, ((Integer)consumed.poll()).intValue());
        }
        this.assertTrue(consumed.isEmpty());
    }

    @Test
    public void testDrainRefuseSingleElement() {
        MessagePassingQueue queue = this.factory.create(elt -> false);
        this.assertEquals(4L, queue.add((Object)0));
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)1, (boolean)false), queue.drain());
    }

    @Test
    public void testConsumeDrain() {
        AtomicInteger demand = new AtomicInteger(0);
        MessagePassingQueue queue = this.factory.create(elt -> {
            if (demand.get() > 0) {
                demand.decrementAndGet();
                return true;
            }
            return false;
        });
        this.assertEquals(4L, queue.add((Object)0));
        int idx = 1;
        while ((queue.add((Object)idx++) & 1) == 0) {
        }
        this.assertEquals(16L, idx);
        for (int i = 0; i < 8; ++i) {
            demand.set(1);
            this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)(15 - i), (boolean)false), queue.drain() & 0xFFFF);
        }
        demand.set(1);
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)7, (boolean)true), queue.drain() & 0xFFFF);
    }

    @Test
    public void testPartialDrain() {
        AtomicInteger demand = new AtomicInteger(0);
        MessagePassingQueue queue = this.factory.create(elt -> true);
        int idx = 0;
        while ((queue.add((Object)idx++) & 1) == 0) {
        }
        this.assertEquals(16L, idx);
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)12, (boolean)false), queue.drain(4L) & 0xFFFF);
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)7, (boolean)true), queue.drain(5L) & 0xFFFF);
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)0, (boolean)false), queue.drain() & 0xFFFF);
    }

    @Test
    public void testUnwritableCount() {
        AtomicInteger demand = new AtomicInteger();
        MessagePassingQueue queue = this.factory.create(elt -> {
            if (demand.get() > 0) {
                demand.decrementAndGet();
                return true;
            }
            return false;
        });
        int count = 0;
        while ((queue.add((Object)count++) & 1) == 0) {
        }
        demand.set(1);
        this.assertEquals(MessagePassingQueue.drainResult((int)0, (int)15, (boolean)false), queue.drain() & 0xFFFF);
        this.assertFlagsSet(queue.add((Object)count++), 1);
        demand.set(count - 1);
        int flags = queue.drain();
        this.assertFlagsSet(flags, 2);
        this.assertEquals(0L, MessagePassingQueue.numberOfPendingElements((int)flags));
    }

    private void assertFlagsSet(int flags, int ... masks) {
        for (int mask : masks) {
            this.assertTrue("Expecting flag " + Integer.toBinaryString(mask) + " to be set", (flags & mask) != 0);
        }
    }

    private void assertFlagsClear(int flags, int ... masks) {
        for (int mask : masks) {
            this.assertTrue("Expecting flag " + Integer.toBinaryString(mask) + " to be clear", (flags & mask) == 0);
        }
    }
}

