/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.concurrent;

import io.vertx.core.streams.impl.MessagePassingQueue;
import io.vertx.test.core.AsyncTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.AssertionFailedError;
import org.junit.Test;

public class MessagePassingQueueTest
extends AsyncTestBase {
    private List<Integer> output = Collections.synchronizedList(new ArrayList());
    private MessagePassingQueue.MpSc<Integer> queue;
    private Runnable unwritableHook;

    private int producerAdd(Integer element) {
        int res = this.queue.add((Object)element);
        if ((res & 1) != 0 && this.unwritableHook != null) {
            this.unwritableHook.run();
        }
        return res;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.disableThreadChecks();
        this.output = Collections.synchronizedList(new ArrayList());
    }

    @Override
    protected void tearDown() throws Exception {
        this.queue = null;
    }

    @Test
    public void testWriteFromOtherThread() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            this.output.add((Integer)elt);
            return true;
        });
        this.assertEquals(4L, this.producerAdd(0));
        for (int i = 1; i < 10; ++i) {
            this.assertEquals(0L, this.producerAdd(i));
        }
        this.queue.drain();
        this.assertEquals(MessagePassingQueueTest.range(0, 10), this.output);
    }

    @Test
    public void testWriteFromEventLoopThread() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            this.output.add((Integer)elt);
            return true;
        });
        for (int i = 0; i < 10; ++i) {
            this.assertEquals(0L, this.queue.write((Object)i));
        }
        this.assertEquals(10L, this.output.size());
    }

    @Test
    public void testReentrantWrite() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            this.output.add((Integer)elt);
            if (elt < 9) {
                this.queue.write((Object)(elt + 1));
            }
            return true;
        });
        this.queue.write((Object)0);
        this.assertEquals(MessagePassingQueueTest.range(0, 10), this.output);
    }

    @Test
    public void testConcurrentWrite() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            this.output.add((Integer)elt);
            if (elt < 9) {
                Thread thread = new Thread(() -> this.producerAdd(elt + 1));
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        });
        this.queue.write((Object)0);
        this.assertEquals(MessagePassingQueueTest.range(0, 10), this.output);
    }

    @Test
    public void testOverflow() {
        this.queue = new MessagePassingQueue.MpSc(elt -> false);
        this.assertFlagsSet(4, this.queue.write((Object)0));
        for (int i = 1; i < 15; ++i) {
            this.assertEquals(0L, this.queue.write((Object)i));
        }
        this.assertEquals(1L, this.queue.write((Object)15));
    }

    @Test
    public void testOverflowReentrant() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (elt == 0) {
                for (int i = 1; i < 15; ++i) {
                    this.assertEquals(0L, this.queue.write((Object)i));
                }
                this.assertEquals(1L, this.queue.write((Object)15));
            }
            return false;
        });
        this.assertFlagsSet(4, this.queue.write((Object)0));
    }

    @Test
    public void testOverflowReentrant2() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (elt == 0) {
                for (int i = 1; i < 15; ++i) {
                    this.assertEquals(0L, this.queue.write((Object)i));
                }
                this.assertEquals(1L, this.queue.write((Object)15));
                return true;
            }
            return false;
        });
        int flags = this.queue.write((Object)0);
        this.assertFlagsSet(flags, 4);
        this.assertEquals(1L, this.queue.write((Object)16));
    }

    @Test
    public void testOverflowReentrant3() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (elt == 0) {
                for (int i = 1; i < 3; ++i) {
                    this.assertEquals(0L, this.queue.write((Object)i));
                }
                return true;
            }
            return false;
        });
        this.assertFlagsSet(4, this.queue.write((Object)0));
    }

    @Test
    public void testDrainQueue() {
        AtomicBoolean paused = new AtomicBoolean(true);
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (paused.get()) {
                return false;
            }
            this.output.add((Integer)elt);
            return true;
        });
        this.assertFlagsSet(4, this.queue.write((Object)0));
        for (int i = 1; i < 5; ++i) {
            this.assertEquals(0L, this.queue.write((Object)i));
        }
        this.assertEquals(0L, this.output.size());
        this.queue.drain();
        this.assertEquals(0L, this.output.size());
        paused.set(false);
        this.assertEquals(0L, this.queue.drain());
        this.assertEquals(MessagePassingQueueTest.range(0, 5), this.output);
    }

    @Test
    public void testReentrantWritable1() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            switch (elt) {
                case 0: {
                    Thread thread = new Thread(() -> {
                        for (int i = 1; i < 15; ++i) {
                            this.assertEquals(0L, this.producerAdd(i));
                        }
                        this.assertEquals(1L, this.producerAdd(15));
                        this.assertEquals(0L, this.producerAdd(16));
                    });
                    thread.start();
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        this.fail(e);
                    }
                    return true;
                }
            }
            return false;
        });
        this.assertFlagsSet(4, this.queue.write((Object)0));
    }

    @Test
    public void testReentrantWritable2() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            switch (elt) {
                case 0: {
                    Thread thread = new Thread(() -> {
                        for (int i = 1; i < 15; ++i) {
                            this.assertEquals(0L, this.producerAdd(i));
                        }
                        this.assertEquals(1L, this.producerAdd(15));
                    });
                    thread.start();
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        this.fail(e);
                    }
                    return true;
                }
            }
            return false;
        });
        int flags = this.queue.write((Object)0);
        this.assertFlagsSet(flags, 4);
        this.assertFlagsClear(flags, 2, 1);
    }

    @Test
    public void testReentrantWritable3() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            switch (elt) {
                case 0: {
                    Thread thread = new Thread(() -> {
                        for (int i = 1; i < 15; ++i) {
                            this.assertEquals(0L, this.producerAdd(i));
                        }
                        this.assertEquals(1L, this.producerAdd(15));
                    });
                    thread.start();
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        this.fail(e);
                    }
                    return true;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        });
        this.assertEquals(4L, this.producerAdd(0));
        int flags = this.queue.drain();
        this.assertFlagsSet(flags, 2, 4);
    }

    @Test
    public void testWritabilityListener() {
        AtomicInteger demand = new AtomicInteger(0);
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (demand.get() > 0) {
                demand.decrementAndGet();
                return true;
            }
            return false;
        });
        int count = 0;
        while ((this.queue.write((Object)count++) & 1) == 0) {
        }
        this.assertEquals(16L, count);
        demand.set(8);
        this.queue.drain();
        this.assertEquals(0L, demand.get());
        demand.set(1);
        this.assertFlagsSet(this.queue.drain(), 2, 4);
        this.assertEquals(0L, demand.get());
    }

    @Test
    public void testClear() {
        this.queue = new MessagePassingQueue.MpSc(elt -> false);
        for (int i = 0; i < 5; ++i) {
            this.queue.write((Object)i);
        }
        List buffered = this.queue.clear();
        this.assertEquals(MessagePassingQueueTest.range(0, 5), buffered);
    }

    @Test
    public void testReentrancy() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            switch (elt) {
                case 0: {
                    for (int i = 1; i < 15; ++i) {
                        this.assertEquals(0L, this.queue.write((Object)i));
                    }
                    int flags = this.queue.write((Object)16);
                    this.assertFlagsSet(flags, 1);
                    this.assertFlagsClear(flags, 2, 4);
                }
            }
            return true;
        });
        int flags = this.queue.write((Object)0);
        this.assertFlagsSet(flags, 2);
        this.assertFlagsClear(flags, 1, 4);
    }

    @Test
    public void testWeird() {
        AtomicInteger behavior = new AtomicInteger(0);
        this.queue = new MessagePassingQueue.MpSc<Integer>(elt -> {
            switch (behavior.get()) {
                case 0: {
                    return false;
                }
                case 1: {
                    for (int i = 1; i < 15; ++i) {
                        this.assertEquals(0L, this.producerAdd(i));
                    }
                    behavior.set(2);
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            throw new AssertionFailedError();
        }){

            protected void hook() {
                MessagePassingQueueTest.this.assertEquals(0L, MessagePassingQueueTest.this.producerAdd(15));
                MessagePassingQueueTest.this.assertEquals(1L, MessagePassingQueueTest.this.producerAdd(16));
            }
        };
        this.assertFlagsSet(4, this.queue.write((Object)0));
        behavior.set(1);
        int flags = this.queue.drain();
        this.assertFlagsSet(flags, 2);
        this.assertFlagsClear(flags, 4);
    }

    @Test
    public void testOrdering() {
        int[] hookRuns = new int[1];
        this.unwritableHook = () -> {
            hookRuns[0] = hookRuns[0] + 1;
            this.queue.write((Object)1);
        };
        AtomicInteger wqf = new AtomicInteger();
        this.queue = new MessagePassingQueue.MpSc(arg_0 -> this.lambda$testOrdering$21(wqf, arg_0));
        int flags = this.queue.write((Object)0);
        this.assertTrue((flags & 2) != 0);
        int count = MessagePassingQueue.numberOfUnwritableSignals((int)flags);
        this.assertEquals(0L, wqf.addAndGet(-count));
        this.assertEquals(2L, hookRuns[0]);
    }

    @Test
    public void testUnwritableCount() {
        AtomicInteger demand = new AtomicInteger();
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (demand.get() > 0) {
                demand.decrementAndGet();
                return true;
            }
            return false;
        });
        int count = 0;
        while ((this.producerAdd(count++) & 1) == 0) {
        }
        demand.set(1);
        this.assertFlagsSet(this.queue.drain(), 4);
        this.assertFlagsSet(this.producerAdd(count++), 1);
        demand.set(count - 1);
        int flags = this.queue.drain();
        this.assertFlagsSet(flags, 2);
        this.assertEquals(2L, MessagePassingQueue.numberOfUnwritableSignals((int)flags));
    }

    @Test
    public void testConditions() {
        this.queue = new MessagePassingQueue.MpSc(elt -> true, 1, 1);
        this.queue.write((Object)0);
        this.assertFlagsSet(this.producerAdd(0), 1, 4);
        this.assertFlagsSet(this.queue.drain(), 2);
        this.queue = new MessagePassingQueue.MpSc(elt -> true, 1, 2);
        this.assertEquals(0L, this.queue.write((Object)0));
        this.assertFlagsSet(this.queue.add((Object)0), 4);
        this.assertFlagsSet(this.queue.add((Object)1), 1);
        this.assertFlagsSet(this.queue.drain(), 2);
    }

    private void assertFlagsSet(int flags, int ... masks) {
        for (int mask : masks) {
            this.assertTrue("Expecting flag " + Integer.toBinaryString(mask) + " to be set", (flags & mask) != 0);
        }
    }

    private void assertFlagsClear(int flags, int ... masks) {
        for (int mask : masks) {
            this.assertTrue("Expecting flag " + Integer.toBinaryString(mask) + " to be clear", (flags & mask) == 0);
        }
    }

    private static List<Integer> range(int start, int end) {
        return IntStream.range(start, end).boxed().collect(Collectors.toList());
    }

    @Test
    public void testWriteShouldNotReturnUnwritableWithOverflowSubmissions() {
        this.queue = new MessagePassingQueue.MpSc(elt -> {
            if (elt == 0) {
                Thread th = new Thread(() -> {
                    int idx = 1;
                    while ((this.queue.add((Object)idx++) & 1) == 0) {
                    }
                });
                th.start();
                try {
                    th.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        });
        this.assertEquals(0L, this.queue.write((Object)0) & 1);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ boolean lambda$testOrdering$21(AtomicInteger wqf, Integer elt) {
        switch (elt) lbl-1000:
        // 2 sources

        {
            case 0: {
                if ((this.producerAdd(1) & 1) == 0) ** GOTO lbl-1000
                wqf.incrementAndGet();
                this.queue.write((Object)2);
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                this.queue.write((Object)3);
                return true;
            }
lbl15:
            // 2 sources

            case 3: {
                if ((this.producerAdd(4) & 1) == 0) ** GOTO lbl15
                wqf.incrementAndGet();
                return true;
            }
            case 4: {
                return true;
            }
        }
        throw new IllegalStateException();
    }
}

