/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.concurrent;

import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.internal.concurrent.OutboundMessageQueue;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public class OutboundMessageQueueTest
extends VertxTestBase {
    private List<Integer> output = Collections.synchronizedList(new ArrayList());
    private OutboundMessageQueue<Integer> queue;
    private EventExecutor eventLoop;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.disableThreadChecks();
        this.output = Collections.synchronizedList(new ArrayList());
        this.eventLoop = ((ContextInternal)this.vertx.getOrCreateContext()).executor();
    }

    @Test
    public void testReentrantWriteAccept() {
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){
            int reentrant;
            {
                this.reentrant = 0;
            }

            public boolean test(Integer msg) {
                OutboundMessageQueueTest.this.assertEquals(0L, this.reentrant++);
                try {
                    if (msg == 0) {
                        OutboundMessageQueueTest.this.assertTrue(this.write(1));
                    }
                    OutboundMessageQueueTest.this.output.add(msg);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    --this.reentrant;
                }
            }
        };
        this.eventLoop.execute(() -> {
            this.assertTrue(this.queue.write((Object)0));
            this.assertEquals(List.of(Integer.valueOf(0), Integer.valueOf(1)), this.output);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testReentrantWriteReject() {
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){
            int reentrant;
            {
                this.reentrant = 0;
            }

            public boolean test(Integer msg) {
                OutboundMessageQueueTest.this.assertEquals(0L, this.reentrant++);
                try {
                    if (msg == 0) {
                        OutboundMessageQueueTest.this.assertTrue(this.write(1));
                    }
                    OutboundMessageQueueTest.this.output.add(msg);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    --this.reentrant;
                }
            }
        };
        this.eventLoop.execute(() -> {
            this.assertTrue(this.queue.write((Object)0));
            this.assertEquals(List.of(Integer.valueOf(0)), this.output);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testReentrantOverflowThenDrain1() {
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){
            int reentrant;
            int draining;
            int drained;
            {
                this.reentrant = 0;
                this.draining = 0;
                this.drained = 0;
            }

            public boolean test(Integer msg) {
                OutboundMessageQueueTest.this.assertEquals(0L, this.reentrant++);
                OutboundMessageQueueTest.this.output.add(msg);
                try {
                    switch (msg) {
                        case 0: {
                            int count = 1;
                            while (this.write(count++)) {
                            }
                            OutboundMessageQueueTest.this.assertEquals(16L, count);
                            OutboundMessageQueueTest.this.assertEquals(0L, this.drained);
                            break;
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    --this.reentrant;
                }
            }

            protected void startDraining() {
                ++this.draining;
            }

            protected void stopDraining() {
                --this.draining;
            }

            protected void handleDrained() {
                ++this.drained;
                OutboundMessageQueueTest.this.assertEquals(0L, this.reentrant);
                OutboundMessageQueueTest.this.assertEquals(0L, this.draining);
                List expected = IntStream.range(0, 16).boxed().collect(Collectors.toList());
                OutboundMessageQueueTest.this.assertEquals(expected, OutboundMessageQueueTest.this.output);
                OutboundMessageQueueTest.this.testComplete();
            }
        };
        this.eventLoop.execute(() -> this.queue.write((Object)0));
        this.await();
    }

    @Test
    public void testReentrantOverflowThenDrain2() {
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){
            int reentrant;
            int draining;
            int drained;
            {
                this.reentrant = 0;
                this.draining = 0;
                this.drained = 0;
            }

            public boolean test(Integer msg) {
                OutboundMessageQueueTest.this.assertEquals(0L, this.reentrant++);
                OutboundMessageQueueTest.this.output.add(msg);
                try {
                    switch (msg) {
                        case 0: {
                            int count = 1;
                            while (this.write(count++)) {
                            }
                            OutboundMessageQueueTest.this.assertEquals(16L, count);
                            OutboundMessageQueueTest.this.assertEquals(0L, this.drained);
                            break;
                        }
                        case 15: {
                            int count = 16;
                            while (this.write(count++)) {
                            }
                            OutboundMessageQueueTest.this.assertEquals(17L, count);
                            OutboundMessageQueueTest.this.assertEquals(0L, this.drained);
                            break;
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    --this.reentrant;
                }
            }

            protected void startDraining() {
                ++this.draining;
            }

            protected void stopDraining() {
                --this.draining;
            }

            protected void handleDrained() {
                ++this.drained;
                OutboundMessageQueueTest.this.assertEquals(0L, this.reentrant);
                OutboundMessageQueueTest.this.assertEquals(0L, this.draining);
                List expected = IntStream.range(0, 17).boxed().collect(Collectors.toList());
                OutboundMessageQueueTest.this.assertEquals(expected, OutboundMessageQueueTest.this.output);
                OutboundMessageQueueTest.this.testComplete();
            }
        };
        this.eventLoop.execute(() -> this.queue.write((Object)0));
        this.await();
    }

    @Test
    public void testReentrantTryDrain() {
        final AtomicBoolean overflow = new AtomicBoolean();
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){
            int draining;

            protected void startDraining() {
                OutboundMessageQueueTest.this.assertEquals(0L, this.draining++);
            }

            protected void stopDraining() {
                --this.draining;
            }

            public boolean test(Integer msg) {
                if (overflow.get()) {
                    OutboundMessageQueueTest.this.queue.tryDrain();
                }
                return false;
            }
        };
        this.eventLoop.execute(() -> {
            int count = 1;
            while (this.queue.write((Object)count++)) {
            }
            this.eventLoop.execute(() -> {
                overflow.set(true);
                this.queue.tryDrain();
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWriteAfterDrain() {
        final AtomicBoolean paused = new AtomicBoolean();
        final AtomicInteger count = new AtomicInteger();
        final AtomicInteger test = new AtomicInteger();
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){

            protected void handleDrained() {
                int msg = count.getAndIncrement();
                this.write(msg);
                OutboundMessageQueueTest.this.assertEquals(msg, test.get());
                OutboundMessageQueueTest.this.testComplete();
            }

            public boolean test(Integer msg) {
                test.set(msg);
                return !paused.get();
            }
        };
        this.eventLoop.execute(() -> {
            paused.set(true);
            while (this.queue.write((Object)count.getAndIncrement())) {
            }
            paused.set(false);
            this.queue.tryDrain();
        });
        this.await();
    }

    @Test
    public void testReentrantClose() {
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){

            public boolean test(Integer msg) {
                if (msg == 0) {
                    this.write(1);
                    this.close();
                    this.write(2);
                    OutboundMessageQueueTest.this.assertEquals(List.of(Integer.valueOf(2)), OutboundMessageQueueTest.this.output);
                    return true;
                }
                return false;
            }

            protected void handleDispose(Integer elt) {
                OutboundMessageQueueTest.this.output.add(elt);
            }
        };
        this.eventLoop.execute(() -> {
            this.queue.write((Object)0);
            this.assertEquals(List.of(Integer.valueOf(2), Integer.valueOf(1)), this.output);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseWhileDrainScheduled() {
        final AtomicInteger drains = new AtomicInteger();
        this.queue = new OutboundMessageQueue<Integer>(this.eventLoop){

            public boolean test(Integer msg) {
                return false;
            }

            protected void startDraining() {
                drains.incrementAndGet();
            }
        };
        this.eventLoop.execute(() -> {
            Thread thread = new Thread(() -> {
                int idx = 0;
                while (this.queue.write((Object)idx++)) {
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.queue.close();
            this.eventLoop.execute(() -> {
                this.assertEquals(0L, drains.get());
                this.testComplete();
            });
        });
        this.await();
    }
}

