/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.context;

import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.WorkerPool;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.junit.Test;

public class ContextTaskTest
extends VertxTestBase {
    private ExecutorService workerExecutor;

    @Override
    public void setUp() throws Exception {
        this.workerExecutor = Executors.newFixedThreadPool(2, r -> new VertxThread(r, "vert.x-worker-thread", true, 10L, TimeUnit.SECONDS));
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.workerExecutor.shutdown();
        super.tearDown();
    }

    private ContextInternal createEventLoopContext() {
        return ((VertxInternal)this.vertx).createEventLoopContext();
    }

    private ContextInternal createWorkerContext() {
        return ((VertxInternal)this.vertx).contextBuilder().withThreadingModel(ThreadingModel.WORKER).withCloseFuture(new CloseFuture()).withWorkerPool(new WorkerPool(this.workerExecutor, null)).withClassLoader(Thread.currentThread().getContextClassLoader()).build();
    }

    @Test
    public void testEventLoopDispatchFromSameContext() {
        this.testOpFromSameContext(Op.DISPATCH, this::createEventLoopContext);
    }

    @Test
    public void testEventLoopScheduleFromSameContext() {
        this.testOpFromSameContext(Op.SCHEDULE, this::createEventLoopContext);
    }

    @Test
    public void testWorkerDispatchFromSameContext() {
        this.testOpFromSameContext(Op.DISPATCH, this::createWorkerContext);
    }

    @Test
    public void testWorkerScheduleFromSameContext() {
        this.testOpFromSameContext(Op.SCHEDULE, this::createWorkerContext);
    }

    private void testOpFromSameContext(Op op, Supplier<ContextInternal> contextSupplier) {
        this.waitFor(2);
        ContextInternal ctx = contextSupplier.get();
        ctx.runOnContext(v1 -> {
            Thread thread = Thread.currentThread();
            AtomicBoolean flag = new AtomicBoolean(true);
            op.exec(ctx, (Handler<Void>)((Handler)v2 -> {
                this.assertSame(ctx, Vertx.currentContext());
                this.assertSame(thread, Thread.currentThread());
                this.assertTrue(flag.get());
                this.complete();
            }));
            flag.set(false);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testEventLoopDispatchFromSameEventLoop() {
        this.testOpFromSameEventLoop(Op.DISPATCH, this::createEventLoopContext);
    }

    @Test
    public void testEventLoopScheduleFromSameEventLoop() {
        this.testOpFromSameEventLoop(Op.SCHEDULE, this::createEventLoopContext);
    }

    @Test
    public void testWorkerDispatchFromSameEventLoop() {
        this.testOpFromSameEventLoop(Op.DISPATCH, this::createWorkerContext);
    }

    @Test
    public void testWorkerScheduleFromSameEventLoop() {
        this.testOpFromSameEventLoop(Op.SCHEDULE, this::createWorkerContext);
    }

    @Test
    public void testWorkerEmitFromSameEventLoop() {
    }

    private void testOpFromSameEventLoop(Op op, Supplier<ContextInternal> contextSupplier) {
        this.waitFor(2);
        ContextInternal ctx = contextSupplier.get();
        ctx.nettyEventLoop().execute(() -> {
            this.assertNull(Vertx.currentContext());
            AtomicBoolean flag = new AtomicBoolean(true);
            op.exec(ctx, (Handler<Void>)((Handler)v2 -> {
                if (op == Op.SCHEDULE) {
                    this.assertNull(Vertx.currentContext());
                } else {
                    this.assertSame(ctx, Vertx.currentContext());
                }
                if (ctx.isEventLoopContext()) {
                    this.assertTrue(flag.get());
                } else {
                    ContextTaskTest.waitUntil(() -> !flag.get());
                }
                this.complete();
            }));
            flag.set(false);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testEventLoopDispatchFromAnotherEventLoop() {
        this.testOpFromAnotherEventLoop(ContextInternal::emit, this::createEventLoopContext, false);
    }

    @Test
    public void testEventLoopScheduleFromAnotherEventLoop() {
        this.testOpFromAnotherEventLoop(ContextInternal::execute, this::createEventLoopContext, true);
    }

    @Test
    public void testWorkerDispatchFromAnotherEventLoop() {
        this.testOpFromAnotherEventLoop(ContextInternal::emit, this::createWorkerContext, false);
    }

    @Test
    public void testWorkerScheduleFromAnotherEventLoop() {
        this.testOpFromAnotherEventLoop(ContextInternal::execute, this::createWorkerContext, true);
    }

    private void testOpFromAnotherEventLoop(BiConsumer<ContextInternal, Handler<Void>> op, Supplier<ContextInternal> contextSupplier, boolean isSchedule) {
        this.waitFor(2);
        ContextInternal ctx = contextSupplier.get();
        this.createEventLoopContext().nettyEventLoop().execute(() -> {
            op.accept(ctx, v2 -> {
                if (isSchedule) {
                    this.assertNull(Vertx.currentContext());
                } else {
                    this.assertSame(ctx, Vertx.currentContext());
                }
                this.complete();
            });
            this.complete();
        });
        this.await();
    }

    @Test
    public void testEventLoopDispatchFromSchedule() {
        this.testOpFromSameSchedule(Op.DISPATCH, this::createEventLoopContext);
    }

    @Test
    public void testEventLoopScheduleFromSchedule() {
        this.testOpFromSameSchedule(Op.SCHEDULE, this::createEventLoopContext);
    }

    @Test
    public void testWorkerDispatchFromSchedule() {
        this.testOpFromSameSchedule(Op.DISPATCH, this::createWorkerContext);
    }

    @Test
    public void testWorkerScheduleFromSchedule() {
        this.testOpFromSameSchedule(Op.SCHEDULE, this::createWorkerContext);
    }

    private void testOpFromSameSchedule(Op op, Supplier<ContextInternal> contextSupplier) {
        this.waitFor(2);
        ContextInternal ctx = contextSupplier.get();
        ctx.execute(v1 -> {
            Thread thread = Thread.currentThread();
            AtomicBoolean flag = new AtomicBoolean(true);
            op.exec(ctx, (Handler<Void>)((Handler)v2 -> {
                if (op == Op.SCHEDULE) {
                    this.assertNull(Vertx.currentContext());
                } else {
                    this.assertSame(ctx, Vertx.currentContext());
                }
                this.assertSame(thread, Thread.currentThread());
                this.assertTrue(flag.get());
                this.complete();
            }));
            flag.set(false);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testEventLoopDispatchFromAnotherThread() {
        this.testOpFromAnotherThread(ContextInternal::emit, this::createEventLoopContext, false);
    }

    @Test
    public void testEventLoopScheduleFromAnotherThread() {
        this.testOpFromAnotherThread(ContextInternal::execute, this::createEventLoopContext, true);
    }

    @Test
    public void testWorkerDispatchFromAnotherThread() {
        this.testOpFromAnotherThread(ContextInternal::emit, this::createWorkerContext, false);
    }

    @Test
    public void testWorkerScheduleFromAnotherThread() {
        this.testOpFromAnotherThread(ContextInternal::execute, this::createWorkerContext, true);
    }

    private void testOpFromAnotherThread(BiConsumer<ContextInternal, Handler<Void>> op, Supplier<ContextInternal> contextSupplier, boolean expectNullContext) {
        this.waitFor(1);
        ContextInternal ctx = contextSupplier.get();
        Thread current = Thread.currentThread();
        op.accept(ctx, (Handler<Void>)((Handler)v2 -> {
            if (expectNullContext) {
                this.assertNull(Vertx.currentContext());
            } else {
                this.assertSame(ctx, Vertx.currentContext());
            }
            this.assertNotSame(current, Thread.currentThread());
            this.complete();
        }));
        this.await();
    }

    static enum Op {
        SCHEDULE{

            @Override
            void exec(ContextInternal ctx, Handler<Void> task) {
                ctx.execute(task);
            }
        }
        ,
        DISPATCH{

            @Override
            void exec(ContextInternal ctx, Handler<Void> task) {
                ctx.emit(task);
            }
        };


        abstract void exec(ContextInternal var1, Handler<Void> var2);
    }
}

