/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.context;

import io.vertx.core.Context;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.test.core.AsyncTestBase;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.junit.Test;

public class EventExecutorProviderTest
extends AsyncTestBase {
    @Test
    public void testExecuteTasks() {
        ConcurrentLinkedDeque toRun = new ConcurrentLinkedDeque();
        VertxBootstrap bootstrap = VertxBootstrap.create();
        bootstrap.eventExecutorProvider(thread -> toRun::add);
        bootstrap.init();
        Vertx vertx = bootstrap.vertx();
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        this.assertEquals(ThreadingModel.EXTERNAL, ctx.threadingModel());
        this.assertEquals(0L, toRun.size());
        int[] cnt = new int[1];
        ctx.runOnContext(v -> {
            this.assertTrue(ctx.inThread());
            this.assertSame(ctx, Vertx.currentContext());
            this.assertSame(ctx, vertx.getOrCreateContext());
            cnt[0] = cnt[0] + 1;
        });
        this.assertEquals(1L, toRun.size());
        ((Runnable)toRun.pop()).run();
        this.assertEquals(1L, cnt[0]);
        this.assertNull(Vertx.currentContext());
    }

    @Test
    public void testEventExecutorReturnsNull() {
        VertxBootstrap bootstrap = VertxBootstrap.create();
        bootstrap.eventExecutorProvider(thread -> null);
        bootstrap.init();
        Vertx vertx = bootstrap.vertx();
        Context ctx = vertx.getOrCreateContext();
        this.assertEquals(ThreadingModel.EVENT_LOOP, ctx.threadingModel());
    }
}

