/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.context;

import io.netty.channel.EventLoop;
import io.vertx.core.Context;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.impl.LocalSeq;
import io.vertx.core.impl.ShadowContext;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.WorkerExecutorInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.impl.NetServerInternal;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.faketracer.FakeTracer;
import io.vertx.test.faketracer.Span;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class ShadowContextTest
extends AsyncTestBase {
    ContextLocal<Object> contextLocal;
    VertxInternal callerVertx;
    VertxInternal calleeVertx;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.contextLocal = ContextLocal.registerLocal(Object.class);
        this.callerVertx = (VertxInternal)VertxBootstrap.create().init().enableShadowContext(true).vertx();
        this.calleeVertx = (VertxInternal)Vertx.vertx();
        this.disableThreadChecks();
    }

    @Override
    protected void tearDown() throws Exception {
        this.awaitFuture(this.calleeVertx.close());
        this.awaitFuture(this.callerVertx.close());
        LocalSeq.reset();
        super.tearDown();
    }

    @Test
    public void testGetOrCreateEventLoop() {
        ContextInternal callerCtx = this.callerVertx.createEventLoopContext();
        this.testGetOrCreate(callerCtx);
    }

    @Test
    public void testGetOrCreateWorker() {
        ContextInternal callerCtx = this.callerVertx.createWorkerContext();
        this.testGetOrCreate(callerCtx);
    }

    private void testGetOrCreate(ContextInternal callerCtx) {
        callerCtx.runOnContext(v1 -> {
            ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
            this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
            this.assertNotSame(calleeCtx, callerCtx);
            this.assertNotSame(calleeCtx.nettyEventLoop(), callerCtx.nettyEventLoop());
            this.assertEquals(ThreadingModel.EXTERNAL, calleeCtx.threadingModel());
            calleeCtx.runOnContext(v2 -> {
                this.assertTrue(callerCtx.inThread());
                this.assertSame(calleeCtx, this.calleeVertx.getOrCreateContext());
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testGetOrCreateDefaultBehavior() {
        try (VertxInternal callerVertx = (VertxInternal)Vertx.vertx();){
            ContextInternal callerCtx = callerVertx.getOrCreateContext();
            callerCtx.runOnContext(v1 -> {
                Thread expected = Thread.currentThread();
                ContextInternal noncalleeCtx = this.calleeVertx.getOrCreateContext();
                this.assertSame(callerCtx, callerVertx.getOrCreateContext());
                this.assertNotSame(noncalleeCtx, callerCtx);
                this.assertNotSame(noncalleeCtx.nettyEventLoop(), callerCtx.nettyEventLoop());
                this.assertEquals(ThreadingModel.EVENT_LOOP, noncalleeCtx.threadingModel());
                noncalleeCtx.runOnContext(v2 -> {
                    this.assertNotSame(expected, Thread.currentThread());
                    this.assertSame(noncalleeCtx, this.calleeVertx.getOrCreateContext());
                    this.assertNotSame(callerCtx, callerVertx.getOrCreateContext());
                    this.testComplete();
                });
            });
            this.await();
        }
    }

    @Test
    public void testEmitFromOriginatingThread() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(v1 -> {
            ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
            AtomicBoolean inThread = new AtomicBoolean(true);
            calleeCtx.emit(v2 -> {
                this.assertSame(calleeCtx, Vertx.currentContext());
                this.assertTrue(inThread.get());
                this.testComplete();
            });
            inThread.set(false);
        });
        this.await();
    }

    @Test
    public void testEmitFromEventLoop() {
        ContextInternal eventLoop = this.calleeVertx.getOrCreateContext();
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(arg_0 -> this.lambda$testEmitFromEventLoop$9((Context)eventLoop, arg_0));
        this.await();
    }

    @Test
    public void testThreadingModel() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(v1 -> {
            ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
            this.assertEquals(ThreadingModel.EXTERNAL, calleeCtx.threadingModel());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPiggyBack() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(arg_0 -> this.lambda$testPiggyBack$14((Context)callerCtx, arg_0));
        this.await();
    }

    @Test
    public void testStickyEventLoop() {
        AtomicReference eventLoop1 = new AtomicReference();
        AtomicReference eventLoop2 = new AtomicReference();
        ContextInternal ctx1 = this.callerVertx.getOrCreateContext();
        ContextInternal ctx2 = this.callerVertx.getOrCreateContext();
        ctx1.runOnContext(v1 -> {
            ContextInternal ctx = this.calleeVertx.getOrCreateContext();
            eventLoop1.set(ctx.nettyEventLoop());
            this.complete();
        });
        ctx2.runOnContext(v1 -> {
            ContextInternal ctx = this.calleeVertx.getOrCreateContext();
            eventLoop2.set(ctx.nettyEventLoop());
        });
        ShadowContextTest.assertWaitUntil(() -> eventLoop1.get() != null && eventLoop2.get() != null);
        Assert.assertSame(eventLoop1.get(), eventLoop2.get());
    }

    @Test
    public void testHttpClient() throws Exception {
        HttpServer server = this.calleeVertx.createHttpServer().requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true);
            for (int i = 0; i < 8; ++i) {
                resp.write("chunk-" + i);
            }
            resp.end();
        });
        this.awaitFuture(server.listen(8080, "localhost"));
        HttpClientAgent client = this.calleeVertx.createHttpClient();
        ContextInternal ctx = this.callerVertx.getOrCreateContext();
        ctx.runOnContext(arg_0 -> this.lambda$testHttpClient$23(client, (Context)ctx, arg_0));
        this.await();
    }

    @Test
    public void testHttpServer() throws Exception {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        CountDownLatch latch = new CountDownLatch(1);
        callerCtx.runOnContext(arg_0 -> this.lambda$testHttpServer$26((Context)callerCtx, latch, arg_0));
        this.awaitLatch(latch);
        HttpClientAgent client = this.calleeVertx.createHttpClient();
        Future fut = client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost")).compose(req -> req.send().compose(HttpClientResponse::body));
        Buffer body = (Buffer)this.awaitFuture(fut);
        this.assertEquals("Hello World", body.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSegregatedHttpProxy() throws Exception {
        Vertx vertx = Vertx.vertx();
        try {
            HttpServer server = vertx.createHttpServer().requestHandler(req -> req.response().end("Hello World"));
            this.awaitFuture(server.listen(8081, "localhost"));
            HttpClientAgent client = vertx.createHttpClient();
            Set clientProxyContexts = Collections.synchronizedSet(new HashSet());
            HttpClientAgent clientProxy = this.calleeVertx.httpClientBuilder().withConnectHandler(conn -> clientProxyContexts.add(Vertx.currentContext())).build();
            HttpServer serverProxy = this.callerVertx.createHttpServer().requestHandler(inboundReq -> {
                ContextInternal callerCtx = this.callerVertx.getContext();
                inboundReq.body().compose(body -> clientProxy.request(inboundReq.method(), 8081, "localhost", inboundReq.uri()).compose(outboundReq -> outboundReq.send(body).compose(HttpClientResponse::body))).onComplete(ar -> {
                    this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                    ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
                    this.assertNotSame(callerCtx, calleeCtx);
                    if (ar.succeeded()) {
                        inboundReq.response().end((Buffer)ar.result());
                    } else {
                        inboundReq.response().setStatusCode(500).end();
                    }
                });
            });
            this.awaitFuture(serverProxy.listen(8080, "localhost"));
            Future fut = client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost")).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body));
            Buffer body = (Buffer)this.awaitFuture(fut);
            this.assertEquals("Hello World", body.toString());
            this.assertEquals(1L, clientProxyContexts.size());
        }
        finally {
            this.awaitFuture(vertx.close());
        }
    }

    @Test
    public void testNetSocketClient() throws Exception {
        int num = 8;
        this.waitFor(10);
        NetServerInternal server = this.calleeVertx.createNetServer().connectHandler(so -> {
            Buffer received = Buffer.buffer();
            so.handler(buff -> {
                received.appendBuffer(buff);
                if (received.length() == num * "msg-x".length()) {
                    so.write((Object)received);
                    this.calleeVertx.setTimer(10L, id -> so.end());
                }
            });
        });
        this.awaitFuture(server.listen(1234, "localhost"));
        NetClient client = this.calleeVertx.createNetClient();
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(arg_0 -> this.lambda$testNetSocketClient$42(client, (Context)callerCtx, num, arg_0));
        this.await();
    }

    @Test
    public void testSetTimer() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(v1 -> {
            Thread expected = Thread.currentThread();
            this.calleeVertx.setTimer(100L, id -> {
                this.assertSame(expected, Thread.currentThread());
                this.assertEquals(ThreadingModel.EXTERNAL, Vertx.currentContext().threadingModel());
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testEventBus() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        EventBus eventBus = this.calleeVertx.eventBus();
        eventBus.consumer("the-address", msg -> msg.reply(msg.body()));
        callerCtx.runOnContext(v1 -> {
            Thread expected = Thread.currentThread();
            eventBus.request("the-address", (Object)"msg").onComplete(this.onSuccess(reply -> {
                this.assertSame(expected, Thread.currentThread());
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                ContextInternal shadow = this.calleeVertx.getOrCreateContext();
                this.assertNotSame(callerCtx, shadow);
                this.assertSame(Vertx.currentContext(), shadow);
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testPeriodic() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(v -> this.calleeVertx.setPeriodic(10L, id -> {
            ContextInternal callbackCtx = this.callerVertx.getOrCreateContext();
            this.assertTrue(callbackCtx.isDuplicate());
            this.assertSame(callerCtx, callbackCtx.unwrap());
            this.assertSame(callerCtx.nettyEventLoop(), callbackCtx.nettyEventLoop());
            ContextInternal calleeCtx = (ContextInternal)Vertx.currentContext();
            this.assertEquals(ThreadingModel.EXTERNAL, calleeCtx.threadingModel());
            this.assertTrue(calleeCtx.isDuplicate());
            ContextInternal shadowUnwrapCtx = calleeCtx.unwrap();
            this.assertFalse(shadowUnwrapCtx.isDuplicate());
            this.assertTrue(this.calleeVertx.cancelTimer(id.longValue()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testTracePropagation() throws Exception {
        FakeTracer tracer = new FakeTracer();
        this.awaitFuture(this.callerVertx.close());
        this.callerVertx = (VertxInternal)VertxBootstrap.create().tracerFactory(options -> tracer).enableShadowContext(true).init().vertx();
        Span rootSpan = tracer.newTrace();
        HttpServer server = this.calleeVertx.createHttpServer().requestHandler(req -> req.response().end());
        this.awaitFuture(server.listen(8080, "localhost"));
        HttpClientAgent client = this.calleeVertx.createHttpClient();
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(v -> {
            tracer.activate(rootSpan);
            client.request(HttpMethod.GET, 8080, "localhost", "/").compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> this.testComplete()));
        });
        this.await();
        ShadowContextTest.waitUntil(() -> tracer.getFinishedSpans().size() == 1);
        Span span = tracer.getFinishedSpans().get(0);
        Assert.assertEquals((Object)SpanKind.RPC, (Object)span.kind);
        Assert.assertEquals((long)span.traceId, (long)rootSpan.traceId);
        Assert.assertEquals((long)span.parentId, (long)rootSpan.id);
    }

    @Test
    public void testContextLocalData() {
        Object expected = new Object();
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.putLocal(this.contextLocal, AccessMode.CONCURRENT, expected);
        callerCtx.runOnContext(v -> this.callerVertx.runOnContext(v2 -> {
            ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
            this.assertSame(expected, calleeCtx.getLocal(this.contextLocal));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testContextData() {
        Object expected = new Object();
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.put((Object)"key", expected);
        callerCtx.runOnContext(v -> this.callerVertx.runOnContext(v2 -> {
            ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
            this.assertSame(expected, calleeCtx.get((Object)"key"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDuplication1() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(v -> {
            ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
            ContextInternal shadowDuplicateCtx = calleeCtx.duplicate();
            this.assertEquals(ThreadingModel.EXTERNAL, shadowDuplicateCtx.threadingModel());
            this.assertTrue(shadowDuplicateCtx.isDuplicate());
            ContextInternal shadowUnwrapCtx = shadowDuplicateCtx.unwrap();
            shadowUnwrapCtx.runOnContext(v2 -> {
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDuplication2() {
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        ContextInternal duplicateCtx = callerCtx.duplicate();
        duplicateCtx.runOnContext(v1 -> {
            ContextInternal shadowOfDuplicateCtx = this.calleeVertx.getOrCreateContext();
            this.assertTrue(shadowOfDuplicateCtx.isDuplicate());
            shadowOfDuplicateCtx.unwrap().runOnContext(v2 -> {
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testGetOrCreateContextFromUnassociatedEventLoopThread() {
        EventLoop executor = this.callerVertx.nettyEventLoopGroup().next();
        this.testGetOrCreateContextFromUnassociatedThread((Executor)executor);
    }

    @Test
    public void testGetOrCreateContextFromUnassociatedWorkerThread() {
        ExecutorService executor = this.callerVertx.workerPool().executor();
        this.testGetOrCreateContextFromUnassociatedThread(executor);
    }

    private void testGetOrCreateContextFromUnassociatedThread(Executor executor) {
        executor.execute(() -> {
            ContextInternal ctx = this.calleeVertx.getOrCreateContext();
            this.assertSame(ctx.owner(), this.calleeVertx);
            this.assertEquals(ThreadingModel.EVENT_LOOP, ctx.threadingModel());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testWorkerExecutorExecuteBlocking() {
        WorkerExecutorInternal exec = this.calleeVertx.createSharedWorkerExecutor("abc");
        ContextInternal callerCtx = this.callerVertx.getOrCreateContext();
        callerCtx.runOnContext(arg_0 -> this.lambda$testWorkerExecutorExecuteBlocking$67((WorkerExecutor)exec, callerCtx, arg_0));
        this.await();
    }

    private /* synthetic */ void lambda$testWorkerExecutorExecuteBlocking$67(WorkerExecutor exec, ContextInternal callerCtx, Void v1) {
        Thread expected = Thread.currentThread();
        ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
        Future fut = exec.executeBlocking(() -> {
            ShadowContext ctx = (ShadowContext)Vertx.currentContext();
            this.assertNotSame(calleeCtx, ctx);
            this.assertSame(callerCtx, ctx.delegate());
            this.assertSame(calleeCtx.owner(), this.calleeVertx);
            return ctx;
        });
        fut.onComplete(this.onSuccess(res -> {
            ShadowContext ctx = (ShadowContext)Vertx.currentContext();
            this.assertSame(res, ctx);
            this.assertSame(calleeCtx.owner(), this.calleeVertx);
            this.assertSame(expected, Thread.currentThread());
            this.testComplete();
        }));
    }

    private /* synthetic */ void lambda$testNetSocketClient$42(NetClient client, Context callerCtx, int num, Void v1) {
        Thread expected = Thread.currentThread();
        client.connect(1234, "localhost").onComplete(this.onSuccess(so -> {
            Context shadow = Vertx.currentContext();
            this.assertEquals(ThreadingModel.EXTERNAL, shadow.threadingModel());
            this.assertSame(shadow, this.calleeVertx.getOrCreateContext());
            this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
            this.assertSame(expected, Thread.currentThread());
            for (int i = 0; i < num; ++i) {
                so.write("msg-" + num).onComplete(this.onSuccess(v2 -> {
                    this.assertSame(shadow, this.calleeVertx.getOrCreateContext());
                    this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                    this.assertSame(expected, Thread.currentThread());
                    this.complete();
                }));
            }
            so.handler(buff -> {
                this.assertSame(shadow, this.calleeVertx.getOrCreateContext());
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                this.assertSame(expected, Thread.currentThread());
                this.complete();
            });
            so.endHandler(v -> {
                this.assertSame(shadow, this.calleeVertx.getOrCreateContext());
                this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
                this.assertSame(expected, Thread.currentThread());
                this.complete();
            });
        }));
    }

    private /* synthetic */ void lambda$testHttpServer$26(Context callerCtx, CountDownLatch latch, Void v1) {
        HttpServer server = this.calleeVertx.createHttpServer().requestHandler(req -> {
            ContextInternal shadowDuplicate = this.calleeVertx.getOrCreateContext();
            this.assertEquals(ThreadingModel.EXTERNAL, shadowDuplicate.threadingModel());
            this.assertTrue(shadowDuplicate.isDuplicate());
            ContextInternal shadowDuplicateUnwrap = shadowDuplicate.unwrap();
            this.assertEquals(ThreadingModel.EXTERNAL, shadowDuplicateUnwrap.threadingModel());
            this.assertFalse(shadowDuplicateUnwrap.isDuplicate());
            ContextInternal duplicate = this.callerVertx.getOrCreateContext();
            this.assertTrue(duplicate.isDuplicate());
            this.assertSame(callerCtx, duplicate.unwrap());
            HttpServerResponse resp = req.response();
            resp.end("Hello World");
        });
        server.listen(8080, "localhost").onComplete(this.onSuccess(v -> {
            this.assertSame(callerCtx, this.callerVertx.getOrCreateContext());
            latch.countDown();
        }));
    }

    private /* synthetic */ void lambda$testHttpClient$23(HttpClientAgent client, Context ctx, Void v1) {
        Thread expected = Thread.currentThread();
        client.request(HttpMethod.GET, 8080, "localhost", "/").onComplete(this.onSuccess(req -> {
            Context shadow = Vertx.currentContext();
            this.assertEquals(ThreadingModel.EXTERNAL, shadow.threadingModel());
            this.assertSame(shadow, this.calleeVertx.getOrCreateContext());
            this.assertSame(expected, Thread.currentThread());
            this.assertSame(ctx, this.callerVertx.getOrCreateContext());
            req.send().onComplete(this.onSuccess(resp -> {
                this.assertSame(expected, Thread.currentThread());
                this.assertSame(ctx, this.callerVertx.getOrCreateContext());
                AtomicInteger idx = new AtomicInteger();
                resp.handler(buff -> {
                    this.assertSame(expected, Thread.currentThread());
                    this.assertSame(ctx, this.callerVertx.getOrCreateContext());
                    this.assertEquals("chunk-" + idx.getAndIncrement(), buff.toString());
                });
                resp.endHandler(v2 -> {
                    this.assertSame(expected, Thread.currentThread());
                    this.assertSame(ctx, this.callerVertx.getOrCreateContext());
                    this.testComplete();
                });
            }));
        }));
    }

    private /* synthetic */ void lambda$testPiggyBack$14(Context callerCtx, Void v1) {
        this.calleeVertx.runOnContext(v2 -> {
            ContextInternal shadowContext = this.calleeVertx.getOrCreateContext();
            this.assertSame(shadowContext, Vertx.currentContext());
            this.calleeVertx.runOnContext(arg_0 -> this.lambda$testPiggyBack$12((Context)shadowContext, callerCtx, arg_0));
        });
    }

    private /* synthetic */ void lambda$testPiggyBack$12(Context shadowContext, Context callerCtx, Void v3) {
        this.assertSame(shadowContext, Vertx.currentContext());
        this.callerVertx.runOnContext(v -> {
            this.assertSame(callerCtx, Vertx.currentContext());
            this.testComplete();
        });
    }

    private /* synthetic */ void lambda$testEmitFromEventLoop$9(Context eventLoop, Void v1) {
        ContextInternal calleeCtx = this.calleeVertx.getOrCreateContext();
        AtomicBoolean inThread = new AtomicBoolean(true);
        eventLoop.runOnContext(v -> {
            calleeCtx.emit(v2 -> {
                this.assertSame(calleeCtx, Vertx.currentContext());
                ShadowContextTest.assertWaitUntil(() -> !inThread.get());
                this.testComplete();
            });
            inThread.set(false);
        });
    }
}

