/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.deployment;

import io.netty.channel.EventLoop;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.tests.deployment.TestVerticle;
import io.vertx.tests.deployment.TestVerticle2;
import io.vertx.tests.deployment.TestVerticle3;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.Ignore;
import org.junit.Test;

public class DeploymentTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestVerticle.instanceCount.set(0);
    }

    @Test
    public void testOptions() {
        DeploymentOptions options = new DeploymentOptions();
        this.assertNull(options.getConfig());
        JsonObject config = new JsonObject().put("foo", (Object)"bar").put("obj", (Object)new JsonObject().put("quux", (Object)123));
        this.assertEquals(options, options.setConfig(config));
        this.assertEquals(config, options.getConfig());
        String rand = TestUtils.randomUnicodeString(1000);
        this.assertFalse(options.isHa());
        this.assertEquals(options, options.setHa(true));
        this.assertTrue(options.isHa());
        String workerPoolName = TestUtils.randomAlphaString(10);
        this.assertEquals(options, options.setWorkerPoolName(workerPoolName));
        this.assertEquals(workerPoolName, options.getWorkerPoolName());
        int workerPoolSize = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setWorkerPoolSize(workerPoolSize));
        this.assertEquals(workerPoolSize, options.getWorkerPoolSize());
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setMaxWorkerExecuteTime(maxWorkerExecuteTime));
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
        this.assertEquals(options, options.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS));
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getMaxWorkerExecuteTimeUnit());
    }

    @Test
    public void testCopyOptions() {
        DeploymentOptions options = new DeploymentOptions();
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        Random rand = new Random();
        boolean worker = rand.nextBoolean();
        String isolationGroup = TestUtils.randomAlphaString(100);
        boolean ha = rand.nextBoolean();
        List<String> cp = Arrays.asList("foo", "bar");
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        String poolName = TestUtils.randomAlphaString(10);
        int poolSize = TestUtils.randomPositiveInt();
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        options.setConfig(config);
        options.setHa(ha);
        options.setWorkerPoolName(poolName);
        options.setWorkerPoolSize(poolSize);
        options.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        options.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        DeploymentOptions copy = new DeploymentOptions(options);
        this.assertNotSame(config, copy.getConfig());
        this.assertEquals("bar", copy.getConfig().getString("foo"));
        this.assertEquals(ha, copy.isHa());
        this.assertEquals(poolName, copy.getWorkerPoolName());
        this.assertEquals(poolSize, copy.getWorkerPoolSize());
        this.assertEquals(maxWorkerExecuteTime, copy.getMaxWorkerExecuteTime());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)copy.getMaxWorkerExecuteTimeUnit());
    }

    @Test
    public void testDefaultJsonOptions() {
        DeploymentOptions def = new DeploymentOptions();
        DeploymentOptions json = new DeploymentOptions(new JsonObject());
        this.assertEquals(def.getConfig(), json.getConfig());
        this.assertEquals(def.isHa(), json.isHa());
        this.assertEquals(def.getWorkerPoolName(), json.getWorkerPoolName());
        this.assertEquals(def.getWorkerPoolSize(), json.getWorkerPoolSize());
        this.assertEquals(def.getMaxWorkerExecuteTime(), json.getMaxWorkerExecuteTime());
        this.assertEquals((Object)def.getMaxWorkerExecuteTimeUnit(), (Object)json.getMaxWorkerExecuteTimeUnit());
    }

    @Test
    public void testJsonOptions() {
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        Random rand = new Random();
        boolean worker = rand.nextBoolean();
        boolean ha = rand.nextBoolean();
        List<String> cp = Arrays.asList("foo", "bar");
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        String poolName = TestUtils.randomAlphaString(10);
        int poolSize = TestUtils.randomPositiveInt();
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        JsonObject json = new JsonObject();
        json.put("config", (Object)config);
        json.put("worker", (Object)worker);
        json.put("ha", (Object)ha);
        json.put("workerPoolName", (Object)poolName);
        json.put("workerPoolSize", (Object)poolSize);
        json.put("maxWorkerExecuteTime", (Object)maxWorkerExecuteTime);
        json.put("maxWorkerExecuteTimeUnit", (Object)maxWorkerExecuteTimeUnit);
        DeploymentOptions options = new DeploymentOptions(json);
        this.assertEquals("bar", options.getConfig().getString("foo"));
        this.assertEquals(ha, options.isHa());
        this.assertEquals(poolName, options.getWorkerPoolName());
        this.assertEquals(poolSize, options.getWorkerPoolSize());
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)options.getMaxWorkerExecuteTimeUnit());
    }

    @Test
    public void testToJson() {
        DeploymentOptions options = new DeploymentOptions();
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        Random rand = new Random();
        boolean worker = rand.nextBoolean();
        boolean ha = rand.nextBoolean();
        List<String> cp = Arrays.asList("foo", "bar");
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        String poolName = TestUtils.randomAlphaString(10);
        int poolSize = TestUtils.randomPositiveInt();
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        options.setConfig(config);
        options.setHa(ha);
        options.setWorkerPoolName(poolName);
        options.setWorkerPoolSize(poolSize);
        options.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        options.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        JsonObject json = options.toJson();
        DeploymentOptions copy = new DeploymentOptions(json);
        this.assertEquals("bar", copy.getConfig().getString("foo"));
        this.assertEquals(ha, copy.isHa());
        this.assertEquals(poolName, copy.getWorkerPoolName());
        this.assertEquals(poolSize, copy.getWorkerPoolSize());
        this.assertEquals(maxWorkerExecuteTime, copy.getMaxWorkerExecuteTime());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)copy.getMaxWorkerExecuteTimeUnit());
    }

    @Test
    public void testDeployFromTestThread() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle).onComplete(ar -> {
            this.assertDeployment(1, verticle, null, (AsyncResult<String>)ar);
            this.assertFalse(verticle.startContext.isWorkerContext());
            this.assertTrue(verticle.startContext.isEventLoopContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployFromTestThreadNoHandler() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle);
        DeploymentTest.assertWaitUntil(() -> this.vertx.deploymentIDs().size() == 1);
    }

    @Test
    public void testDeployWithConfig() throws Exception {
        MyVerticle verticle = new MyVerticle();
        JsonObject config = this.generateJSONObject();
        this.vertx.deployVerticle((Deployable)verticle, new DeploymentOptions().setConfig(config)).onComplete(ar -> {
            this.assertDeployment(1, verticle, config, (AsyncResult<String>)ar);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployFromContext() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle).onComplete(ar -> {
            this.assertTrue(ar.succeeded());
            Context ctx = Vertx.currentContext();
            MyVerticle verticle2 = new MyVerticle();
            this.vertx.deployVerticle((Deployable)verticle2).onComplete(ar2 -> {
                this.assertDeployment(2, verticle2, null, (AsyncResult<String>)ar2);
                Context ctx2 = Vertx.currentContext();
                this.assertEquals(ctx, ctx2);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployWorkerFromTestThread() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER)).onComplete(ar -> {
            this.assertDeployment(1, verticle, null, (AsyncResult<String>)ar);
            this.assertTrue(verticle.startContext.isWorkerContext());
            this.vertx.undeploy((String)ar.result()).onComplete(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(verticle.startContext, verticle.stopContext);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployWorkerWithConfig() throws Exception {
        MyVerticle verticle = new MyVerticle();
        JsonObject conf = this.generateJSONObject();
        this.vertx.deployVerticle((Deployable)verticle, new DeploymentOptions().setConfig(conf).setThreadingModel(ThreadingModel.WORKER)).onComplete(ar -> {
            this.assertDeployment(1, verticle, conf, (AsyncResult<String>)ar);
            this.assertTrue(verticle.startContext.isWorkerContext());
            this.assertFalse(verticle.startContext.isEventLoopContext());
            this.vertx.undeploy((String)ar.result()).onComplete(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(verticle.startContext, verticle.stopContext);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWorkerRightThread() throws Exception {
        this.assertFalse(Context.isOnVertxThread());
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertTrue(Context.isOnWorkerThread());
                DeploymentTest.this.assertFalse(Context.isOnEventLoopThread());
            }

            public void stop() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertTrue(Context.isOnWorkerThread());
                DeploymentTest.this.assertFalse(Context.isOnEventLoopThread());
            }
        };
        this.vertx.deployVerticle((Deployable)verticle, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER)).onComplete(this.onSuccess(res -> {
            this.assertTrue(Context.isOnVertxThread());
            this.assertFalse(Context.isOnWorkerThread());
            this.assertTrue(Context.isOnEventLoopThread());
            this.vertx.undeploy(res).onComplete(this.onSuccess(res2 -> {
                this.assertTrue(Context.isOnVertxThread());
                this.assertFalse(Context.isOnWorkerThread());
                this.assertTrue(Context.isOnEventLoopThread());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testStandardRightThread() throws Exception {
        this.assertFalse(Context.isOnVertxThread());
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertFalse(Context.isOnWorkerThread());
                DeploymentTest.this.assertTrue(Context.isOnEventLoopThread());
            }

            public void stop() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertFalse(Context.isOnWorkerThread());
                DeploymentTest.this.assertTrue(Context.isOnEventLoopThread());
            }
        };
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(res -> {
            this.assertTrue(Context.isOnVertxThread());
            this.assertFalse(Context.isOnWorkerThread());
            this.assertTrue(Context.isOnEventLoopThread());
            this.vertx.undeploy(res).onComplete(this.onSuccess(res2 -> {
                this.assertTrue(Context.isOnVertxThread());
                this.assertFalse(Context.isOnWorkerThread());
                this.assertTrue(Context.isOnEventLoopThread());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testDeployFromContextExceptionInStart() throws Exception {
        this.testDeployFromThrowableInStart(1, Exception.class);
    }

    @Test
    public void testDeployFromContextErrorInStart() throws Exception {
        this.testDeployFromThrowableInStart(2, Error.class);
    }

    private void testDeployFromThrowableInStart(int startAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle();
        MyVerticle verticle2 = new MyVerticle(startAction, 0);
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(v -> {
            Context ctx = Vertx.currentContext();
            this.vertx.deployVerticle((Deployable)verticle2).onComplete(this.onFailure(err -> {
                this.assertEquals(expectedThrowable, err.getClass());
                this.assertEquals("FooBar!", err.getMessage());
                this.assertEquals(1L, this.vertx.deploymentIDs().size());
                Context ctx2 = Vertx.currentContext();
                this.assertEquals(ctx, ctx2);
                this.testComplete();
            }));
        }));
        this.await();
        this.assertTrue(((Promise)verticle2.completion).future().isComplete());
    }

    @Test
    public void testDeployFromContextExceptionInStop() throws Exception {
        this.testDeployFromContextThrowableInStop(1, Exception.class);
    }

    @Test
    public void testDeployFromContextErrorInStop() throws Exception {
        this.testDeployFromContextThrowableInStop(2, Error.class);
    }

    private void testDeployFromContextThrowableInStop(int stopAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id1 -> {
            Context ctx = Vertx.currentContext();
            MyVerticle verticle2 = new MyVerticle(0, stopAction);
            this.vertx.deployVerticle((Deployable)verticle2).onComplete(this.onSuccess(id2 -> this.vertx.undeploy(id2).onComplete(this.onFailure(err -> {
                this.assertEquals(expectedThrowable, err.getClass());
                this.assertEquals("BooFar!", err.getMessage());
                this.assertEquals(1L, this.vertx.deploymentIDs().size());
                this.assertEquals(ctx, Vertx.currentContext());
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testUndeploy() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onSuccess(v -> {
            this.assertFalse(this.vertx.deploymentIDs().contains(id));
            this.assertEquals(verticle.startContext, verticle.stopContext);
            Context currentContext = Vertx.currentContext();
            this.assertNotSame(currentContext, verticle.startContext);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testUndeployTwice() {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onSuccess(v -> this.vertx.undeploy(id).onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalStateException);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testUndeployInvalidID() {
        this.vertx.undeploy("uqhwdiuhqwd").onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof IllegalStateException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeployExceptionInStart() throws Exception {
        this.testDeployThrowableInStart(1, Exception.class);
    }

    @Test
    public void testDeployErrorInStart() throws Exception {
        this.testDeployThrowableInStart(2, Error.class);
    }

    private void testDeployThrowableInStart(int startAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle(startAction, 0);
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onFailure(err -> {
            this.assertEquals(expectedThrowable, err.getClass());
            this.assertEquals("FooBar!", err.getMessage());
            this.assertTrue(this.vertx.deploymentIDs().isEmpty());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUndeployExceptionInStop() throws Exception {
        this.testUndeployThrowableInStop(1, Exception.class);
    }

    @Test
    public void testUndeployErrorInStop() throws Exception {
        this.testUndeployThrowableInStop(2, Error.class);
    }

    private void testUndeployThrowableInStop(int stopAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle(0, stopAction);
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onFailure(err -> {
            this.assertEquals(expectedThrowable, err.getClass());
            this.assertEquals("BooFar!", err.getMessage());
            this.assertTrue(this.vertx.deploymentIDs().isEmpty());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testDeployUndeployMultiple() throws Exception {
        int num = 10;
        CountDownLatch deployLatch = new CountDownLatch(num);
        for (int i = 0; i < num; ++i) {
            MyVerticle verticle = new MyVerticle();
            this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
                this.assertTrue(this.vertx.deploymentIDs().contains(id));
                deployLatch.countDown();
            }));
        }
        this.assertTrue(deployLatch.await(10L, TimeUnit.SECONDS));
        this.assertEquals(num, this.vertx.deploymentIDs().size());
        CountDownLatch undeployLatch = new CountDownLatch(num);
        for (String deploymentID : this.vertx.deploymentIDs()) {
            this.vertx.undeploy(deploymentID).onComplete(this.onSuccess(v -> {
                this.assertFalse(this.vertx.deploymentIDs().contains(deploymentID));
                undeployLatch.countDown();
            }));
        }
        this.assertTrue(undeployLatch.await(10L, TimeUnit.SECONDS));
        this.assertTrue(this.vertx.deploymentIDs().isEmpty());
    }

    @Test(expected=VertxException.class)
    public void testDeployInstanceSetInstances() throws Exception {
        this.vertx.deployVerticle((Deployable)new MyVerticle(), new DeploymentOptions().setInstances(2)).await();
    }

    @Test
    public void testDeployUsingClassName() throws Exception {
        this.vertx.deployVerticle("java:" + TestVerticle.class.getCanonicalName()).onComplete(this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testDeployUsingClassAndConfig() throws Exception {
        JsonObject config = this.generateJSONObject();
        this.vertx.deployVerticle("java:" + TestVerticle.class.getCanonicalName(), new DeploymentOptions().setConfig(config)).onComplete(this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testDeployUsingClassFails() throws Exception {
        this.vertx.deployVerticle("java:uhqwuhiqwduhwd").onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof ClassNotFoundException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeployUndeployMultipleInstancesUsingClassName() throws Exception {
        int numInstances = 10;
        DeploymentOptions options = new DeploymentOptions().setInstances(numInstances);
        AtomicInteger deployCount = new AtomicInteger();
        AtomicInteger undeployCount = new AtomicInteger();
        AtomicInteger deployHandlerCount = new AtomicInteger();
        AtomicInteger undeployHandlerCount = new AtomicInteger();
        this.vertx.eventBus().consumer("tvstarted").handler(msg -> deployCount.incrementAndGet());
        this.vertx.eventBus().consumer("tvstopped").handler(msg -> {
            undeployCount.incrementAndGet();
            msg.reply((Object)"whatever");
        });
        CountDownLatch deployLatch = new CountDownLatch(1);
        this.vertx.deployVerticle(TestVerticle2.class.getCanonicalName(), options).onComplete(this.onSuccess(depID -> {
            this.assertEquals(1L, deployHandlerCount.incrementAndGet());
            deployLatch.countDown();
        }));
        this.awaitLatch(deployLatch);
        DeploymentTest.assertWaitUntil(() -> deployCount.get() == numInstances);
        this.assertEquals(1L, this.vertx.deploymentIDs().size());
        DeploymentContext deployment = ((VertxInternal)this.vertx).deploymentManager().deployment((String)this.vertx.deploymentIDs().iterator().next());
        Set verticles = deployment.deployment().instances();
        this.assertEquals(numInstances, verticles.size());
        CountDownLatch undeployLatch = new CountDownLatch(1);
        this.assertEquals(numInstances, deployCount.get());
        this.vertx.undeploy(deployment.id()).onComplete(this.onSuccess(v -> {
            this.assertEquals(1L, undeployHandlerCount.incrementAndGet());
            undeployLatch.countDown();
        }));
        this.awaitLatch(undeployLatch);
        DeploymentTest.assertWaitUntil(() -> deployCount.get() == numInstances);
        this.assertTrue(this.vertx.deploymentIDs().isEmpty());
    }

    @Test
    public void testDeployClassNotFound1() throws Exception {
        this.testDeployClassNotFound("iqwjdiqwjdoiqwjdqwij");
    }

    @Test
    public void testDeployClassNotFound2() throws Exception {
        this.testDeployClassNotFound("foo.bar.wibble.CiejdioqjdoiqwjdoiqjwdClass");
    }

    private void testDeployClassNotFound(String className) throws Exception {
        this.vertx.deployVerticle(className).onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof ClassNotFoundException);
            this.testComplete();
        }));
        this.await();
    }

    @Ignore(value="does not seem to work in module mode but works in IDE")
    @Test
    public void testDeployAsSource() throws Exception {
        String sourceFile = "io/vertx/test/sourceverticle/SourceVerticle.java";
        this.vertx.deployVerticle("java:" + sourceFile).onComplete(this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    @Test
    public void testSimpleChildDeployment() {
        this.waitFor(3);
        Consumer<Promise<Void>> start = f -> {
            Context parentContext = Vertx.currentContext();
            MyAsyncVerticle child1 = new MyAsyncVerticle(f2 -> {
                Context childContext = Vertx.currentContext();
                this.assertNotSame(parentContext, childContext);
                f2.complete();
                this.complete();
            }, Promise::complete);
            this.vertx.deployVerticle((Deployable)child1).onComplete(this.onSuccess(id -> this.complete()));
            f.complete();
        };
        MyAsyncVerticle verticle = new MyAsyncVerticle(start, Promise::complete);
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.complete()));
        this.await();
    }

    @Test
    public void testSimpleChildUndeploymentOrder() throws Exception {
        AtomicBoolean childStopCalled = new AtomicBoolean();
        AtomicBoolean parentStopCalled = new AtomicBoolean();
        AtomicReference parentDepID = new AtomicReference();
        AtomicReference childDepID = new AtomicReference();
        CountDownLatch deployLatch = new CountDownLatch(1);
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> {
            MyAsyncVerticle child1 = new MyAsyncVerticle(f2 -> f2.complete(null), f2 -> {
                this.assertFalse(parentStopCalled.get());
                this.assertFalse(childStopCalled.get());
                childStopCalled.set(true);
                f2.complete(null);
            });
            this.vertx.deployVerticle((Deployable)child1).onComplete(this.onSuccess(id -> {
                childDepID.set(id);
                f.complete(null);
            }));
        }, f2 -> {
            this.assertFalse(parentStopCalled.get());
            this.assertTrue(childStopCalled.get());
            this.assertTrue(this.vertx.deploymentIDs().contains(parentDepID.get()));
            this.assertFalse(this.vertx.deploymentIDs().contains(childDepID.get()));
            parentStopCalled.set(true);
            this.testComplete();
            f2.complete(null);
        });
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
            parentDepID.set(id);
            deployLatch.countDown();
        }));
        this.assertTrue(deployLatch.await(10L, TimeUnit.SECONDS));
        this.assertTrue(this.vertx.deploymentIDs().contains(parentDepID.get()));
        this.assertTrue(this.vertx.deploymentIDs().contains(childDepID.get()));
        this.vertx.undeploy((String)parentDepID.get()).onComplete(this.onSuccess(v -> {}));
        this.await();
    }

    @Test
    public void testSimpleChildUndeploymentOnParentAsyncFailure() throws Exception {
        final AtomicInteger childDeployed = new AtomicInteger();
        final AtomicInteger childUndeployed = new AtomicInteger();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

                    public void start() throws Exception {
                        childDeployed.incrementAndGet();
                    }

                    public void stop() throws Exception {
                        childUndeployed.incrementAndGet();
                    }
                }).onComplete(DeploymentTest.this.onSuccess(child -> startPromise.fail("Undeployed")));
            }
        }).onComplete(this.onFailure(expected -> {
            this.assertEquals(1L, childDeployed.get());
            this.assertEquals(1L, childUndeployed.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSimpleChildUndeploymentOnParentSyncFailure() throws Exception {
        final AtomicInteger childDeployed = new AtomicInteger();
        final AtomicInteger childUndeployed = new AtomicInteger();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                final CountDownLatch latch = new CountDownLatch(1);
                this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

                    public void start() throws Exception {
                        childDeployed.incrementAndGet();
                        latch.countDown();
                    }

                    public void stop() throws Exception {
                        childUndeployed.incrementAndGet();
                    }
                });
                DeploymentTest.this.awaitLatch(latch);
                throw new RuntimeException();
            }
        }).onComplete(this.onFailure(expected -> {
            DeploymentTest.waitUntil(() -> childDeployed.get() == 1);
            DeploymentTest.waitUntil(() -> childUndeployed.get() == 1);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSimpleChildUndeploymentDeployedAfterParentFailure() throws Exception {
        final AtomicInteger parentFailed = new AtomicInteger();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

                    public void start(Promise<Void> startPromise) throws Exception {
                        this.vertx.setTimer(100L, id -> startPromise.complete());
                    }

                    public void stop() throws Exception {
                        AsyncTestBase.waitUntil(() -> parentFailed.get() == 1);
                        DeploymentTest.this.testComplete();
                    }
                });
                parentFailed.incrementAndGet();
                throw new RuntimeException();
            }
        });
        this.await();
    }

    @Test
    public void testAsyncDeployCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> f.complete(null));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testAsyncDeployFailureCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.fail((Throwable)new Exception("foobar")), null);
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onFailure(err -> {
            this.assertEquals("foobar", err.getMessage());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAsyncDeploy() throws Exception {
        long start = System.currentTimeMillis();
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> this.vertx.setTimer(delay, id -> f.complete(null)), f -> f.complete(null));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
            long now = System.currentTimeMillis();
            this.assertTrue(now - start >= delay);
            this.assertTrue(this.vertx.deploymentIDs().contains(id));
            this.testComplete();
        }));
        Thread.sleep(delay / 2L);
        this.assertTrue(this.vertx.deploymentIDs().isEmpty());
        this.await();
    }

    @Test
    public void testAsyncDeployFailure() throws Exception {
        long start = System.currentTimeMillis();
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> this.vertx.setTimer(delay, id -> f.fail((Throwable)new Exception("foobar"))), null);
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onFailure(err -> {
            this.assertEquals("foobar", err.getMessage());
            long now = System.currentTimeMillis();
            this.assertTrue(now - start >= delay);
            this.assertTrue(this.vertx.deploymentIDs().isEmpty());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAsyncUndeployCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> f.complete(null));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onSuccess(v -> {
            this.assertFalse(this.vertx.deploymentIDs().contains(id));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testAsyncUndeployFailureCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> f.fail((Throwable)new Exception("foobar")));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onFailure(err -> {
            this.assertEquals("foobar", err.getMessage());
            this.assertFalse(this.vertx.deploymentIDs().contains(id));
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testAsyncUndeploy() throws Exception {
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> this.vertx.setTimer(delay, id -> f.complete(null)));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
            long start = System.currentTimeMillis();
            this.vertx.undeploy(id).onComplete(this.onSuccess(v -> {
                long now = System.currentTimeMillis();
                this.assertTrue(now - start >= delay);
                this.assertFalse(this.vertx.deploymentIDs().contains(id));
                this.testComplete();
            }));
            this.vertx.setTimer(delay / 2L, timerID -> this.assertFalse(this.vertx.deploymentIDs().isEmpty()));
        }));
        this.await();
    }

    @Test
    public void testAsyncUndeployFailure() throws Exception {
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> this.vertx.setTimer(delay, id -> f.fail((Throwable)new Exception("foobar"))));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
            long start = System.currentTimeMillis();
            this.vertx.undeploy(id).onComplete(this.onFailure(err -> {
                long now = System.currentTimeMillis();
                this.assertTrue(now - start >= delay);
                this.assertFalse(this.vertx.deploymentIDs().contains(id));
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testAsyncUndeployFailsAfterSuccess() {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void stop(Promise<Void> stopPromise) throws Exception {
                stopPromise.complete();
                throw new Exception();
            }
        };
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(arg_0 -> this.lambda$testAsyncUndeployFailsAfterSuccess$88((Verticle)verticle, arg_0));
        this.await();
    }

    @Test
    public void testChildUndeployedDirectly() throws Exception {
        AbstractVerticle parent = new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                AbstractVerticle child = new AbstractVerticle(){

                    public void start(Promise<Void> startPromise) throws Exception {
                        startPromise.complete();
                        this.vertx.runOnContext(v -> this.vertx.undeploy(this.context.deploymentID()));
                    }
                };
                this.vertx.deployVerticle((Deployable)child).onComplete(DeploymentTest.this.onSuccess(depID -> startPromise.complete()));
            }
        };
        this.vertx.deployVerticle((Deployable)parent).onComplete(this.onSuccess(depID -> this.vertx.setTimer(10L, tid -> this.vertx.undeploy(depID).onComplete(this.onSuccess(v -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testCloseHooksCalled() throws Exception {
        AtomicInteger closedCount = new AtomicInteger();
        Closeable myCloseable1 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.succeed();
        };
        Closeable myCloseable2 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.succeed();
        };
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> {
            ContextInternal ctx = (ContextInternal)Vertx.currentContext();
            ctx.addCloseHook(myCloseable1);
            ctx.addCloseHook(myCloseable2);
            f.complete(null);
        }, f -> f.complete(null));
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
            this.assertEquals(0L, closedCount.get());
            this.vertx.undeploy(id).onComplete(this.onSuccess(v -> {
                this.assertEquals(2L, closedCount.get());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testDeployWhenClosedShouldFail() throws Exception {
        CountDownLatch closed = new CountDownLatch(1);
        this.vertx.close().onComplete(this.onSuccess(v -> closed.countDown()));
        this.awaitLatch(closed);
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){}).onComplete(this.onFailure(err -> {
            this.assertEquals("Vert.x closed", err.getMessage());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUndeployAll() throws Exception {
        int numVerticles = 10;
        ArrayList<MyVerticle> verticles = new ArrayList<MyVerticle>();
        CountDownLatch latch = new CountDownLatch(numVerticles);
        for (int i = 0; i < numVerticles; ++i) {
            MyVerticle verticle = new MyVerticle();
            verticles.add(verticle);
            this.vertx.deployVerticle("java:" + ParentVerticle.class.getName()).onComplete(this.onSuccess(res -> latch.countDown()));
        }
        this.awaitLatch(latch);
        this.assertEquals(2 * numVerticles, this.vertx.deploymentIDs().size());
        this.vertx.close().onComplete(this.onSuccess(v -> {
            this.assertEquals(0L, this.vertx.deploymentIDs().size());
            this.testComplete();
        }));
        this.await();
        this.vertx = null;
    }

    @Test
    public void testDeployChildOnParentUndeploy() {
        class ParentVerticle
        extends AbstractVerticle {
            ParentVerticle() {
            }

            public void stop(Promise<Void> stopPromise) {
                this.vertx.deployVerticle(ChildVerticle.class.getName()).mapEmpty().onComplete(stopPromise);
            }
        }
        this.vertx.deployVerticle((Deployable)new ParentVerticle()).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onFailure(u -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testUndeployAllFailureInUndeploy() throws Exception {
        int numVerticles = 10;
        ArrayList<MyVerticle> verticles = new ArrayList<MyVerticle>();
        CountDownLatch latch = new CountDownLatch(numVerticles);
        for (int i = 0; i < numVerticles; ++i) {
            MyVerticle verticle = new MyVerticle(0, 1);
            verticles.add(verticle);
            this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(v -> latch.countDown()));
        }
        this.awaitLatch(latch);
        this.vertx.close().onComplete(this.onSuccess(v -> {
            for (MyVerticle verticle : verticles) {
                this.assertFalse(verticle.stopCalled);
            }
            this.testComplete();
        }));
        this.await();
        this.vertx = null;
    }

    @Test
    public void testUndeployAllNoDeployments() throws Exception {
        this.vertx.close().onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
        this.vertx = null;
    }

    @Test
    public void testGetInstanceCount() {
        class MultiInstanceVerticle
        extends AbstractVerticle {
            MultiInstanceVerticle() {
            }

            public void start() {
                DeploymentTest.this.assertEquals(this.vertx.getOrCreateContext().getInstanceCount(), 1L);
            }
        }
        this.vertx.deployVerticle((Deployable)new MultiInstanceVerticle()).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testGetInstanceCountMultipleVerticles() throws Exception {
        AtomicInteger messageCount = new AtomicInteger(0);
        AtomicInteger totalReportedInstances = new AtomicInteger(0);
        this.vertx.eventBus().consumer("instanceCount", event -> {
            totalReportedInstances.addAndGet((Integer)event.body());
            messageCount.incrementAndGet();
        });
        this.awaitFuture(this.vertx.deployVerticle(TestVerticle3.class.getCanonicalName(), new DeploymentOptions().setInstances(3)));
        DeploymentTest.assertWaitUntil(() -> messageCount.get() == 3);
        this.assertEquals(9L, totalReportedInstances.get());
        DeploymentTest.assertWaitUntil(() -> this.vertx.deploymentIDs().size() == 1);
        DeploymentContext deployment = ((VertxInternal)this.vertx).deploymentManager().deployment((String)this.vertx.deploymentIDs().iterator().next());
        this.awaitFuture(this.vertx.undeploy(deployment.id()));
    }

    @Test
    public void testFailedVerticleStopNotCalled() {
        AbstractVerticle verticleChild = new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                startPromise.fail("wibble");
            }

            public void stop() {
                DeploymentTest.this.fail("stop should not be called");
            }
        };
        AbstractVerticle verticleParent = new AbstractVerticle((Verticle)verticleChild){
            final /* synthetic */ Verticle val$verticleChild;
            {
                this.val$verticleChild = verticle;
            }

            public void start(Promise<Void> startPromise) {
                this.vertx.deployVerticle((Deployable)this.val$verticleChild).onComplete(DeploymentTest.this.onFailure(v -> startPromise.complete()));
            }
        };
        this.vertx.deployVerticle((Deployable)verticleParent).onComplete(this.onSuccess(depID -> this.vertx.undeploy(depID).onComplete(this.onSuccess(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testDeploySupplier() throws Exception {
        JsonObject config = this.generateJSONObject();
        Set myVerticles = Collections.synchronizedSet(new HashSet());
        Supplier<Verticle> supplier = () -> {
            MyVerticle myVerticle = new MyVerticle();
            myVerticles.add(myVerticle);
            return myVerticle;
        };
        DeploymentOptions options = new DeploymentOptions().setInstances(4).setConfig(config);
        Consumer<String> check = deploymentId -> myVerticles.forEach(myVerticle -> {
            this.assertEquals(deploymentId, myVerticle.deploymentID);
            this.assertEquals(config, myVerticle.config);
            this.assertTrue(myVerticle.startCalled);
        });
        this.vertx.deployVerticle(supplier, options).onComplete(this.onSuccess(deploymentId -> {
            check.accept((String)deploymentId);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeploySupplierNull() {
        Supplier<Verticle> supplier = () -> null;
        DeploymentOptions options = new DeploymentOptions();
        this.vertx.deployVerticle(supplier, options).onComplete(this.onFailure(t -> {
            this.assertEquals(Collections.emptySet(), this.vertx.deploymentIDs());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeploySupplierDuplicate() {
        MyVerticle myVerticle = new MyVerticle();
        Supplier<Verticle> supplier = () -> myVerticle;
        DeploymentOptions options = new DeploymentOptions().setInstances(2);
        this.vertx.deployVerticle(supplier, options).onComplete(this.onFailure(t -> {
            this.assertEquals(Collections.emptySet(), this.vertx.deploymentIDs());
            this.assertFalse(myVerticle.startCalled);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeploySupplierThrowsException() {
        Supplier<Verticle> supplier = () -> {
            throw new RuntimeException("boum");
        };
        this.vertx.deployVerticle(supplier, new DeploymentOptions().setInstances(1)).onComplete(this.onFailure(t -> {
            this.assertEquals(Collections.emptySet(), this.vertx.deploymentIDs());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeployClass() {
        JsonObject config = this.generateJSONObject();
        this.vertx.deployVerticle(ReferenceSavingMyVerticle.class, new DeploymentOptions().setInstances(4).setConfig(config)).onComplete(this.onSuccess(deploymentId -> {
            ReferenceSavingMyVerticle.myVerticles.forEach(myVerticle -> {
                this.assertEquals(deploymentId, myVerticle.deploymentID);
                this.assertEquals(config, myVerticle.config);
                this.assertTrue(myVerticle.startCalled);
            });
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeployClassNoDefaultPublicConstructor() throws Exception {
        class NoDefaultPublicConstructorVerticle
        extends AbstractVerticle {
            NoDefaultPublicConstructorVerticle() {
            }
        }
        this.vertx.deployVerticle(NoDefaultPublicConstructorVerticle.class, new DeploymentOptions()).onComplete(this.onFailure(t -> this.testComplete()));
        this.await();
    }

    @Test
    public void testFailedDeployRunsContextShutdownHook() throws Exception {
        AtomicBoolean closeHookCalledBeforeDeployFailure = new AtomicBoolean(false);
        final Closeable closeable = completionHandler -> {
            closeHookCalledBeforeDeployFailure.set(true);
            completionHandler.succeed();
        };
        AbstractVerticle v = new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                ((ContextInternal)this.context).addCloseHook(closeable);
                startPromise.fail("Fail to deploy.");
            }
        };
        this.vertx.deployVerticle((Deployable)v).onComplete(this.onFailure(err -> {
            this.assertTrue(closeHookCalledBeforeDeployFailure.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testWorkerInstancesUseSameEventLoopThread() throws Exception {
        final Set eventLoops = Collections.synchronizedSet(new HashSet());
        Future fut = this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start() throws Exception {
                EventLoop eventLoop = ((ContextInternal)this.context).nettyEventLoop();
                eventLoops.add(eventLoop);
                super.start();
            }
        }, new DeploymentOptions().setInstances(5).setThreadingModel(ThreadingModel.WORKER));
        this.awaitFuture(fut);
        this.assertEquals(1L, eventLoops.size());
    }

    @Test
    public void testMultipleFailedDeploys() throws InterruptedException {
        int instances = 10;
        DeploymentOptions options = new DeploymentOptions();
        options.setInstances(instances);
        AtomicBoolean called = new AtomicBoolean(false);
        this.vertx.deployVerticle(() -> {
            AbstractVerticle v = new AbstractVerticle(){

                public void start(Promise<Void> startPromise) throws Exception {
                    startPromise.fail("Fail to deploy.");
                }
            };
            return v;
        }, options).onComplete(this.onFailure(err -> {
            if (!called.compareAndSet(false, true)) {
                this.fail("Completion handler called more than once");
            }
            this.vertx.setTimer(30L, id -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testUndeployParentDuringChildDeployment() throws Exception {
        CountDownLatch deployLatch = new CountDownLatch(2);
        CountDownLatch undeployLatch = new CountDownLatch(1);
        MyAsyncVerticle childVerticle = new MyAsyncVerticle(startPromise -> {
            deployLatch.countDown();
            Vertx.currentContext().executeBlocking(() -> {
                try {
                    undeployLatch.await();
                    return null;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }).onComplete((Completable)startPromise);
        }, Promise::complete);
        MyAsyncVerticle verticle = new MyAsyncVerticle(startPromise -> {
            Context parentVerticleContext = Vertx.currentContext();
            parentVerticleContext.owner().deployVerticle((Deployable)childVerticle).onComplete(this.onFailure(t -> {
                this.assertSame(parentVerticleContext, Vertx.currentContext());
                this.testComplete();
            }));
            startPromise.complete();
        }, stopPromise -> undeployLatch.countDown());
        AtomicReference deploymentID = new AtomicReference();
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> {
            deploymentID.set(id);
            deployLatch.countDown();
        }));
        this.awaitLatch(deployLatch);
        this.vertx.undeploy((String)deploymentID.get());
        this.await();
    }

    @Test
    public void testDeployWithPartialFailure() {
        this.testDeployWithPartialFailure(3, 2);
    }

    private void testDeployWithPartialFailure(final int numberOfInstances, final int instanceToFail) {
        AtomicInteger count = new AtomicInteger();
        final Map startPromises = Collections.synchronizedMap(new HashMap());
        final Map stopped = Collections.synchronizedMap(new HashMap());
        final Set closeHooks = Collections.synchronizedSet(new HashSet());
        Future fut = this.vertx.deployVerticle(() -> {
            final int idx = count.getAndIncrement();
            return new AbstractVerticle(){

                public void start(Promise<Void> startPromise) {
                    ContextInternal ctx = (ContextInternal)this.context;
                    ctx.addCloseHook(completion -> {
                        closeHooks.add(idx);
                        completion.succeed();
                    });
                    startPromises.put(idx, startPromise);
                    if (startPromises.size() == numberOfInstances) {
                        startPromises.forEach((idx, p) -> {
                            if (idx != instanceToFail) {
                                p.tryComplete();
                            } else {
                                p.tryFail("it-failed");
                            }
                        });
                    }
                }

                public void stop() {
                    stopped.put(idx, true);
                }
            };
        }, new DeploymentOptions().setInstances(numberOfInstances));
        fut.onComplete(this.onFailure(expected -> {
            for (int j = 0; j < numberOfInstances; ++j) {
                if (instanceToFail != j) {
                    this.assertTrue(stopped.containsKey(j));
                }
                this.assertTrue(closeHooks.contains(j));
            }
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCloseDeploymentInProgress() {
        Vertx vertx = Vertx.vertx();
        this.waitFor(3);
        vertx.deployVerticle((Deployable)new AbstractVerticle(){
            Promise<Void> startPromise;

            public void start(Promise<Void> startPromise) {
                this.startPromise = startPromise;
                AtomicBoolean hookCompletion = new AtomicBoolean();
                ((ContextInternal)this.context).addCloseHook(completion -> {
                    DeploymentTest.this.complete();
                    new Thread(() -> {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            DeploymentTest.this.fail(e);
                        }
                        hookCompletion.set(true);
                        completion.succeed();
                    }).start();
                });
                this.vertx.close().onComplete(DeploymentTest.this.onSuccess(v -> {
                    DeploymentTest.this.assertTrue(hookCompletion.get());
                    DeploymentTest.this.complete();
                }));
            }

            public void stop(Promise<Void> stopPromise) {
                DeploymentTest.this.fail();
            }
        }).onComplete(this.onFailure(err -> this.complete()));
        this.await();
    }

    @Test
    public void testContextClassLoader() throws Exception {
        File tmp = File.createTempFile("vertx-", ".txt");
        tmp.deleteOnExit();
        Files.write(tmp.toPath(), "hello".getBytes(), new OpenOption[0]);
        final URL url = tmp.toURI().toURL();
        final AtomicBoolean used = new AtomicBoolean();
        final ClassLoader cl = new ClassLoader(Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                if (name.equals("foo.txt")) {
                    used.set(true);
                    return url;
                }
                return super.getResource(name);
            }
        };
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                DeploymentTest.this.assertSame(cl, Thread.currentThread().getContextClassLoader());
                DeploymentTest.this.assertSame(cl, ((ContextInternal)this.context).classLoader());
                this.vertx.fileSystem().props("foo.txt").onComplete(DeploymentTest.this.onSuccess(props -> {
                    DeploymentTest.this.assertEquals(5L, props.size());
                    DeploymentTest.this.assertTrue(used.get());
                    DeploymentTest.this.testComplete();
                }));
            }
        }, new DeploymentOptions().setClassLoader(cl)).onComplete(this.onSuccess(id -> {}));
        this.await();
    }

    private void assertDeployment(int instances, MyVerticle verticle, JsonObject config, AsyncResult<String> ar) {
        this.assertTrue(ar.succeeded());
        this.assertEquals(this.vertx, verticle.getVertx());
        String deploymentID = (String)ar.result();
        this.assertNotNull(ar.result());
        this.assertEquals(deploymentID, verticle.deploymentID);
        if (config == null) {
            this.assertEquals(0L, verticle.config.size());
        } else {
            this.assertEquals(config, verticle.config);
        }
        this.assertTrue(verticle.startCalled);
        this.assertFalse(verticle.stopCalled);
        this.assertTrue(this.vertx.deploymentIDs().contains(deploymentID));
        this.assertEquals(instances, this.vertx.deploymentIDs().size());
        Context currentContext = Vertx.currentContext();
        this.assertNotSame(currentContext, verticle.startContext);
    }

    private JsonObject generateJSONObject() {
        return new JsonObject().put("foo", (Object)"bar").put("blah", (Object)123).put("obj", (Object)new JsonObject().put("quux", (Object)"flip"));
    }

    private /* synthetic */ void lambda$testAsyncUndeployFailsAfterSuccess$88(Verticle verticle, Void v1) {
        this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onSuccess(id -> this.vertx.undeploy(id).onComplete(this.onSuccess(v2 -> this.complete()))));
    }

    public class MyAsyncVerticle
    extends AbstractVerticle {
        private final Consumer<Promise<Void>> startConsumer;
        private final Consumer<Promise<Void>> stopConsumer;

        public MyAsyncVerticle(Consumer<Promise<Void>> startConsumer, Consumer<Promise<Void>> stopConsumer) {
            this.startConsumer = startConsumer;
            this.stopConsumer = stopConsumer;
        }

        public void start(Promise<Void> startPromise) throws Exception {
            if (this.startConsumer != null) {
                this.startConsumer.accept(startPromise);
            }
        }

        public void stop(Promise<Void> stopPromise) throws Exception {
            if (this.stopConsumer != null) {
                this.stopConsumer.accept(stopPromise);
            }
        }
    }

    public static class ReferenceSavingMyVerticle
    extends MyVerticle {
        static Set<MyVerticle> myVerticles = new HashSet<MyVerticle>();

        public ReferenceSavingMyVerticle() {
            myVerticles.add(this);
        }
    }

    public static class MyVerticle
    extends AbstractVerticle {
        static final int NOOP = 0;
        static final int THROW_EXCEPTION = 1;
        static final int THROW_ERROR = 2;
        boolean startCalled;
        boolean stopCalled;
        Context startContext;
        Context stopContext;
        int startAction;
        int stopAction;
        String deploymentID;
        JsonObject config;
        Completable<Void> completion;

        MyVerticle() {
            this(0, 0);
        }

        MyVerticle(int startAction, int stopAction) {
            this.startAction = startAction;
            this.stopAction = stopAction;
        }

        public void start() throws Exception {
            ((ContextInternal)this.context).addCloseHook(promise -> {
                this.completion = promise;
                promise.succeed();
            });
            switch (this.startAction) {
                case 1: {
                    throw new Exception("FooBar!");
                }
                case 2: {
                    throw new Error("FooBar!");
                }
            }
            this.startCalled = true;
            this.startContext = Vertx.currentContext();
            this.deploymentID = Vertx.currentContext().deploymentID();
            this.config = this.context.config();
        }

        public void stop() throws Exception {
            switch (this.stopAction) {
                case 1: {
                    throw new Exception("BooFar!");
                }
                case 2: {
                    throw new Error("BooFar!");
                }
            }
            this.stopCalled = true;
            this.stopContext = Vertx.currentContext();
        }
    }

    public static class ChildVerticle
    extends AbstractVerticle {
    }

    public static class ParentVerticle
    extends AbstractVerticle {
        public void start(Promise<Void> startPromise) throws Exception {
            this.vertx.deployVerticle("java:" + ChildVerticle.class.getName()).onComplete(ar -> {
                if (ar.succeeded()) {
                    startPromise.complete(null);
                } else {
                    ar.cause().printStackTrace();
                }
            });
        }
    }
}

