/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.deployment;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.test.core.VertxTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VerticleFactoryTest
extends VertxTestBase {
    @Parameterized.Parameter
    public boolean legacy;

    @Parameterized.Parameters(name="{index}: implement new/old verticle factory={0}")
    public static List<Object[]> params() {
        return Arrays.asList({true}, {false});
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        for (VerticleFactory factory : this.vertx.verticleFactories()) {
            this.vertx.unregisterVerticleFactory(factory);
        }
    }

    @Test
    public void testRegister() {
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
        TestVerticleFactory fact1 = this.createTestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
    }

    @Test
    public void testUnregister() {
        TestVerticleFactory fact1 = this.createTestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
    }

    @Test
    public void testRegisterTwice() {
        TestVerticleFactory fact1 = this.createTestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        try {
            this.vertx.registerVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterTwice() {
        TestVerticleFactory fact1 = this.createTestVerticleFactory("foo");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        try {
            this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnregisterNoFact() {
        TestVerticleFactory fact1 = this.createTestVerticleFactory("foo");
        try {
            this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterUnregisterTwo() {
        TestVerticleFactory fact1 = this.createTestVerticleFactory("foo");
        TestVerticleFactory fact2 = this.createTestVerticleFactory("bar");
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.assertEquals(2L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact1));
        this.assertTrue(this.vertx.verticleFactories().contains(fact2));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact1);
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertEquals(1L, this.vertx.verticleFactories().size());
        this.assertTrue(this.vertx.verticleFactories().contains(fact2));
        this.vertx.unregisterVerticleFactory((VerticleFactory)fact2);
        this.assertTrue(this.vertx.verticleFactories().isEmpty());
        this.assertFalse(this.vertx.verticleFactories().contains(fact1));
        this.assertFalse(this.vertx.verticleFactories().contains(fact2));
    }

    @Test
    public void testMatchWithPrefix() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticle verticle3 = new TestVerticle();
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = this.createTestVerticleFactory("bb", (Verticle)verticle2);
        TestVerticleFactory fact3 = this.createTestVerticleFactory("cc", (Verticle)verticle3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        String name1 = "aa:myverticle1";
        String name2 = "bb:myverticle2";
        String name3 = "cc:myverticle3";
        this.vertx.deployVerticle(name1, new DeploymentOptions()).onComplete(this.onSuccess(ar -> {
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertFalse(verticle3.startCalled);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.vertx.deployVerticle(name2, new DeploymentOptions()).onComplete(this.onSuccess(ar2 -> {
                this.assertEquals(name2, fact2.identifier);
                this.assertTrue(verticle2.startCalled);
                this.assertFalse(verticle3.startCalled);
                this.assertNull(fact3.identifier);
                this.vertx.deployVerticle(name3, new DeploymentOptions()).onComplete(this.onSuccess(ar3 -> {
                    this.assertEquals(name3, fact3.identifier);
                    this.assertTrue(verticle3.startCalled);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testMatchWithSuffix() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticle verticle3 = new TestVerticle();
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = this.createTestVerticleFactory("bb", (Verticle)verticle2);
        TestVerticleFactory fact3 = this.createTestVerticleFactory("cc", (Verticle)verticle3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        String name1 = "myverticle1.aa";
        String name2 = "myverticle2.bb";
        String name3 = "myverticle3.cc";
        this.vertx.deployVerticle(name1, new DeploymentOptions()).onComplete(this.onSuccess(ar -> {
            this.assertEquals(name1, fact1.identifier);
            this.assertTrue(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertFalse(verticle3.startCalled);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.vertx.deployVerticle(name2, new DeploymentOptions()).onComplete(this.onSuccess(ar2 -> {
                this.assertEquals(name2, fact2.identifier);
                this.assertTrue(verticle2.startCalled);
                this.assertFalse(verticle3.startCalled);
                this.assertNull(fact3.identifier);
                this.vertx.deployVerticle(name3, new DeploymentOptions()).onComplete(this.onSuccess(ar3 -> {
                    this.assertEquals(name3, fact3.identifier);
                    this.assertTrue(verticle3.startCalled);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testNoMatch() {
        TestVerticle verticle1 = new TestVerticle();
        TestVerticle verticle2 = new TestVerticle();
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle1);
        TestVerticleFactory fact2 = this.createTestVerticleFactory("bb", (Verticle)verticle2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        String name1 = "cc:myverticle1";
        this.vertx.deployVerticle(name1, new DeploymentOptions()).onComplete(this.onFailure(err -> {
            this.assertFalse(verticle1.startCalled);
            this.assertFalse(verticle2.startCalled);
            this.assertTrue(err instanceof ClassNotFoundException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testOrdering() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = this.createTestVerticleFactory("aa", (Verticle)verticle, 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle, 1);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = this.createTestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle").onComplete(this.onSuccess(res -> {
            this.assertEquals("aa:someverticle", fact1.identifier);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testOrderingFailedInCreate() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = this.createTestVerticleFactory("aa", (Verticle)verticle, 2);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = this.createTestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle").onComplete(this.onSuccess(res -> {
            this.assertEquals("aa:someverticle", fact2.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testOrderingFailedInCreate2() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = this.createTestVerticleFactory("aa", (Verticle)verticle, 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = this.createTestVerticleFactory("aa", (Verticle)verticle, 3);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle").onComplete(this.onSuccess(res -> {
            this.assertEquals("aa:someverticle", fact3.identifier);
            this.assertNull(fact1.identifier);
            this.assertNull(fact2.identifier);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testOrderingFailedInCreateAll() {
        TestVerticle verticle = new TestVerticle();
        TestVerticleFactory fact2 = this.createTestVerticleFactory("aa", (Verticle)verticle, 2, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact2);
        TestVerticleFactory fact1 = this.createTestVerticleFactory("aa", (Verticle)verticle, 1, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact1);
        TestVerticleFactory fact3 = this.createTestVerticleFactory("aa", (Verticle)verticle, 3, true);
        this.vertx.registerVerticleFactory((VerticleFactory)fact3);
        this.vertx.deployVerticle("aa:someverticle").onComplete(this.onFailure(err -> {
            this.assertTrue(err instanceof ClassNotFoundException);
            this.assertNull(fact1.identifier);
            this.assertNull(fact2.identifier);
            this.assertNull(fact3.identifier);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeploymentOnClosedVertxWithCompletionHandler() {
        TestVerticle verticle = new TestVerticle();
        this.vertx.close().onComplete(done -> this.vertx.deployVerticle((Deployable)verticle).onComplete(this.onFailure(err -> this.testComplete())));
        this.await();
    }

    @Test
    public void testDeploymentOnClosedVertxWithoutCompletionHandler() {
        TestVerticle verticle = new TestVerticle();
        this.vertx.close().onComplete(done -> {
            this.vertx.deployVerticle((Deployable)verticle);
            this.testComplete();
        });
        this.await();
    }

    TestVerticleFactory createTestVerticleFactory(String prefix) {
        return this.legacy ? new TestVerticleFactory.Vertx4(prefix) : new TestVerticleFactory.Vertx5(prefix);
    }

    TestVerticleFactory createTestVerticleFactory(String prefix, Verticle verticle) {
        return this.legacy ? new TestVerticleFactory.Vertx4(prefix, verticle) : new TestVerticleFactory.Vertx5(prefix, verticle);
    }

    TestVerticleFactory createTestVerticleFactory(String prefix, Verticle verticle, int order) {
        return this.legacy ? new TestVerticleFactory.Vertx4(prefix, verticle, order) : new TestVerticleFactory.Vertx5(prefix, verticle, order);
    }

    TestVerticleFactory createTestVerticleFactory(String prefix, Verticle verticle, int order, boolean failInCreate) {
        return this.legacy ? new TestVerticleFactory.Vertx4(prefix, verticle, order, failInCreate) : new TestVerticleFactory.Vertx5(prefix, verticle, order, failInCreate);
    }

    @Test
    public void testClassLoader() {
        ClassLoader loader = new ClassLoader(Thread.currentThread().getContextClassLoader()){};
        final AtomicReference createClassLoader = new AtomicReference();
        Object factory = this.legacy ? new VerticleFactory(){

            public String prefix() {
                return "test";
            }

            public void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
                createClassLoader.set(classLoader);
                promise.complete(() -> new AbstractVerticle(){});
            }
        } : new VerticleFactory(){

            public String prefix() {
                return "test";
            }

            public void createVerticle2(String verticleName, ClassLoader classLoader, Promise<Callable<? extends Deployable>> promise) {
                createClassLoader.set(classLoader);
                promise.complete(() -> new AbstractVerticle(){});
            }
        };
        this.vertx.registerVerticleFactory(factory);
        this.vertx.deployVerticle("test:foo", new DeploymentOptions().setClassLoader(loader)).onComplete(this.onSuccess(id -> {
            this.assertSame(loader, createClassLoader.get());
            this.testComplete();
        }));
        this.await();
    }

    class TestVerticle
    extends AbstractVerticle {
        boolean startCalled;

        TestVerticle() {
        }

        public void start() throws Exception {
            this.startCalled = true;
        }

        public void stop() throws Exception {
        }
    }

    static abstract class TestVerticleFactory
    implements VerticleFactory {
        String prefix;
        Verticle verticle;
        String identifier;
        int order;
        boolean failInCreate;
        Context createContext;
        boolean createWorkerThread;

        TestVerticleFactory(String prefix) {
            this.prefix = prefix;
        }

        TestVerticleFactory(String prefix, Verticle verticle) {
            this.prefix = prefix;
            this.verticle = verticle;
        }

        TestVerticleFactory(String prefix, Verticle verticle, int order) {
            this.prefix = prefix;
            this.verticle = verticle;
            this.order = order;
        }

        TestVerticleFactory(String prefix, Verticle verticle, int order, boolean failInCreate) {
            this.prefix = prefix;
            this.verticle = verticle;
            this.order = order;
            this.failInCreate = failInCreate;
        }

        public int order() {
            return this.order;
        }

        public void init(Vertx vertx) {
        }

        public String prefix() {
            return this.prefix;
        }

        public void close() {
        }

        static class Vertx5
        extends TestVerticleFactory {
            public Vertx5(String prefix) {
                super(prefix);
            }

            public Vertx5(String prefix, Verticle verticle) {
                super(prefix, verticle);
            }

            public Vertx5(String prefix, Verticle verticle, int order) {
                super(prefix, verticle, order);
            }

            public Vertx5(String prefix, Verticle verticle, int order, boolean failInCreate) {
                super(prefix, verticle, order, failInCreate);
            }

            public void createVerticle2(String verticleName, ClassLoader classLoader, Promise<Callable<? extends Deployable>> promise) {
                if (this.failInCreate) {
                    promise.fail((Throwable)new ClassNotFoundException("whatever"));
                    return;
                }
                this.identifier = verticleName;
                this.createContext = Vertx.currentContext();
                this.createWorkerThread = Context.isOnWorkerThread();
                promise.complete(() -> this.verticle);
            }
        }

        static class Vertx4
        extends TestVerticleFactory {
            public Vertx4(String prefix) {
                super(prefix);
            }

            public Vertx4(String prefix, Verticle verticle) {
                super(prefix, verticle);
            }

            public Vertx4(String prefix, Verticle verticle, int order) {
                super(prefix, verticle, order);
            }

            public Vertx4(String prefix, Verticle verticle, int order, boolean failInCreate) {
                super(prefix, verticle, order, failInCreate);
            }

            public void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
                if (this.failInCreate) {
                    promise.fail((Throwable)new ClassNotFoundException("whatever"));
                    return;
                }
                this.identifier = verticleName;
                this.createContext = Vertx.currentContext();
                this.createWorkerThread = Context.isOnWorkerThread();
                promise.complete(() -> this.verticle);
            }
        }
    }
}

