/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.deployment;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.VerticleBase;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.PoolOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.http.HttpTestBase;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class VirtualThreadDeploymentTest
extends VertxTestBase {
    private static final Method IS_VIRTUAL;

    public static boolean isVirtual(Thread th) {
        if (IS_VIRTUAL != null) {
            try {
                return (Boolean)IS_VIRTUAL.invoke((Object)th, new Object[0]);
            }
            catch (Exception e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
        }
        return false;
    }

    @Test
    public void testDeploy() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                VirtualThreadDeploymentTest.this.assertTrue(VirtualThreadDeploymentTest.isVirtual(Thread.currentThread()));
                Future fut = Future.future(p -> this.vertx.setTimer(500L, id -> p.complete()));
                fut.await();
                VirtualThreadDeploymentTest.this.testComplete();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD));
        this.await();
    }

    @Test
    public void testExecuteBlocking() {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        final Promise p = Promise.promise();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                String res;
                Future fut = this.vertx.executeBlocking(() -> {
                    VirtualThreadDeploymentTest.this.assertTrue(VirtualThreadDeploymentTest.isVirtual(Thread.currentThread()));
                    return Thread.currentThread().getName();
                });
                try {
                    res = (String)fut.await();
                }
                catch (Exception e) {
                    p.fail((Throwable)e);
                    return;
                }
                VirtualThreadDeploymentTest.this.assertNotSame(Thread.currentThread().getName(), res);
                p.complete();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).await();
    }

    @Test
    public void testUndeployInterruptVirtualThreads() throws Exception {
        final int num = 16;
        final Promise p = Promise.promise();
        final AtomicReference thread = new AtomicReference();
        final AtomicInteger interrupted = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(num);
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        String id = (String)this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                for (int i = 0; i < num; ++i) {
                    this.vertx.runOnContext(v -> {
                        block2: {
                            try {
                                thread.set(Thread.currentThread());
                                latch.countDown();
                                p.future().await();
                            }
                            catch (Exception e) {
                                if (!(e instanceof InterruptedException)) break block2;
                                interrupted.incrementAndGet();
                            }
                        }
                    });
                }
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).await(20L, TimeUnit.SECONDS);
        latch.await(20L, TimeUnit.SECONDS);
        VirtualThreadDeploymentTest.assertWaitUntil(() -> thread.get() != null && ((Thread)thread.get()).getState() == Thread.State.WAITING);
        this.vertx.undeploy(id).await(20L, TimeUnit.SECONDS);
        VirtualThreadDeploymentTest.assertWaitUntil(() -> interrupted.get() == num);
    }

    @Test
    public void testDeployHTTPServer() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        final AtomicInteger inflight = new AtomicInteger();
        final AtomicBoolean processing = new AtomicBoolean();
        final AtomicInteger max = new AtomicInteger();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){
            HttpServer server;

            public void start() {
                this.server = this.vertx.createHttpServer().requestHandler(req -> {
                    VirtualThreadDeploymentTest.this.assertFalse(processing.getAndSet(true));
                    int val = inflight.incrementAndGet();
                    max.set(Math.max(val, max.get()));
                    Future fut = Future.future(p -> this.vertx.setTimer(50L, id -> p.complete()));
                    processing.set(false);
                    fut.await();
                    VirtualThreadDeploymentTest.this.assertFalse(processing.getAndSet(true));
                    req.response().end();
                    inflight.decrementAndGet();
                    processing.set(false);
                });
                this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").await();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).await();
        HttpClientAgent client = this.vertx.createHttpClient();
        int numReq = 10;
        this.waitFor(numReq);
        for (int i = 0; i < numReq; ++i) {
            Future resp = client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").compose(req -> req.send().compose(HttpClientResponse::body));
            resp.onComplete(this.onSuccess(v -> this.complete()));
        }
        this.await();
        Assert.assertEquals((long)5L, (long)max.get());
    }

    @Test
    public void testHttpClientStopRequestInProgress() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        AtomicInteger inflight = new AtomicInteger();
        this.vertx.createHttpServer().requestHandler(request -> inflight.incrementAndGet()).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost");
        final int numReq = 10;
        final Set threads = Collections.synchronizedSet(new HashSet());
        final Set interruptedThreads = Collections.synchronizedSet(new HashSet());
        String deploymentID = (String)this.vertx.deployVerticle((Deployable)new VerticleBase(){
            HttpClient client;

            public Future<?> start() throws Exception {
                this.client = this.vertx.createHttpClient(new PoolOptions().setHttp1MaxSize(numReq));
                for (int i = 0; i < numReq; ++i) {
                    this.vertx.runOnContext(v -> {
                        threads.add(Thread.currentThread());
                        try {
                            this.client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").compose(HttpClientRequest::send).await();
                        }
                        catch (Throwable e) {
                            interruptedThreads.add(Thread.currentThread());
                        }
                    });
                }
                return super.start();
            }

            public Future<?> stop() {
                return this.client.close();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).await();
        VirtualThreadDeploymentTest.assertWaitUntil(() -> inflight.get() == numReq);
        this.vertx.undeploy(deploymentID).await();
        this.assertEquals(threads, interruptedThreads);
    }

    @Test
    public void testVirtualThreadsNotAvailable() {
        Assume.assumeFalse((boolean)this.isVirtualThreadAvailable());
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD)).onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }

    static {
        Method isVirtualMethod = null;
        try {
            isVirtualMethod = Thread.class.getDeclaredMethod("isVirtual", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        IS_VIRTUAL = isVirtualMethod;
    }
}

