/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.endpoint;

import io.vertx.core.Future;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakedns.FakeDNSServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.junit.Test;

public class DnsResolverTest
extends VertxTestBase {
    private String nameToResolve = TestUtils.randomAlphaString(8) + ".com";
    private FakeDNSServer dnsServer;
    private EndpointResolver<SocketAddress, SocketAddress, List<SocketAddress>, List<SocketAddress>> resolver;

    @Override
    protected VertxOptions getOptions() {
        InetSocketAddress dnsAddr = this.dnsServer.localAddress();
        return new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setServers(Collections.singletonList(dnsAddr.getAddress().getHostAddress() + ":" + dnsAddr.getPort())));
    }

    @Override
    public void setUp() throws Exception {
        this.dnsServer = new FakeDNSServer();
        this.dnsServer.start();
        this.dnsServer.store(questionRecord -> {
            LinkedHashSet<1> set = new LinkedHashSet<1>();
            if (this.nameToResolve.equals(questionRecord.getDomainName())) {
                for (int i = 0; i < 2; ++i) {
                    final String ip = "127.0.0." + (i + 1);
                    set.add(new ResourceRecord(){

                        public String getDomainName() {
                            return DnsResolverTest.this.nameToResolve;
                        }

                        public RecordType getRecordType() {
                            return RecordType.A;
                        }

                        public RecordClass getRecordClass() {
                            return RecordClass.IN;
                        }

                        public int getTimeToLive() {
                            return 100;
                        }

                        public String get(String id) {
                            if (id.equals("apacheDnsIpAddress")) {
                                return ip;
                            }
                            return null;
                        }
                    });
                }
            }
            return set;
        });
        super.setUp();
        this.resolver = ((VertxInternal)this.vertx).nameResolver().endpointResolver(this.vertx);
    }

    @Override
    public void tearDown() throws Exception {
        this.dnsServer.stop();
        super.tearDown();
    }

    @Test
    public void testResolveMultipleAddresses() {
        Future fut = this.resolver.resolve((Address)SocketAddress.inetSocketAddress((int)8080, (String)this.nameToResolve), (EndpointBuilder)new EndpointBuilder<List<SocketAddress>, SocketAddress>(){

            public EndpointBuilder<List<SocketAddress>, SocketAddress> addServer(SocketAddress server, String key) {
                final ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
                list.add(server);
                return new EndpointBuilder<List<SocketAddress>, SocketAddress>(){

                    public EndpointBuilder<List<SocketAddress>, SocketAddress> addServer(SocketAddress server, String key) {
                        list.add(server);
                        return this;
                    }

                    public List<SocketAddress> build() {
                        return list;
                    }
                };
            }

            public List<SocketAddress> build() {
                throw new IllegalStateException();
            }
        });
        fut.onComplete(this.onSuccess(state -> {
            this.assertEquals(2L, state.size());
            SocketAddress addr1 = (SocketAddress)state.get(0);
            SocketAddress addr2 = (SocketAddress)state.get(1);
            this.assertEquals("127.0.0.1", addr1.host());
            this.assertEquals(8080L, addr1.port());
            this.assertEquals("127.0.0.2", addr2.host());
            this.assertEquals(8080L, addr2.port());
            this.testComplete();
        }));
        this.await();
    }
}

