/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.endpoint;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.endpoint.InteractionMetrics;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.net.endpoint.ServerInteraction;
import io.vertx.core.net.endpoint.ServerSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LoadBalancingCornerCasesTest {
    private final LoadBalancer loadBalancer;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({LoadBalancer.ROUND_ROBIN}, {LoadBalancer.LEAST_REQUESTS}, {LoadBalancer.RANDOM}, {LoadBalancer.POWER_OF_TWO_CHOICES});
    }

    public LoadBalancingCornerCasesTest(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Test
    public void testCornerCases() {
        ArrayList<1> instances = new ArrayList<1>();
        ServerSelector selector = this.loadBalancer.selector(instances);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)-1L, (long)selector.select());
        }
        ServerEndpoint instance = new ServerEndpoint(){
            InteractionMetrics<?> metrics;
            {
                this.metrics = LoadBalancingCornerCasesTest.this.loadBalancer.newMetrics();
            }

            public SocketAddress address() {
                return null;
            }

            public Object unwrap() {
                return null;
            }

            public String key() {
                return "";
            }

            public InteractionMetrics<?> metrics() {
                return this.metrics;
            }

            public ServerInteraction newInteraction() {
                return null;
            }
        };
        instances.add(instance);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)0L, (long)selector.select());
        }
    }
}

