/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.endpoint;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.endpoint.InteractionMetrics;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.net.endpoint.ServerInteraction;
import io.vertx.core.net.endpoint.ServerSelector;
import io.vertx.test.core.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LoadBalancingTest {
    ServerEndpoint endpointOf(LoadBalancer loadBalancer) {
        final InteractionMetrics metrics = loadBalancer.newMetrics();
        return new ServerEndpoint(){

            public SocketAddress address() {
                return null;
            }

            public String key() {
                return "";
            }

            public Object unwrap() {
                return null;
            }

            public InteractionMetrics<?> metrics() {
                return metrics;
            }

            public ServerInteraction newInteraction() {
                return null;
            }
        };
    }

    @Test
    public void testRoundRobin() throws Exception {
        ServerEndpoint e1 = this.endpointOf(LoadBalancer.ROUND_ROBIN);
        ServerEndpoint e2 = this.endpointOf(LoadBalancer.ROUND_ROBIN);
        ServerEndpoint e3 = this.endpointOf(LoadBalancer.ROUND_ROBIN);
        List<ServerEndpoint> metrics = Arrays.asList(e1, e2, e3);
        ServerSelector selector = LoadBalancer.ROUND_ROBIN.selector(metrics);
        Assert.assertEquals((long)0L, (long)selector.select());
        Assert.assertEquals((long)1L, (long)selector.select());
        Assert.assertEquals((long)2L, (long)selector.select());
        Assert.assertEquals((long)0L, (long)selector.select());
        Assert.assertEquals((long)1L, (long)selector.select());
        Assert.assertEquals((long)2L, (long)selector.select());
    }

    @Test
    public void testLeastRequests() throws Exception {
        int i;
        ArrayList<ServerEndpoint> metrics = new ArrayList<ServerEndpoint>();
        int num = 6;
        for (i = 0; i < num; ++i) {
            metrics.add(this.endpointOf(LoadBalancer.LEAST_REQUESTS));
        }
        for (i = 0; i < metrics.size(); ++i) {
            if (i == 2) continue;
            ((ServerEndpoint)metrics.get(i)).metrics().initiateRequest();
        }
        ServerSelector selector = LoadBalancer.LEAST_REQUESTS.selector(metrics);
        Assert.assertEquals((long)2L, (long)selector.select());
    }

    @Test
    public void testRandom() throws Exception {
        ArrayList<ServerEndpoint> metrics = new ArrayList<ServerEndpoint>();
        int num = 6;
        for (int i = 0; i < num; ++i) {
            metrics.add(this.endpointOf(LoadBalancer.RANDOM));
        }
        ServerSelector selector = LoadBalancer.RANDOM.selector(metrics);
        for (int i = 0; i < 1000; ++i) {
            int selectedIndex = selector.select();
            Assert.assertTrue((selectedIndex >= 0 && selectedIndex < metrics.size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPowerOfTwoChoices() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            ServerEndpoint e1 = this.endpointOf(LoadBalancer.POWER_OF_TWO_CHOICES);
            ServerEndpoint e2 = this.endpointOf(LoadBalancer.POWER_OF_TWO_CHOICES);
            List<ServerEndpoint> metrics = Arrays.asList(e1, e2);
            e2.metrics().initiateRequest();
            ServerSelector selector = LoadBalancer.POWER_OF_TWO_CHOICES.selector(metrics);
            Assert.assertEquals((long)0L, (long)selector.select());
        }
        ArrayList<ServerEndpoint> metrics = new ArrayList<ServerEndpoint>();
        int num = 6;
        for (int i = 0; i < num; ++i) {
            metrics.add(this.endpointOf(LoadBalancer.POWER_OF_TWO_CHOICES));
        }
        ServerSelector selector = LoadBalancer.POWER_OF_TWO_CHOICES.selector(metrics);
        for (int i = 0; i < 1000; ++i) {
            int selectedIndex = selector.select();
            Assert.assertTrue((selectedIndex >= 0 && selectedIndex < metrics.size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConsistentHashing() {
        int res;
        int i;
        ServerEndpoint e1 = this.endpointOf(LoadBalancer.CONSISTENT_HASHING);
        ServerEndpoint e2 = this.endpointOf(LoadBalancer.CONSISTENT_HASHING);
        ServerEndpoint e3 = this.endpointOf(LoadBalancer.CONSISTENT_HASHING);
        ServerSelector selector = LoadBalancer.CONSISTENT_HASHING.selector(Arrays.asList(e1, e2, e3));
        int num = 100;
        ArrayList<String> ids = new ArrayList<String>(num);
        for (i = 0; i < num; ++i) {
            ids.add(TestUtils.randomAlphaString(40));
        }
        for (i = 0; i < num; ++i) {
            String id = (String)ids.get(i);
            int idx = selector.select(id);
            Assert.assertTrue((idx >= 0 && idx < 4 ? 1 : 0) != 0);
            for (int j = 0; j < 16; ++j) {
                Assert.assertEquals((long)idx, (long)selector.select(id));
            }
        }
        for (int bitset = 0; bitset != 7; bitset |= 1 << res) {
            res = selector.select();
            Assert.assertTrue((res >= 0 && res < 4 ? 1 : 0) != 0);
        }
    }
}

