/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.endpoint;

import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.endpoint.EndpointResolverInternal;
import io.vertx.core.net.Address;
import io.vertx.core.net.AddressResolver;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.endpoint.Endpoint;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.net.endpoint.ServerEndpoint;
import io.vertx.core.spi.endpoint.EndpointResolver;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakeresolver.FakeAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.Test;

public class MappingResolverTest
extends VertxTestBase {
    volatile Function<Address, List<SocketAddress>> mapping;
    EndpointResolverInternal endpointResolver;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        AddressResolver ar = AddressResolver.mappingResolver(addr -> {
            Function<Address, List<SocketAddress>> m = this.mapping;
            return m != null ? m.apply((Address)addr) : null;
        });
        this.endpointResolver = EndpointResolverInternal.create((VertxInternal)((VertxInternal)this.vertx), (EndpointResolver)ar.endpointResolver(this.vertx), (LoadBalancer)LoadBalancer.ROUND_ROBIN, (long)5000L);
    }

    @Test
    public void testLookup() throws Exception {
        FakeAddress lookup = new FakeAddress("svc");
        this.mapping = addr -> Collections.singletonList(SocketAddress.inetSocketAddress((int)80, (String)addr.toString()));
        Endpoint endpoint = (Endpoint)this.awaitFuture(this.endpointResolver.resolveEndpoint((Address)lookup));
        ServerEndpoint node = endpoint.selectServer();
        this.assertEquals("ServiceName(svc)", node.address().host());
        this.assertEquals(80L, node.address().port());
    }

    @Test
    public void testReturnNull() throws Exception {
        FakeAddress lookup = new FakeAddress("svc");
        this.mapping = addr -> null;
        Endpoint endpoint = (Endpoint)this.awaitFuture(this.endpointResolver.resolveEndpoint((Address)lookup));
        try {
            endpoint.selectServer();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRevalidation() throws Exception {
        FakeAddress lookup = new FakeAddress("svc");
        AtomicReference<List<SocketAddress>> ref = new AtomicReference<List<SocketAddress>>();
        ref.set(List.of(SocketAddress.inetSocketAddress((int)80, (String)"addr1")));
        this.mapping = addr -> (List)ref.get();
        Endpoint endpoint = (Endpoint)this.awaitFuture(this.endpointResolver.resolveEndpoint((Address)lookup));
        this.assertEquals("addr1", endpoint.selectServer().address().host());
        this.assertEquals("addr1", endpoint.selectServer().address().host());
        ref.set(List.of(SocketAddress.inetSocketAddress((int)80, (String)"addr1"), SocketAddress.inetSocketAddress((int)80, (String)"addr2")));
        this.assertEquals("addr1", endpoint.selectServer().address().host());
        this.assertEquals("addr2", endpoint.selectServer().address().host());
    }
}

