/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.Utils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import org.junit.Assume;
import org.junit.Test;

public class ClusterHostTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Assume.assumeTrue((boolean)Utils.isLinux());
    }

    @Test
    public void testClusterHostHintFromClusterManager() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            public String clusterHost() {
                return "127.0.0.3";
            }
        };
        Vertx clusteredVertx = (Vertx)this.clusteredVertx(new VertxOptions(), clusterManager).await();
        this.assertEquals("127.0.0.3", clusterManager.getNodeInfo().host());
    }

    @Test
    public void testClusterPublicHostHintFromClusterManager() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            public String clusterHost() {
                return "127.0.0.2";
            }

            public String clusterPublicHost() {
                return "127.0.0.3";
            }
        };
        Vertx clusteredVertx = (Vertx)this.clusteredVertx(new VertxOptions(), clusterManager).await();
        this.assertEquals("127.0.0.3", clusterManager.getNodeInfo().host());
    }

    @Test
    public void testUserSuppliedHostPrecedence() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            public String clusterHost() {
                return "127.0.0.2";
            }

            public String clusterPublicHost() {
                return "127.0.0.3";
            }
        };
        VertxOptions options = new VertxOptions();
        options.getEventBusOptions().setHost("127.0.0.4");
        Vertx clusteredVertx = (Vertx)this.clusteredVertx(options, clusterManager).await();
        this.assertEquals("127.0.0.4", clusterManager.getNodeInfo().host());
    }
}

