/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import org.junit.Assert;
import org.junit.Test;

public class DeliveryOptionsTest {
    @Test
    public void toJson() throws Exception {
        JsonObject defaultJson = new JsonObject().put("timeout", (Object)30000L).put("localOnly", (Object)false).put("tracingPolicy", (Object)DeliveryOptions.DEFAULT_TRACING_POLICY);
        Assert.assertEquals((Object)defaultJson, (Object)new DeliveryOptions().toJson());
        JsonObject fullJson = new JsonObject().put("timeout", (Object)15000).put("localOnly", (Object)true).put("codecName", (Object)"pimpo").put("headers", (Object)new JsonObject().put("marseille", (Object)"om").put("lyon", (Object)"ol").put("amsterdam", (Object)"ajax")).put("tracingPolicy", (Object)"IGNORE");
        Assert.assertEquals((Object)fullJson, (Object)new DeliveryOptions().setSendTimeout(15000L).setLocalOnly(true).setCodecName("pimpo").addHeader("marseille", "om").addHeader("lyon", "ol").addHeader("amsterdam", "ajax").setTracingPolicy(TracingPolicy.IGNORE).toJson());
        Assert.assertEquals((Object)fullJson, (Object)new DeliveryOptions(fullJson).toJson());
    }

    @Test
    public void ensureClonedHeaders() {
        DeliveryOptions original = new DeliveryOptions();
        original.addHeader("foo", "bar");
        Assert.assertEquals((long)1L, (long)original.getHeaders().size());
        DeliveryOptions cloned = new DeliveryOptions(original);
        Assert.assertEquals((long)1L, (long)cloned.getHeaders().size());
        cloned.addHeader("bar", "foo");
        Assert.assertEquals((long)2L, (long)cloned.getHeaders().size());
        Assert.assertEquals((long)1L, (long)original.getHeaders().size());
    }
}

