/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.netty.util.CharsetUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.tests.shareddata.AsyncMapTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class EventBusTestBase
extends VertxTestBase {
    protected static final String ADDRESS1 = "some-address1";
    protected static final String ADDRESS2 = "some-address2";

    protected abstract Vertx[] vertices(int var1);

    @Test
    public void testSendNull() throws Exception {
        this.testSend(null);
    }

    @Test
    public void testReplyNull() throws Exception {
        this.testReply(null);
    }

    @Test
    public void testPublishNull() throws Exception {
        this.testPublish(null);
    }

    @Test
    public void testSendString() throws Exception {
        String str = TestUtils.randomUnicodeString(100);
        this.testSend(str);
    }

    @Test
    public void testReplyString() throws Exception {
        String str = TestUtils.randomUnicodeString(100);
        this.testReply(str);
    }

    @Test
    public void testPublishString() throws Exception {
        String str = TestUtils.randomUnicodeString(100);
        this.testPublish(str);
    }

    @Test
    public void testSendBooleanTrue() throws Exception {
        this.testSend(true);
    }

    @Test
    public void testSendBooleanFalse() throws Exception {
        this.testSend(false);
    }

    @Test
    public void testReplyBooleanTrue() throws Exception {
        this.testReply(true);
    }

    @Test
    public void testReplyBooleanFalse() throws Exception {
        this.testReply(false);
    }

    @Test
    public void testPublishBooleanTrue() throws Exception {
        this.testPublish(true);
    }

    @Test
    public void testPublishBooleanFalse() throws Exception {
        this.testPublish(false);
    }

    @Test
    public void testSendBuffer() throws Exception {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testSend(sent, buffer -> {
            this.assertEquals(sent, buffer);
            this.assertFalse(sent == buffer);
        });
    }

    @Test
    public void testReplyBuffer() throws Exception {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testReply(sent, bytes -> {
            this.assertEquals(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testPublishBuffer() throws Exception {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testPublish(sent, buffer -> {
            this.assertEquals(sent, buffer);
            this.assertFalse(sent == buffer);
        });
    }

    @Test
    public void testSendByte() throws Exception {
        this.testSend(TestUtils.randomByte());
    }

    @Test
    public void testReplyByte() throws Exception {
        this.testReply(TestUtils.randomByte());
    }

    @Test
    public void testPublishByte() throws Exception {
        this.testPublish(TestUtils.randomByte());
    }

    @Test
    public void testSendByteArray() throws Exception {
        byte[] sent = TestUtils.randomByteArray(100);
        this.testSend(sent, bytes -> {
            TestUtils.byteArraysEqual(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testReplyByteArray() throws Exception {
        byte[] sent = TestUtils.randomByteArray(100);
        this.testReply(sent, bytes -> {
            TestUtils.byteArraysEqual(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testPublishByteArray() throws Exception {
        byte[] sent = TestUtils.randomByteArray(100);
        this.testPublish(sent, bytes -> {
            TestUtils.byteArraysEqual(sent, bytes);
            this.assertFalse(sent == bytes);
        });
    }

    @Test
    public void testSendCharacter() throws Exception {
        this.testSend(Character.valueOf(TestUtils.randomChar()));
    }

    @Test
    public void testReplyCharacter() throws Exception {
        this.testReply(Character.valueOf(TestUtils.randomChar()));
    }

    @Test
    public void testPublishCharacter() throws Exception {
        this.testPublish(Character.valueOf(TestUtils.randomChar()));
    }

    @Test
    public void testSendDouble() throws Exception {
        this.testSend(TestUtils.randomDouble());
    }

    @Test
    public void testReplyDouble() throws Exception {
        this.testReply(TestUtils.randomDouble());
    }

    @Test
    public void testPublishDouble() throws Exception {
        this.testPublish(TestUtils.randomDouble());
    }

    @Test
    public void testSendFloat() throws Exception {
        this.testSend(Float.valueOf(TestUtils.randomFloat()));
    }

    @Test
    public void testReplyFloat() throws Exception {
        this.testReply(Float.valueOf(TestUtils.randomFloat()));
    }

    @Test
    public void testPublishFloat() throws Exception {
        this.testPublish(Float.valueOf(TestUtils.randomFloat()));
    }

    @Test
    public void testSendInteger() throws Exception {
        this.testSend(TestUtils.randomInt());
    }

    @Test
    public void testReplyInteger() throws Exception {
        this.testReply(TestUtils.randomInt());
    }

    @Test
    public void testPublishInteger() throws Exception {
        this.testPublish(TestUtils.randomInt());
    }

    @Test
    public void testSendLong() throws Exception {
        this.testSend(TestUtils.randomLong());
    }

    @Test
    public void testReplyLong() throws Exception {
        this.testReply(TestUtils.randomLong());
    }

    @Test
    public void testPublishLong() throws Exception {
        this.testPublish(TestUtils.randomLong());
    }

    @Test
    public void testSendShort() throws Exception {
        this.testSend(TestUtils.randomShort());
    }

    @Test
    public void testReplyShort() throws Exception {
        this.testReply(TestUtils.randomShort());
    }

    @Test
    public void testPublishShort() throws Exception {
        this.testPublish(TestUtils.randomShort());
    }

    @Test
    public void testSendBigInteger() throws Exception {
        this.testSend(BigInteger.valueOf(TestUtils.randomLong()));
    }

    @Test
    public void testReplyBigInteger() throws Exception {
        this.testReply(BigInteger.valueOf(TestUtils.randomLong()));
    }

    @Test
    public void testPublishBigInteger() throws Exception {
        this.testPublish(BigInteger.valueOf(TestUtils.randomLong()));
    }

    @Test
    public void testSendBigDecimal() throws Exception {
        this.testSend(BigDecimal.valueOf(TestUtils.randomDouble()));
    }

    @Test
    public void testReplyBigDecimal() throws Exception {
        this.testReply(BigDecimal.valueOf(TestUtils.randomDouble()));
    }

    @Test
    public void testPublishBigDecimal() throws Exception {
        this.testPublish(BigDecimal.valueOf(TestUtils.randomDouble()));
    }

    @Test
    public void testSendJsonArray() throws Exception {
        JsonArray arr = new JsonArray();
        arr.add((Object)TestUtils.randomUnicodeString(100)).add((Object)TestUtils.randomInt()).add((Object)TestUtils.randomBoolean());
        this.testSend(arr, received -> {
            this.assertEquals(arr, received);
            this.assertFalse(arr == received);
        });
    }

    @Test
    public void testReplyJsonArray() throws Exception {
        JsonArray arr = new JsonArray();
        arr.add((Object)TestUtils.randomUnicodeString(100)).add((Object)TestUtils.randomInt()).add((Object)TestUtils.randomBoolean());
        this.testReply(arr, received -> {
            this.assertEquals(arr, received);
            this.assertFalse(arr == received);
        });
    }

    @Test
    public void testPublishJsonArray() throws Exception {
        JsonArray arr = new JsonArray();
        arr.add((Object)TestUtils.randomUnicodeString(100)).add((Object)TestUtils.randomInt()).add((Object)TestUtils.randomBoolean());
        this.testPublish(arr, received -> {
            this.assertEquals(arr, received);
            this.assertFalse(arr == received);
        });
    }

    @Test
    public void testSendJsonObject() throws Exception {
        JsonObject obj = new JsonObject();
        obj.put(TestUtils.randomUnicodeString(100), (Object)TestUtils.randomUnicodeString(100)).put(TestUtils.randomUnicodeString(100), (Object)TestUtils.randomInt());
        this.testSend(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testReplyJsonObject() throws Exception {
        JsonObject obj = new JsonObject();
        obj.put(TestUtils.randomUnicodeString(100), (Object)TestUtils.randomUnicodeString(100)).put(TestUtils.randomUnicodeString(100), (Object)TestUtils.randomInt());
        this.testReply(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testPublishJsonObject() throws Exception {
        JsonObject obj = new JsonObject();
        obj.put(TestUtils.randomUnicodeString(100), (Object)TestUtils.randomUnicodeString(100)).put(TestUtils.randomUnicodeString(100), (Object)TestUtils.randomInt());
        this.testPublish(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testSendClusterSerializable() throws Exception {
        AsyncMapTest.SomeClusterSerializableObject obj = new AsyncMapTest.SomeClusterSerializableObject(TestUtils.randomAlphaString(50));
        this.testSend(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testReplyClusterSerializable() throws Exception {
        AsyncMapTest.SomeClusterSerializableObject obj = new AsyncMapTest.SomeClusterSerializableObject(TestUtils.randomAlphaString(50));
        this.testReply(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testPublishClusterSerializable() throws Exception {
        AsyncMapTest.SomeClusterSerializableObject obj = new AsyncMapTest.SomeClusterSerializableObject(TestUtils.randomAlphaString(50));
        this.testPublish(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testSendSerializable() throws Exception {
        AsyncMapTest.SomeSerializableObject obj = new AsyncMapTest.SomeSerializableObject(TestUtils.randomAlphaString(50));
        this.testSend(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testReplySerializable() throws Exception {
        AsyncMapTest.SomeSerializableObject obj = new AsyncMapTest.SomeSerializableObject(TestUtils.randomAlphaString(50));
        this.testReply(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testPublishSerializable() throws Exception {
        AsyncMapTest.SomeSerializableObject obj = new AsyncMapTest.SomeSerializableObject(TestUtils.randomAlphaString(50));
        this.testPublish(obj, received -> {
            this.assertEquals(obj, received);
            this.assertFalse(obj == received);
        });
    }

    @Test
    public void testSendWithCodecFromSelector() throws Exception {
        ImmutableObject obj = new ImmutableObject(TestUtils.randomAlphaString(15));
        this.testSend(obj, received -> {
            this.assertEquals(obj, received);
            this.assertEquals(this.shouldImmutableObjectBeCopied(), obj != received);
        });
    }

    @Test
    public void testReplyWithCodecFromSelector() throws Exception {
        ImmutableObject obj = new ImmutableObject(TestUtils.randomAlphaString(15));
        this.testReply(obj, received -> {
            this.assertEquals(obj, received);
            this.assertEquals(this.shouldImmutableObjectBeCopied(), obj != received);
        });
    }

    @Test
    public void testPublishWithCodecFromSelector() throws Exception {
        ImmutableObject obj = new ImmutableObject(TestUtils.randomAlphaString(15));
        this.testPublish(obj, received -> {
            this.assertEquals(obj, received);
            this.assertEquals(this.shouldImmutableObjectBeCopied(), obj != received);
        });
    }

    protected abstract boolean shouldImmutableObjectBeCopied();

    @Test
    public void testSendWithHeaders() throws Exception {
        this.testSend("foo", "foo", null, new DeliveryOptions().addHeader("uhqwduh", "qijwdqiuwd").addHeader("iojdijef", "iqjwddh"));
    }

    @Test
    public void testSendWithDeliveryOptionsButNoHeaders() throws Exception {
        this.testSend("foo", "foo", null, new DeliveryOptions());
    }

    @Test
    public void testReplyWithHeaders() throws Exception {
        this.testReply("foo", "foo", null, new DeliveryOptions().addHeader("uhqwduh", "qijwdqiuwd").addHeader("iojdijef", "iqjwddh"));
    }

    @Test
    public void testReplyFromWorker() throws Exception {
        final String expectedBody = TestUtils.randomAlphaString(20);
        Vertx[] vertices = this.vertices(2);
        final CountDownLatch latch = new CountDownLatch(1);
        vertices[1].deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                this.vertx.eventBus().consumer(EventBusTestBase.ADDRESS1, msg -> msg.reply((Object)expectedBody)).completion().onComplete(ar -> {
                    EventBusTestBase.this.assertTrue(ar.succeeded());
                    latch.countDown();
                });
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER));
        this.awaitLatch(latch);
        vertices[0].eventBus().request(ADDRESS1, (Object)"whatever").onComplete(this.onSuccess(reply -> {
            this.assertEquals(expectedBody, reply.body());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSendFromExecuteBlocking() throws Exception {
        String expectedBody = TestUtils.randomAlphaString(20);
        CountDownLatch receivedLatch = new CountDownLatch(1);
        Vertx[] vertices = this.vertices(2);
        vertices[1].eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(expectedBody, msg.body());
            receivedLatch.countDown();
        }).completion().onComplete(ar -> {
            this.assertTrue(ar.succeeded());
            vertices[0].executeBlocking(() -> {
                vertices[0].eventBus().send(ADDRESS1, (Object)expectedBody);
                try {
                    this.awaitLatch(receivedLatch);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw e;
                }
                return null;
            }).onComplete(this.onSuccess(ar2 -> this.testComplete()));
        });
        this.await();
    }

    @Test
    public void testNoHandlersCallbackContext() {
        final Vertx[] vertices = this.vertices(2);
        this.waitFor(4);
        vertices[0].eventBus().request("blah", (Object)"blah").onComplete(this.onFailure(err -> {
            if (err instanceof ReplyException) {
                ReplyException cause = (ReplyException)err;
                this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
            } else {
                this.fail((Throwable)err);
            }
            this.assertTrue("Not an EL thread", Context.isOnEventLoopThread());
            this.complete();
        }));
        vertices[0].runOnContext(v -> {
            Context ctx = vertices[0].getOrCreateContext();
            vertices[0].eventBus().request("blah", (Object)"blah").onComplete(this.onFailure(err -> {
                if (err instanceof ReplyException) {
                    ReplyException cause = (ReplyException)err;
                    this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
                } else {
                    this.fail((Throwable)err);
                }
                this.assertSame(ctx, vertices[0].getOrCreateContext());
                this.complete();
            }));
        });
        vertices[0].deployVerticle((Deployable)new AbstractVerticle(){

            public void start() throws Exception {
                Context ctx = this.getVertx().getOrCreateContext();
                vertices[0].eventBus().request("blah", (Object)"blah").onComplete(EventBusTestBase.this.onFailure(err -> {
                    if (err instanceof ReplyException) {
                        ReplyException cause = (ReplyException)err;
                        EventBusTestBase.this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
                    } else {
                        EventBusTestBase.this.fail(err);
                    }
                    EventBusTestBase.this.assertSame(ctx, this.getVertx().getOrCreateContext());
                    EventBusTestBase.this.complete();
                }));
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER)).await();
        vertices[0].executeBlocking(() -> {
            vertices[0].eventBus().request("blah", (Object)"blah").onComplete(this.onFailure(err -> {
                if (err instanceof ReplyException) {
                    ReplyException cause = (ReplyException)err;
                    this.assertSame(ReplyFailure.NO_HANDLERS, cause.failureType());
                } else {
                    this.fail((Throwable)err);
                }
                this.assertTrue("Not an EL thread", Context.isOnEventLoopThread());
                this.complete();
            }));
            return null;
        }, false);
        this.await();
    }

    protected <T> void testSend(T val) throws Exception {
        this.testSend(val, null);
    }

    protected <T, R> void testSend(T val, R received, Consumer<T> consumer, DeliveryOptions options) throws Exception {
        Vertx[] vertices = this.vertices(2);
        MessageConsumer reg = vertices[1].eventBus().consumer(ADDRESS1).handler(msg -> {
            if (consumer == null) {
                this.assertTrue(msg.isSend());
                this.assertEquals(received, msg.body());
                if (options != null) {
                    this.assertNotNull(msg.headers());
                    int numHeaders = options.getHeaders() != null ? options.getHeaders().size() : 0;
                    this.assertEquals(numHeaders, msg.headers().size());
                    if (numHeaders != 0) {
                        for (Map.Entry entry : options.getHeaders().entries()) {
                            this.assertEquals(msg.headers().get((String)entry.getKey()), entry.getValue());
                        }
                    }
                }
            } else {
                consumer.accept(msg.body());
            }
            this.testComplete();
        });
        this.awaitFuture(reg.completion());
        if (options == null) {
            vertices[0].eventBus().send(ADDRESS1, val);
        } else {
            vertices[0].eventBus().send(ADDRESS1, val, options);
        }
        this.await();
    }

    protected <T> void testSend(T val, Consumer<T> consumer) throws Exception {
        this.testSend(val, val, consumer, null);
    }

    protected <T> void testReply(T val) throws Exception {
        this.testReply(val, null);
    }

    protected <T> void testReply(T val, Consumer<T> consumer) throws Exception {
        this.testReply(val, val, consumer, null);
    }

    protected <T, R> void testReply(T val, R received, Consumer<R> consumer, DeliveryOptions options) throws Exception {
        Vertx[] vertices = this.vertices(2);
        String str = TestUtils.randomUnicodeString(1000);
        MessageConsumer reg = vertices[1].eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(str, msg.body());
            if (options == null) {
                msg.reply(val);
            } else {
                msg.reply(val, options);
            }
        });
        this.awaitFuture(reg.completion());
        vertices[0].eventBus().request(ADDRESS1, (Object)str).onComplete(this.onSuccess(reply -> {
            if (consumer == null) {
                this.assertTrue(reply.isSend());
                this.assertEquals(received, reply.body());
                if (options != null && options.getHeaders() != null) {
                    this.assertNotNull(reply.headers());
                    this.assertEquals(options.getHeaders().size(), reply.headers().size());
                    for (Map.Entry entry : options.getHeaders().entries()) {
                        this.assertEquals(reply.headers().get((String)entry.getKey()), entry.getValue());
                    }
                }
            } else {
                consumer.accept(reply.body());
            }
            this.testComplete();
        }));
        this.await();
    }

    protected <T> void testPublish(T val) throws Exception {
        this.testPublish(val, null);
    }

    protected <T> void testPublish(T val, Consumer<T> consumer) throws Exception {
        Vertx[] vertices = this.vertices(3);
        this.waitFor(vertices.length - 1);
        for (int i = 1; i < vertices.length; ++i) {
            MessageConsumer reg = vertices[i].eventBus().consumer(ADDRESS1).handler(msg -> {
                if (consumer == null) {
                    this.assertFalse(msg.isSend());
                    this.assertEquals(val, msg.body());
                } else {
                    consumer.accept(msg.body());
                }
                this.complete();
            });
            this.awaitFuture(reg.completion());
        }
        vertices[0].eventBus().publish(ADDRESS1, val);
        this.await();
    }

    @Test
    public void testConsumerUnregistrationContextCallback() throws Exception {
        Vertx[] vertices = this.vertices(1);
        Vertx vertx = vertices[0];
        CompletableFuture latch = new CompletableFuture();
        Thread th = new Thread(() -> {
            Context ctx = vertx.getOrCreateContext();
            ctx.runOnContext(v1 -> {
                MessageConsumer consumer = vertx.eventBus().consumer(ADDRESS1);
                latch.complete(consumer);
            });
        });
        th.start();
        MessageConsumer consumer = (MessageConsumer)latch.get(20L, TimeUnit.SECONDS);
        Context ctx = vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> consumer.unregister().onComplete(this.onSuccess(v2 -> {
            this.assertSame(ctx, Vertx.currentContext());
            this.testComplete();
        })));
        this.await();
    }

    public static class ImmutableObjectCodec
    implements MessageCodec<ImmutableObject, ImmutableObject> {
        public void encodeToWire(Buffer buffer, ImmutableObject immutableObject) {
            CodecManager.STRING_MESSAGE_CODEC.encodeToWire(buffer, (Object)immutableObject.str);
        }

        public ImmutableObject decodeFromWire(int pos, Buffer buffer) {
            return new ImmutableObject((String)CodecManager.STRING_MESSAGE_CODEC.decodeFromWire(pos, buffer));
        }

        public ImmutableObject transform(ImmutableObject immutableObject) {
            return immutableObject;
        }

        public String name() {
            return "ImmutableObjectCodec";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class ImmutableObject {
        public final String str;

        public ImmutableObject(String str) {
            this.str = Objects.requireNonNull(str);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableObject that = (ImmutableObject)o;
            return this.str.equals(that.str);
        }

        public int hashCode() {
            return this.str.hashCode();
        }
    }

    public static class StringLengthCodec
    implements MessageCodec<String, Integer> {
        public void encodeToWire(Buffer buffer, String s) {
            buffer.appendInt(s.length());
        }

        public Integer decodeFromWire(int pos, Buffer buffer) {
            return buffer.getInt(pos);
        }

        public Integer transform(String s) {
            return s.length();
        }

        public String name() {
            return this.getClass().getName();
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class MyReplyExceptionMessageCodec
    implements MessageCodec<MyReplyException, MyReplyException> {
        public void encodeToWire(Buffer buffer, MyReplyException body) {
            buffer.appendInt(body.failureCode());
            if (body.getMessage() == null) {
                buffer.appendByte((byte)0);
            } else {
                buffer.appendByte((byte)1);
                byte[] encoded = body.getMessage().getBytes(CharsetUtil.UTF_8);
                buffer.appendInt(encoded.length);
                buffer.appendBytes(encoded);
            }
        }

        public MyReplyException decodeFromWire(int pos, Buffer buffer) {
            String message;
            boolean isNull;
            int failureCode = buffer.getInt(pos);
            boolean bl = isNull = buffer.getByte(pos += 4) == 0;
            if (!isNull) {
                int strLength = buffer.getInt(++pos);
                byte[] bytes = buffer.getBytes(pos += 4, pos + strLength);
                message = new String(bytes, CharsetUtil.UTF_8);
            } else {
                message = null;
            }
            return new MyReplyException(failureCode, message);
        }

        public MyReplyException transform(MyReplyException obj) {
            return obj;
        }

        public String name() {
            return "myReplyException";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class MyReplyException
    extends ReplyException {
        public MyReplyException(int failureCode, String message) {
            super(ReplyFailure.RECIPIENT_FAILURE, failureCode, message);
        }
    }

    public static class MyPOJO {
        private String str;

        public MyPOJO(String str) {
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPOJO myPOJO = (MyPOJO)o;
            return !(this.str != null ? !this.str.equals(myPOJO.str) : myPOJO.str != null);
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }
    }

    public static class MyPOJOEncoder2
    implements MessageCodec<MyPOJO, MyPOJO> {
        public void encodeToWire(Buffer buffer, MyPOJO myPOJO) {
            byte[] bytes = myPOJO.getStr().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(bytes.length);
            buffer.appendBytes(bytes);
        }

        public MyPOJO decodeFromWire(int pos, Buffer buffer) {
            int length = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + length);
            String str = new String(bytes, CharsetUtil.UTF_8);
            return new MyPOJO(str);
        }

        public MyPOJO transform(MyPOJO myPOJO) {
            return new MyPOJO(myPOJO.getStr());
        }

        public String name() {
            return "mypojoencoder2";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class MyPOJOEncoder1
    implements MessageCodec<MyPOJO, String> {
        public void encodeToWire(Buffer buffer, MyPOJO myPOJO) {
            byte[] bytes = myPOJO.getStr().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(bytes.length);
            buffer.appendBytes(bytes);
        }

        public String decodeFromWire(int pos, Buffer buffer) {
            int length = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + length);
            return new String(bytes, CharsetUtil.UTF_8);
        }

        public String transform(MyPOJO myPOJO) {
            return myPOJO.getStr();
        }

        public String name() {
            return "mypojoencoder1";
        }

        public byte systemCodecID() {
            return -1;
        }
    }

    public static class NullNameCodec
    implements MessageCodec<String, String> {
        public void encodeToWire(Buffer buffer, String s) {
        }

        public String decodeFromWire(int pos, Buffer buffer) {
            return null;
        }

        public String transform(String s) {
            return null;
        }

        public String name() {
            return null;
        }

        public byte systemCodecID() {
            return 0;
        }
    }

    public static class MySystemDecoder
    implements MessageCodec<MyPOJO, String> {
        public void encodeToWire(Buffer buffer, MyPOJO s) {
        }

        public String decodeFromWire(int pos, Buffer buffer) {
            return null;
        }

        public String transform(MyPOJO s) {
            return null;
        }

        public String name() {
            return "mysystemdecoder";
        }

        public byte systemCodecID() {
            return 0;
        }
    }
}

