/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import io.vertx.tests.eventbus.FaultToleranceVerticle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.junit.Test;

public abstract class FaultToleranceTest
extends VertxTestBase {
    protected static final int NODE_COUNT = 3;
    protected static final int ADDRESSES_COUNT = 10;
    protected final List<Process> externalNodes = new ArrayList<Process>();
    protected final AtomicLong externalNodesStarted = new AtomicLong();
    protected final AtomicLong pongsReceived = new AtomicLong();
    protected final AtomicLong noHandlersErrors = new AtomicLong();
    protected long timeoutMs = 60000L;
    protected VertxInternal vertx;

    @Test
    public void testFaultTolerance() throws Exception {
        this.startNodes(1);
        this.vertx = (VertxInternal)this.vertices[0];
        this.vertx.eventBus().consumer("control", msg -> {
            switch ((String)msg.body()) {
                case "start": {
                    this.externalNodesStarted.incrementAndGet();
                    break;
                }
                case "pong": {
                    this.pongsReceived.incrementAndGet();
                    break;
                }
                case "noHandlers": {
                    this.noHandlersErrors.incrementAndGet();
                }
            }
        });
        for (int i = 0; i < 3; ++i) {
            Process process = this.startExternalNode(i);
            this.externalNodes.add(process);
            this.afterNodeStarted(i, process);
        }
        this.afterNodesStarted();
        JsonArray message1 = new JsonArray();
        IntStream.range(0, 3).forEach(arg_0 -> ((JsonArray)message1).add(arg_0));
        this.vertx.eventBus().publish("ping", (Object)message1);
        this.assertEqualsEventually("All pongs", 90L, this.pongsReceived::get);
        for (int i = 0; i < 2; ++i) {
            Process process = this.externalNodes.get(i);
            process.destroyForcibly();
            this.afterNodeKilled(i, process);
        }
        this.afterNodesKilled();
        this.pongsReceived.set(0L);
        JsonArray message2 = new JsonArray().add((Object)2);
        this.vertx.eventBus().publish("ping", (Object)message2);
        this.assertEqualsEventually("Survivor pongs", 10L, this.pongsReceived::get);
        JsonArray message3 = new JsonArray();
        IntStream.range(0, 2).forEach(arg_0 -> ((JsonArray)message3).add(arg_0));
        this.vertx.eventBus().publish("ping", (Object)message3);
        this.assertEqualsEventually("Dead errors", 20L, this.noHandlersErrors::get);
    }

    protected void afterNodeStarted(int i, Process process) throws Exception {
    }

    protected void afterNodesStarted() throws Exception {
        this.assertEqualsEventually("Nodes ready", 3L, this.externalNodesStarted::get);
    }

    protected void afterNodeKilled(int i, Process process) throws Exception {
    }

    protected void afterNodesKilled() throws Exception {
        ClusterManager clusterManager = this.vertx.clusterManager();
        this.assertEqualsEventually("Remaining members", 2, () -> clusterManager.getNodes().size());
    }

    protected Process startExternalNode(int id) throws Exception {
        String javaHome = System.getProperty("java.home");
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaHome + File.separator + "bin" + File.separator + "java");
        command.add("-classpath");
        command.add(classpath);
        command.addAll(this.getExternalNodeSystemProperties());
        command.add(FaultToleranceVerticle.class.getName());
        command.add(new JsonObject().put("id", (Object)id).put("addressesCount", (Object)10).encode());
        return new ProcessBuilder(command).inheritIO().start();
    }

    protected List<String> getExternalNodeSystemProperties() {
        return Collections.emptyList();
    }

    protected void assertEqualsEventually(String msg, Object expected, Supplier<Object> actual) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.timeoutMs) {
            Object act = actual.get();
            if (Objects.equals(expected, act)) {
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.assertEquals(msg, expected, actual.get());
    }

    @Override
    protected void tearDown() throws Exception {
        this.externalNodes.forEach(Process::destroyForcibly);
        super.tearDown();
    }
}

