/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Completable;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;

public class FaultToleranceVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(FaultToleranceVerticle.class);
    private int id;
    private int numAddresses;

    public static void main(String[] args) {
        Vertx.clusteredVertx((VertxOptions)new VertxOptions()).compose(vertx -> {
            JsonObject config = new JsonObject(args[0]);
            return vertx.deployVerticle((Deployable)new FaultToleranceVerticle(), new DeploymentOptions().setConfig(config));
        }).onFailure(Throwable::printStackTrace);
    }

    public void start() throws Exception {
        JsonObject config = this.config();
        this.id = config.getInteger("id");
        this.numAddresses = config.getInteger("addressesCount");
        ArrayList<Future> registrationFutures = new ArrayList<Future>(this.numAddresses);
        for (int i = 0; i < this.numAddresses; ++i) {
            Promise registrationFuture = Promise.promise();
            registrationFutures.add(registrationFuture.future());
            this.vertx.eventBus().consumer(this.createAddress(this.id, i), msg -> msg.reply((Object)"pong")).completion().onComplete((Completable)registrationFuture);
        }
        Promise registrationFuture = Promise.promise();
        registrationFutures.add(registrationFuture.future());
        this.vertx.eventBus().consumer("ping", this::ping).completion().onComplete((Completable)registrationFuture);
        Future.all(registrationFutures).onSuccess(ar -> this.vertx.eventBus().send("control", (Object)"start"));
    }

    private void ping(Message<JsonArray> message) {
        JsonArray jsonArray = (JsonArray)message.body();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int node = jsonArray.getInteger(i);
            for (int j = 0; j < this.numAddresses; ++j) {
                this.vertx.eventBus().request(this.createAddress(node, j), (Object)"ping").onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.vertx.eventBus().send("control", (Object)"pong");
                    } else {
                        ReplyException replyException;
                        Throwable cause = ar.cause();
                        if (cause instanceof ReplyException && (replyException = (ReplyException)cause).failureType() == ReplyFailure.NO_HANDLERS) {
                            this.vertx.eventBus().send("control", (Object)"noHandlers");
                            return;
                        }
                        log.error((Object)("Unexpected error during ping (id=" + this.id + ")"), cause);
                    }
                });
            }
        }
    }

    private String createAddress(int id, int i) {
        return "address-" + id + "-" + i;
    }
}

