/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Test;

public class JsonEventBusTest
extends VertxTestBase {
    private EventBus eb;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.eb = this.vertx.eventBus();
    }

    @Test
    public void testChangesNotVisibleObject1() {
        JsonObject obj = new JsonObject();
        this.eb.consumer("foo").handler(msg -> {
            this.assertFalse(((JsonObject)msg.body()).containsKey("b"));
            this.testComplete();
        });
        this.eb.send("foo", (Object)obj);
        obj.put("b", (Object)"blurrgg");
        this.await();
    }

    @Test
    public void testChangesNotVisibleObject2() {
        JsonObject obj = new JsonObject();
        this.eb.consumer("foo").handler(msg -> ((JsonObject)msg.body()).put("b", (Object)"uqwduihwqd"));
        this.eb.send("foo", (Object)obj);
        this.vertx.setTimer(1000L, id -> {
            this.assertFalse(obj.containsKey("b"));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testChangesNotVisibleObject3() {
        HashMap<String, String> map = new HashMap<String, String>();
        JsonObject obj = new JsonObject(map);
        this.eb.consumer("foo").handler(msg -> this.vertx.setTimer(1000L, id -> {
            this.assertFalse(((JsonObject)msg.body()).containsKey("b"));
            this.testComplete();
        }));
        this.eb.send("foo", (Object)obj);
        map.put("b", "uhqdihuqwd");
        this.await();
    }

    @Test
    public void testChangesNotVisibleArray1() {
        JsonArray obj = new JsonArray();
        this.eb.consumer("foo").handler(msg -> {
            this.assertEquals(0L, ((JsonArray)msg.body()).size());
            this.testComplete();
        });
        this.eb.send("foo", (Object)obj);
        obj.add((Object)"blah");
        this.await();
    }

    @Test
    public void testChangesNotVisibleArray2() {
        JsonArray obj = new JsonArray();
        this.eb.consumer("foo").handler(msg -> ((JsonArray)msg.body()).add((Object)"blah"));
        this.eb.send("foo", (Object)obj);
        this.vertx.setTimer(1000L, id -> {
            this.assertEquals(0L, obj.size());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testChangesNotVisibleArray3() {
        ArrayList<String> list = new ArrayList<String>();
        JsonArray obj = new JsonArray(list);
        this.eb.consumer("foo").handler(msg -> this.vertx.setTimer(1000L, id -> {
            this.assertEquals(0L, ((JsonArray)msg.body()).size());
            this.testComplete();
        }));
        this.eb.send("foo", (Object)obj);
        list.add("uhwqdiuh");
        this.await();
    }
}

