/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.Completable;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.impl.clustered.NodeSelector;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.ClusteredNode;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationListener;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import java.util.List;
import java.util.Map;

public class WrappedClusterManager
implements ClusterManager {
    private final ClusterManager delegate;
    private NodeSelector nodeSelector;

    public WrappedClusterManager(ClusterManager delegate) {
        this.delegate = delegate;
    }

    public void init(Vertx vertx) {
        this.delegate.init(vertx);
    }

    public <K, V> void getAsyncMap(String name, Completable<AsyncMap<K, V>> promise) {
        this.delegate.getAsyncMap(name, promise);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.delegate.getSyncMap(name);
    }

    public void getLockWithTimeout(String name, long timeout, Completable<Lock> promise) {
        this.delegate.getLockWithTimeout(name, timeout, promise);
    }

    public void getCounter(String name, Completable<Counter> promise) {
        this.delegate.getCounter(name, promise);
    }

    public String getNodeId() {
        return this.delegate.getNodeId();
    }

    public List<String> getNodes() {
        return this.delegate.getNodes();
    }

    public void nodeListener(NodeListener listener) {
        this.delegate.nodeListener(listener);
    }

    public void setNodeInfo(NodeInfo nodeInfo, Completable<Void> promise) {
        this.delegate.setNodeInfo(nodeInfo, promise);
    }

    public NodeInfo getNodeInfo() {
        return this.delegate.getNodeInfo();
    }

    public void getNodeInfo(String nodeId, Completable<NodeInfo> promise) {
        this.delegate.getNodeInfo(nodeId, promise);
    }

    public void join(Completable<Void> promise) {
        this.delegate.join(promise);
    }

    public void leave(Completable<Void> promise) {
        this.delegate.leave(promise);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public final void registrationListener(RegistrationListener registrationListener) {
        this.nodeSelector = (NodeSelector)registrationListener;
        NodeSelector interceptor = new NodeSelector(){

            public void init(ClusteredNode clusterManager) {
                WrappedClusterManager.this.nodeSelector.init(clusterManager);
            }

            public void eventBusStarted() {
                WrappedClusterManager.this.nodeSelector.eventBusStarted();
            }

            public void selectForSend(String address, Completable<String> promise) {
                WrappedClusterManager.this.nodeSelector.selectForSend(address, promise);
            }

            public void selectForPublish(String address, Completable<Iterable<String>> promise) {
                WrappedClusterManager.this.nodeSelector.selectForPublish(address, promise);
            }

            public void registrationsUpdated(RegistrationUpdateEvent event) {
                WrappedClusterManager.this.registrationsUpdated(event);
            }

            public void registrationsLost() {
                WrappedClusterManager.this.registrationsLost();
            }

            public boolean wantsUpdatesFor(String address) {
                return WrappedClusterManager.this.wantsUpdatesFor(address);
            }
        };
        this.delegate.registrationListener((RegistrationListener)interceptor);
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Completable<Void> promise) {
        this.delegate.addRegistration(address, registrationInfo, promise);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Completable<Void> promise) {
        this.delegate.removeRegistration(address, registrationInfo, promise);
    }

    public void getRegistrations(String address, Completable<List<RegistrationInfo>> promise) {
        this.delegate.getRegistrations(address, promise);
    }

    public String clusterHost() {
        return this.delegate.clusterHost();
    }

    public String clusterPublicHost() {
        return this.delegate.clusterPublicHost();
    }

    public ClusterManager getDelegate() {
        return this.delegate;
    }

    public void registrationsUpdated(RegistrationUpdateEvent event) {
        this.nodeSelector.registrationsUpdated(event);
    }

    public void registrationsLost() {
        this.nodeSelector.registrationsLost();
    }

    public boolean wantsUpdatesFor(String address) {
        return this.nodeSelector.wantsUpdatesFor(address);
    }
}

