/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.eventbus;

import io.vertx.core.Completable;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.impl.clustered.DefaultNodeSelector;
import io.vertx.core.eventbus.impl.clustered.NodeSelector;
import io.vertx.core.impl.VertxBootstrapImpl;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.Collections;
import org.junit.Test;

public final class WriteHandlerLookupFailureTest
extends VertxTestBase {
    private Vertx vertx;

    @Test
    public void test() {
        final Throwable cause = new Throwable();
        VertxOptions options = new VertxOptions();
        options.getEventBusOptions().setHost("localhost").setPort(0);
        DefaultNodeSelector nodeSelector = new DefaultNodeSelector(){

            public void selectForSend(String address, Completable<String> promise) {
                promise.fail(cause);
            }

            public void selectForPublish(String address, Completable<Iterable<String>> promise) {
                promise.fail("Not implemented");
            }
        };
        ((VertxBootstrapImpl)VertxBootstrap.create().options(options).init()).clusterManager((ClusterManager)new FakeClusterManager()).clusterNodeSelector((NodeSelector)nodeSelector).clusteredVertx().onComplete(this.onSuccess(node -> {
            this.vertx = node;
            MessageProducer sender = this.vertx.eventBus().sender("foo");
            sender.write((Object)"the_string").onComplete(this.onFailure(err -> {
                this.assertSame(cause, err);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.vertx != null) {
                this.close(Collections.singletonList(this.vertx));
            }
        }
        finally {
            super.tearDown();
        }
    }
}

