/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.file;

import io.vertx.tests.file.FileResolverTestBase;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Test;

public class FileSystemFileResolverTest
extends FileResolverTestBase {
    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        return new URLClassLoader(new URL[]{new File(baseDir, "files").toURI().toURL()}, Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testResolvePlusSignsOnName() {
        File file = this.resolver.resolve("this+that");
        this.assertFalse(file.exists());
        this.assertEquals("this+that", file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveInvalidFileName() throws Exception {
        for (int i = 0; i < 256; ++i) {
            final String s = "file-" + (char)i + "-";
            final File f = File.createTempFile("vertx", ".txt");
            Files.write(f.toPath(), "the_content".getBytes(), new OpenOption[0]);
            Thread thread = Thread.currentThread();
            ClassLoader prev = thread.getContextClassLoader();
            URLClassLoader next = new URLClassLoader(new URL[0], prev){

                @Override
                public URL getResource(String name) {
                    if (s.equals(name)) {
                        try {
                            return f.toURL();
                        }
                        catch (MalformedURLException e) {
                            FileSystemFileResolverTest.this.fail(e);
                        }
                    }
                    return super.getResource(name);
                }
            };
            thread.setContextClassLoader(next);
            try {
                File file = this.resolver.resolve(s);
                this.assertNotNull(file);
                continue;
            }
            finally {
                thread.setContextClassLoader(prev);
            }
        }
    }

    @Override
    public void testResolveFileWithSpaceAtEndFromClasspath() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverrideClassLoaderURL() throws Exception {
        File f = File.createTempFile("vertx", ".txt");
        Files.write(f.toPath(), "the_content".getBytes(), new OpenOption[0]);
        final URL url = f.toURI().toURL();
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        URLClassLoader next = new URLClassLoader(new URL[0], prev){

            @Override
            public URL getResource(String name) {
                if ("a/a.txt".equals(name)) {
                    return url;
                }
                return super.getResource(name);
            }
        };
        thread.setContextClassLoader(next);
        try {
            File file = this.resolver.resolve("a/a.txt");
            String content = Files.readString(file.toPath());
            this.assertEquals("the_content", content);
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }
}

