/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.file;

import io.vertx.test.core.TestUtils;
import io.vertx.tests.file.FileResolverTestBase;
import io.vertx.tests.file.ZipFileResolverTest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class JarFileResolverWithSpacesTest
extends FileResolverTestBase {
    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File dirWithSpaces = Files.createTempDirectory(TestUtils.MAVEN_TARGET_DIR.toPath(), "dir with spaces", new FileAttribute[0]).toFile();
        File files = ZipFileResolverTest.getFiles(baseDir, new File(dirWithSpaces, "files.jar"), out -> {
            try {
                return new JarOutputStream((OutputStream)out);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }, JarEntry::new);
        return new URLClassLoader(new URL[]{files.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
    }
}

