/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.file;

import io.vertx.test.core.TestUtils;
import io.vertx.tests.file.FileResolverTestBase;
import io.vertx.tests.file.JarFileResolverTest;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class NestedJarFileResolverTest
extends FileResolverTestBase {
    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File nestedFiles = Files.createTempFile(TestUtils.MAVEN_TARGET_DIR.toPath(), "", "nested-files.jar", new FileAttribute[0]).toFile();
        File files = JarFileResolverTest.getFiles(baseDir);
        try (JarOutputStream jar = new JarOutputStream(new FileOutputStream(nestedFiles));){
            jar.putNextEntry(new JarEntry("lib/"));
            jar.closeEntry();
            jar.putNextEntry(new JarEntry("lib/nested.jar"));
            jar.write(Files.readAllBytes(files.toPath()));
            jar.closeEntry();
        }
        final URL webrootURL = nestedFiles.toURI().toURL();
        return new ClassLoader(Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                try {
                    if (name.startsWith("lib/")) {
                        return new URL("jar:" + String.valueOf(webrootURL) + "!/" + name);
                    }
                    if (name.startsWith("webroot")) {
                        return new URL("jar:" + String.valueOf(webrootURL) + "!/lib/nested.jar!/" + name.substring(7));
                    }
                    if (name.equals("afile.html")) {
                        return new URL("jar:" + String.valueOf(webrootURL) + "!/lib/nested.jar!/afile.html");
                    }
                    if (name.equals("afile with spaces.html")) {
                        return new URL("jar:" + String.valueOf(webrootURL) + "!/lib/nested.jar!/afile with spaces.html");
                    }
                    if (name.equals("afilewithspaceatend ")) {
                        return new URL("jar:" + String.valueOf(webrootURL) + "!/lib/nested.jar!/afilewithspaceatend ");
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                return super.getResource(name);
            }
        };
    }
}

