/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.future;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Test;

public class FutureAwaitTest
extends VertxTestBase {
    @Test
    public void testAwaitFromEventLoopThread() {
        Promise promise = Promise.promise();
        Future future = promise.future();
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ctx.nettyEventLoop().execute(() -> {
            try {
                future.await();
            }
            catch (IllegalStateException expected) {
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testAwaitFromNonVertxThread() {
        Promise promise = Promise.promise();
        Future future = promise.future();
        Thread current = Thread.currentThread();
        new Thread(() -> {
            while (current.getState() != Thread.State.WAITING) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            promise.complete((Object)"the-result");
        }).start();
        String res = (String)future.await();
        this.assertEquals("the-result", res);
    }

    @Test
    public void testAwaitWithTimeout() {
        Promise promise = Promise.promise();
        Future future = promise.future();
        long now = System.currentTimeMillis();
        try {
            future.await(100L, TimeUnit.MILLISECONDS);
            this.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.assertTrue(System.currentTimeMillis() - now >= 100L);
    }

    @Test
    public void testAwaitNoStackTraceFailure() {
        String msg = TestUtils.randomAlphaString(10);
        Future future = Future.failedFuture((String)msg);
        try {
            future.await();
            this.fail();
        }
        catch (Exception expected) {
            this.assertSame(msg, expected.getMessage());
        }
    }

    @Test
    public void testAwaitThrowsTimeoutException() {
        TimeoutException failure = new TimeoutException();
        try {
            Future.failedFuture((Throwable)failure).await();
            this.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

