/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.future;

import io.vertx.core.Completable;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.FutureImpl;
import io.vertx.tests.future.FutureTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class FutureInternalTest
extends FutureTestBase {
    @Test
    public void testAddListener() {
        FutureImpl future = (FutureImpl)Promise.promise();
        AtomicInteger successes = new AtomicInteger();
        AtomicInteger failures = new AtomicInteger();
        Completable listener = (value, err) -> (err == null ? successes : failures).incrementAndGet();
        future.addListener(listener);
        future.tryComplete(null);
        this.assertEquals(1L, successes.get());
        this.assertEquals(0L, failures.get());
    }

    @Test
    public void testRemoveListener1() {
        this.testRemoveListener((FutureImpl<Void>)((FutureImpl)Promise.promise()));
    }

    @Test
    public void testRemoveListener2() {
        FutureImpl fut = (FutureImpl)Promise.promise();
        fut.onComplete(ar -> {});
        this.testRemoveListener((FutureImpl<Void>)fut);
    }

    private void testRemoveListener(FutureImpl<Void> future) {
        AtomicInteger count = new AtomicInteger();
        Completable listener = (value, err) -> count.incrementAndGet();
        future.addListener(listener);
        future.removeListener(listener);
        future.tryComplete(null);
        this.assertEquals(0L, count.get());
    }
}

