/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class FutureTestBase
extends VertxTestBase {

    class Checker<T> {
        private final Future<T> future;
        private final AtomicReference<AsyncResult<T>> result = new AtomicReference();
        private final AtomicInteger count = new AtomicInteger();

        Checker(Future<T> future) {
            future.onComplete(ar -> {
                this.count.incrementAndGet();
                this.result.set((AsyncResult<T>)ar);
            });
            this.future = future;
        }

        void assertNotCompleted() {
            FutureTestBase.this.assertFalse(this.future.isComplete());
            FutureTestBase.this.assertFalse(this.future.succeeded());
            FutureTestBase.this.assertFalse(this.future.failed());
            FutureTestBase.this.assertNull(this.future.cause());
            FutureTestBase.this.assertNull(this.future.result());
            FutureTestBase.this.assertEquals(0L, this.count.get());
            FutureTestBase.this.assertNull(this.result.get());
        }

        void assertSucceeded(T expected) {
            FutureTestBase.this.assertTrue(this.future.isComplete());
            FutureTestBase.this.assertTrue(this.future.succeeded());
            FutureTestBase.this.assertFalse(this.future.failed());
            FutureTestBase.this.assertNull(this.future.cause());
            FutureTestBase.this.assertEquals(expected, this.future.result());
            FutureTestBase.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTestBase.this.assertNotNull(ar);
            FutureTestBase.this.assertTrue(ar.succeeded());
            FutureTestBase.this.assertFalse(ar.failed());
            FutureTestBase.this.assertNull(ar.cause());
            FutureTestBase.this.assertEquals(expected, this.future.result());
        }

        void assertFailed(Throwable expected) {
            FutureTestBase.this.assertEquals(expected, this.assertFailed());
        }

        Throwable assertFailed() {
            FutureTestBase.this.assertTrue(this.future.isComplete());
            FutureTestBase.this.assertFalse(this.future.succeeded());
            FutureTestBase.this.assertTrue(this.future.failed());
            FutureTestBase.this.assertEquals(null, this.future.result());
            FutureTestBase.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTestBase.this.assertNotNull(ar);
            FutureTestBase.this.assertFalse(ar.succeeded());
            FutureTestBase.this.assertTrue(ar.failed());
            FutureTestBase.this.assertNull(ar.result());
            return this.future.cause();
        }
    }
}

