/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.ha;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.tests.ha.HAVerticle2;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public final class HAQuorumTest
extends VertxTestBase {
    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager(){

            @Override
            public void nodeListener(NodeListener listener) {
            }
        };
    }

    @Test
    public void quorumIsObtainedOnNodeInfoPutThatDoneLaterThanClusterWasCreated() throws Exception {
        Vertx vertx1 = this.startVertx(2);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        options.setConfig(config);
        Map haInfoMap = this.getClusterManager().getSyncMap("__vertx.haInfo");
        this.assertEquals(1L, haInfoMap.size());
        Map.Entry vertx1HaInfo = haInfoMap.entrySet().iterator().next();
        haInfoMap.remove(vertx1HaInfo.getKey());
        Vertx vertx2 = this.startVertx(2);
        vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), options).onComplete(this.onSuccess(id -> {
            this.assertTrue(vertx2.deploymentIDs().contains(id));
            this.testComplete();
        }));
        HAQuorumTest.assertWaitUntil(() -> vertx2.deploymentIDs().isEmpty());
        haInfoMap.put((String)vertx1HaInfo.getKey(), (String)vertx1HaInfo.getValue());
        this.await();
        this.closeVertices(vertx1, vertx2);
    }

    private Vertx startVertx(int quorumSize) throws Exception {
        VertxOptions options = new VertxOptions().setHAEnabled(true);
        options.getEventBusOptions().setHost("localhost");
        options.setQuorumSize(quorumSize);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference vertxRef = new AtomicReference();
        Vertx.builder().with(options).withClusterManager(this.getClusterManager()).buildClustered().onComplete(this.onSuccess(vertx -> {
            vertxRef.set(vertx);
            latch.countDown();
        }));
        latch.await(2L, TimeUnit.MINUTES);
        return (Vertx)vertxRef.get();
    }

    private void closeVertices(Vertx ... vertices) throws Exception {
        CountDownLatch latch = new CountDownLatch(vertices.length);
        for (Vertx vertex : vertices) {
            if (vertex != null) {
                vertex.close().onComplete(this.onSuccess(res -> latch.countDown()));
                continue;
            }
            latch.countDown();
        }
        this.awaitLatch(latch, 2L, TimeUnit.MINUTES);
    }
}

