/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.ha;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.deployment.DeploymentContext;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.tests.ha.HAVerticle1;
import io.vertx.tests.ha.HAVerticle2;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class HATest
extends VertxTestBase {
    protected Vertx vertx1;
    protected Vertx vertx2;
    protected Vertx vertx3;
    protected Vertx vertx4 = null;

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    protected void tearDown() throws Exception {
        this.closeVertices(this.vertx1, this.vertx2, this.vertx3, this.vertx4);
        super.tearDown();
    }

    @Test
    public void testSimpleFailover() throws Exception {
        this.startNodes(2, new VertxOptions().setHAEnabled(true));
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        options.setConfig(config);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertices[0].deployVerticle("java:" + HAVerticle1.class.getName(), options).onComplete(this.onSuccess(v -> {
            this.assertEquals(1L, this.vertices[0].deploymentIDs().size());
            this.assertEquals(0L, this.vertices[1].deploymentIDs().size());
            latch.countDown();
        }));
        this.awaitLatch(latch);
        this.kill(0);
        HATest.assertWaitUntil(() -> this.vertices[1].deploymentIDs().size() == 1);
        this.checkDeploymentExists(1, "java:" + HAVerticle1.class.getName(), options);
    }

    @Test
    public void testQuorum() throws Exception {
        this.vertx1 = this.startVertx(2);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        options.setConfig(config);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), options).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx1.deploymentIDs().contains(id));
            this.testComplete();
        }));
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().isEmpty());
        this.vertx2 = this.startVertx(2);
        this.await();
    }

    @Test
    public void testQuorumLost() throws Exception {
        this.vertx1 = this.startVertx(3);
        this.vertx2 = this.startVertx(3);
        this.vertx3 = this.startVertx(3);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        options.setConfig(config);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), options).onComplete(this.onSuccess(id -> this.assertTrue(this.vertx1.deploymentIDs().contains(id))));
        this.vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), options).onComplete(this.onSuccess(id -> this.assertTrue(this.vertx2.deploymentIDs().contains(id))));
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().size() == 1 && this.vertx2.deploymentIDs().size() == 1);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx3.close().onComplete(ar -> latch.countDown());
        this.awaitLatch(latch);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().isEmpty() && this.vertx2.deploymentIDs().isEmpty());
        this.vertx4 = this.startVertx(3);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().size() == 1 && this.vertx2.deploymentIDs().size() == 1);
    }

    @Test
    public void testCleanCloseNoFailover() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", (Object)"bar");
        options.setConfig(config);
        CountDownLatch deployLatch = new CountDownLatch(1);
        this.vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), options).onComplete(this.onSuccess(id -> deployLatch.countDown()));
        this.awaitLatch(deployLatch);
        ((VertxImpl)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not be called"));
        this.vertx2.close().onComplete(ar -> this.vertx.setTimer(500L, tid -> this.testComplete()));
        this.await();
    }

    @Test
    public void testFailureInFailover() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        this.vertx3 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(1);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx1.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        ((VertxImpl)this.vertx2).haManager().failDuringFailover(true);
        ((VertxImpl)this.vertx3).haManager().failDuringFailover(true);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxImpl)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertFalse(succeeded);
            latch2.countDown();
        });
        ((VertxImpl)this.vertx3).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertFalse(succeeded);
            latch2.countDown();
        });
        ((VertxImpl)this.vertx1).haManager().simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx2.deploymentIDs().isEmpty());
        this.assertTrue(this.vertx3.deploymentIDs().isEmpty());
        ((VertxImpl)this.vertx2).haManager().failDuringFailover(false);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((VertxImpl)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch3.countDown();
        });
        ((VertxImpl)this.vertx3).haManager().simulateKill();
        this.awaitLatch(latch3);
        HATest.assertWaitUntil(() -> this.vertx2.deploymentIDs().size() == 1);
    }

    @Test
    public void testHaGroups() throws Exception {
        this.vertx1 = this.startVertx("group1", 1);
        this.vertx2 = this.startVertx("group1", 1);
        this.vertx3 = this.startVertx("group2", 1);
        this.vertx4 = this.startVertx("group2", 1);
        CountDownLatch latch1 = new CountDownLatch(2);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx1.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.vertx3.deployVerticle("java:" + HAVerticle2.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx3.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxImpl)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 1"));
        ((VertxImpl)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 2"));
        ((VertxImpl)this.vertx4).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch2.countDown();
        });
        ((VertxImpl)this.vertx3).haManager().simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx4.deploymentIDs().size() == 1);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((VertxImpl)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch3.countDown();
        });
        ((VertxImpl)this.vertx4).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 4"));
        ((VertxImpl)this.vertx1).haManager().simulateKill();
        this.awaitLatch(latch3);
        this.assertTrue(this.vertx2.deploymentIDs().size() == 1);
    }

    @Test
    public void testNoFailoverToNonHANode() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx(null, 0, false);
        CountDownLatch latch1 = new CountDownLatch(1);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx1.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        ((VertxImpl)this.vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 2"));
        ((VertxImpl)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 1"));
        ((VertxImpl)this.vertx1).haManager().simulateKill();
        this.vertx2.close().onComplete(ar -> this.vertx.setTimer(500L, tid -> {
            this.assertEquals("Verticle should still be deployed here 1", 1L, this.vertx1.deploymentIDs().size());
            this.assertTrue("Verticle should not failover here 2", this.vertx2.deploymentIDs().isEmpty());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNonHADeployments() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(2);
        this.vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx2.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), new DeploymentOptions().setHa(false)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx2.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxImpl)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch2.countDown();
        });
        ((VertxImpl)this.vertx2).haManager().simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx1.deploymentIDs().size() == 1);
        String depID = (String)this.vertx1.deploymentIDs().iterator().next();
        this.assertTrue(((VertxInternal)this.vertx1).deploymentManager().deployment(depID).deployment().identifier().equals("java:" + HAVerticle1.class.getName()));
    }

    @Test
    public void testCloseRemovesFromCluster() throws Exception {
        this.vertx1 = this.startVertx();
        this.vertx2 = this.startVertx();
        this.vertx3 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(1);
        this.vertx3.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> {
            this.assertTrue(this.vertx3.deploymentIDs().contains(id));
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.vertx2.close().onComplete(ar -> {
            ((VertxImpl)this.vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
                this.assertTrue(succeeded);
                latch2.countDown();
            });
            ((VertxImpl)this.vertx3).haManager().simulateKill();
        });
        this.awaitLatch(latch2);
        this.assertTrue(this.vertx1.deploymentIDs().size() == 1);
        String depID = (String)this.vertx1.deploymentIDs().iterator().next();
        this.assertTrue(((VertxInternal)this.vertx1).deploymentManager().deployment(depID).deployment().identifier().equals("java:" + HAVerticle1.class.getName()));
    }

    @Test
    public void testQuorumWithHaGroups() throws Exception {
        this.vertx1 = this.startVertx("group1", 2);
        this.vertx2 = this.startVertx("group2", 2);
        this.vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> this.assertTrue(this.vertx1.deploymentIDs().contains(id))));
        Thread.sleep(500L);
        this.assertTrue(this.vertx1.deploymentIDs().isEmpty());
        this.vertx3 = this.startVertx("group1", 2);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().size() == 1);
        this.vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true)).onComplete(this.onSuccess(id -> this.assertTrue(this.vertx2.deploymentIDs().contains(id))));
        Thread.sleep(500L);
        this.assertTrue(this.vertx2.deploymentIDs().isEmpty());
        this.vertx4 = this.startVertx("group2", 2);
        HATest.assertWaitUntil(() -> this.vertx2.deploymentIDs().size() == 1);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx4.close().onComplete(ar -> latch.countDown());
        this.awaitLatch(latch);
        HATest.assertWaitUntil(() -> this.vertx2.deploymentIDs().isEmpty());
        this.assertTrue(this.vertx1.deploymentIDs().size() == 1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.vertx3.close().onComplete(ar -> latch2.countDown());
        this.awaitLatch(latch2);
        HATest.assertWaitUntil(() -> this.vertx1.deploymentIDs().isEmpty());
    }

    protected Vertx startVertx() throws Exception {
        return this.startVertx(null, 1);
    }

    protected Vertx startVertx(int quorumSize) throws Exception {
        return this.startVertx(null, quorumSize);
    }

    protected Vertx startVertx(String haGroup, int quorumSize) throws Exception {
        return this.startVertx(haGroup, quorumSize, true);
    }

    protected Vertx startVertx(String haGroup, int quorumSize, boolean ha) throws Exception {
        VertxOptions options = new VertxOptions().setHAEnabled(ha);
        options.getEventBusOptions().setHost("localhost");
        if (ha) {
            options.setQuorumSize(quorumSize);
            if (haGroup != null) {
                options.setHAGroup(haGroup);
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference vertxRef = new AtomicReference();
        Vertx.builder().with(options).withClusterManager(this.getClusterManager()).buildClustered().onComplete(this.onSuccess(vertx -> {
            vertxRef.set(vertx);
            latch.countDown();
        }));
        latch.await(2L, TimeUnit.MINUTES);
        return (Vertx)vertxRef.get();
    }

    protected void checkDeploymentExists(int pos, String verticleName, DeploymentOptions options) {
        VertxImpl vi = (VertxImpl)this.vertices[pos];
        for (String deploymentID : vi.deploymentIDs()) {
            DeploymentContext dep = vi.deploymentManager().deployment(deploymentID);
            if (!verticleName.equals(dep.deployment().identifier()) || !options.toJson().equals((Object)dep.deployment().options().toJson())) continue;
            return;
        }
        this.fail("Can't find deployment for verticleName: " + verticleName + " on node " + pos);
    }

    protected void kill(int pos) {
        VertxImpl v = (VertxImpl)this.vertices[pos];
        v.executeBlocking(() -> {
            v.haManager().simulateKill();
            return null;
        }, false).onComplete(this.onSuccess(ar -> {}));
    }

    protected void closeVertices(Vertx ... vertices) throws Exception {
        CountDownLatch latch = new CountDownLatch(vertices.length);
        for (int i = 0; i < vertices.length; ++i) {
            if (vertices[i] != null) {
                vertices[i].close().onComplete(this.onSuccess(res -> latch.countDown()));
                continue;
            }
            latch.countDown();
        }
        this.awaitLatch(latch, 2L, TimeUnit.MINUTES);
    }
}

