/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import io.vertx.test.http.HttpTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Test;

public abstract class HttpClientResponseParserTest
extends HttpTestBase {
    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return super.createBaseServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM.get());
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return super.createBaseClientOptions().setSsl(true).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get());
    }

    @Test
    public void shouldParseHttpsStream() throws Exception {
        this.vertx.exceptionHandler(this::fail);
        char[] firstLine = new char[32768];
        Arrays.fill(firstLine, 'a');
        char[] secondLine = new char[65536];
        Arrays.fill(secondLine, 'b');
        this.server.requestHandler(req -> {
            HttpServerResponse response = req.response();
            response.setChunked(true);
            response.write(new String(firstLine), StandardCharsets.UTF_8.name());
            response.write("\n");
            response.end(new String(secondLine), StandardCharsets.UTF_8.name());
        });
        this.startServer();
        List lines = Collections.synchronizedList(new ArrayList());
        this.waitFor(3);
        this.client.request(this.requestOptions.setPort(Integer.valueOf(this.server.actualPort()))).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> {
            resp.exceptionHandler(this::fail);
            RecordParser.newDelimited((String)"\n", (ReadStream)resp).endHandler(v -> this.complete()).handler(buff -> {
                lines.add(buff.toString(StandardCharsets.UTF_8));
                this.complete();
            });
        }))));
        this.await();
        this.assertEquals(2L, lines.size());
        this.assertEquals(new String(firstLine), lines.get(0));
        this.assertEquals(new String(secondLine), lines.get(1));
    }
}

