/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.net.NetClientOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.http.HttpTestBase;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class HttpConnectionEarlyResetTest
extends VertxTestBase {
    private HttpServer httpServer;
    private AtomicReference<Throwable> caught = new AtomicReference();
    private CountDownLatch resetLatch = new CountDownLatch(1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        CountDownLatch listenLatch = new CountDownLatch(1);
        Context ctx = this.vertx.getOrCreateContext();
        this.httpServer = this.vertx.createHttpServer().requestHandler(request -> {}).exceptionHandler(t -> {
            this.assertSame(ctx, Vertx.currentContext());
            this.caught.set((Throwable)t);
            this.resetLatch.countDown();
        });
        ctx.runOnContext(v -> this.httpServer.listen(HttpTestBase.DEFAULT_HTTP_PORT).onComplete(this.onSuccess(server -> listenLatch.countDown())));
        this.awaitLatch(listenLatch);
    }

    @Test
    public void testExceptionCaught() throws Exception {
        this.vertx.createNetClient(new NetClientOptions().setSoLinger(0)).connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(socket -> this.vertx.setTimer(2000L, id -> socket.close())));
        this.awaitLatch(this.resetLatch);
        this.assertThat(this.caught.get(), CoreMatchers.instanceOf(IOException.class));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.httpServer != null) {
            CountDownLatch closeLatch = new CountDownLatch(1);
            this.httpServer.close().onComplete(event -> closeLatch.countDown());
            this.awaitLatch(closeLatch);
        }
        super.tearDown();
    }
}

