/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http;

import io.vertx.core.http.HttpMethod;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class HttpMethodTest {
    @Test
    public void testConstantNames() {
        Assert.assertEquals((Object)"GET", (Object)HttpMethod.GET.name());
        Assert.assertEquals((Object)"POST", (Object)HttpMethod.POST.name());
        Assert.assertEquals((Object)"PUT", (Object)HttpMethod.PUT.name());
        Assert.assertEquals((Object)"HEAD", (Object)HttpMethod.HEAD.name());
        Assert.assertEquals((Object)"CONNECT", (Object)HttpMethod.CONNECT.name());
        Assert.assertEquals((Object)"DELETE", (Object)HttpMethod.DELETE.name());
        Assert.assertEquals((Object)"OPTIONS", (Object)HttpMethod.OPTIONS.name());
        Assert.assertEquals((Object)"PATCH", (Object)HttpMethod.PATCH.name());
        Assert.assertEquals((Object)"TRACE", (Object)HttpMethod.TRACE.name());
        Assert.assertEquals((Object)"PROPFIND", (Object)HttpMethod.PROPFIND.name());
        Assert.assertEquals((Object)"PROPPATCH", (Object)HttpMethod.PROPPATCH.name());
        Assert.assertEquals((Object)"MKCOL", (Object)HttpMethod.MKCOL.name());
        Assert.assertEquals((Object)"COPY", (Object)HttpMethod.COPY.name());
        Assert.assertEquals((Object)"MOVE", (Object)HttpMethod.MOVE.name());
        Assert.assertEquals((Object)"LOCK", (Object)HttpMethod.LOCK.name());
        Assert.assertEquals((Object)"UNLOCK", (Object)HttpMethod.UNLOCK.name());
        Assert.assertEquals((Object)"MKCALENDAR", (Object)HttpMethod.MKCALENDAR.name());
        Assert.assertEquals((Object)"VERSION-CONTROL", (Object)HttpMethod.VERSION_CONTROL.name());
        Assert.assertEquals((Object)"REPORT", (Object)HttpMethod.REPORT.name());
        Assert.assertEquals((Object)"CHECKOUT", (Object)HttpMethod.CHECKOUT.name());
        Assert.assertEquals((Object)"CHECKIN", (Object)HttpMethod.CHECKIN.name());
        Assert.assertEquals((Object)"UNCHECKOUT", (Object)HttpMethod.UNCHECKOUT.name());
        Assert.assertEquals((Object)"MKWORKSPACE", (Object)HttpMethod.MKWORKSPACE.name());
        Assert.assertEquals((Object)"UPDATE", (Object)HttpMethod.UPDATE.name());
        Assert.assertEquals((Object)"LABEL", (Object)HttpMethod.LABEL.name());
        Assert.assertEquals((Object)"MERGE", (Object)HttpMethod.MERGE.name());
        Assert.assertEquals((Object)"BASELINE-CONTROL", (Object)HttpMethod.BASELINE_CONTROL.name());
        Assert.assertEquals((Object)"MKACTIVITY", (Object)HttpMethod.MKACTIVITY.name());
        Assert.assertEquals((Object)"ORDERPATCH", (Object)HttpMethod.ORDERPATCH.name());
        Assert.assertEquals((Object)"ACL", (Object)HttpMethod.ACL.name());
        Assert.assertEquals((Object)"SEARCH", (Object)HttpMethod.SEARCH.name());
    }

    @Test
    public void testConstants() {
        for (HttpMethod method : Arrays.asList(HttpMethod.GET, HttpMethod.POST, HttpMethod.HEAD, HttpMethod.PUT, HttpMethod.CONNECT, HttpMethod.DELETE, HttpMethod.OPTIONS, HttpMethod.PATCH, HttpMethod.TRACE, HttpMethod.PROPFIND, HttpMethod.PROPPATCH, HttpMethod.MKCOL, HttpMethod.COPY, HttpMethod.MOVE, HttpMethod.LOCK, HttpMethod.UNLOCK, HttpMethod.MKCALENDAR, HttpMethod.VERSION_CONTROL, HttpMethod.REPORT, HttpMethod.CHECKOUT, HttpMethod.CHECKIN, HttpMethod.UNCHECKOUT, HttpMethod.MKWORKSPACE, HttpMethod.UPDATE, HttpMethod.LABEL, HttpMethod.MERGE, HttpMethod.BASELINE_CONTROL, HttpMethod.MKACTIVITY, HttpMethod.ORDERPATCH, HttpMethod.ACL, HttpMethod.SEARCH)) {
            Assert.assertSame((Object)HttpMethod.valueOf((String)method.name()), (Object)method);
            Assert.assertSame((Object)method.name(), (Object)method.toString());
        }
    }

    @Test
    public void testInvalidValueOf() {
        for (String method : Arrays.asList("", " ")) {
            try {
                HttpMethod.valueOf((String)method);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        try {
            HttpMethod.valueOf(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testValueOf() {
        HttpMethod m1 = HttpMethod.valueOf((String)"foo");
        HttpMethod m2 = HttpMethod.valueOf((String)"foo");
        Assert.assertEquals((Object)"foo", (Object)m1.name());
        Assert.assertEquals((Object)"foo", (Object)m1.toString());
        Assert.assertNotSame((Object)m1, (Object)m2);
        Assert.assertEquals((long)m1.hashCode(), (long)m2.hashCode());
        Assert.assertEquals((Object)m1, (Object)m2);
    }

    @Test
    public void testCaseSensitive() {
        HttpMethod m1 = HttpMethod.valueOf((String)"Foo");
        HttpMethod m2 = HttpMethod.valueOf((String)"foo");
        Assert.assertEquals((Object)"Foo", (Object)m1.name());
        Assert.assertEquals((Object)"Foo", (Object)m1.toString());
        Assert.assertNotSame((Object)m1, (Object)m2);
        Assert.assertNotEquals((long)m1.hashCode(), (long)m2.hashCode());
        Assert.assertNotEquals((Object)m1, (Object)m2);
    }

    @Test
    public void testNettyInterop() {
        Assert.assertSame((Object)HttpMethod.GET.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.GET);
        Assert.assertSame((Object)HttpMethod.POST.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.POST);
        Assert.assertSame((Object)HttpMethod.PUT.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.PUT);
        Assert.assertSame((Object)HttpMethod.HEAD.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.HEAD);
        Assert.assertSame((Object)HttpMethod.CONNECT.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.CONNECT);
        Assert.assertSame((Object)HttpMethod.DELETE.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.DELETE);
        Assert.assertSame((Object)HttpMethod.OPTIONS.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.OPTIONS);
        Assert.assertSame((Object)HttpMethod.PATCH.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.PATCH);
        Assert.assertSame((Object)HttpMethod.TRACE.toNetty(), (Object)io.netty.handler.codec.http.HttpMethod.TRACE);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.GET), (Object)HttpMethod.GET);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.valueOf((String)"GET")), (Object)HttpMethod.GET);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.POST), (Object)HttpMethod.POST);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.valueOf((String)"POST")), (Object)HttpMethod.POST);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.PUT), (Object)HttpMethod.PUT);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.valueOf((String)"PUT")), (Object)HttpMethod.PUT);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.HEAD), (Object)HttpMethod.HEAD);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.CONNECT), (Object)HttpMethod.CONNECT);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.DELETE), (Object)HttpMethod.DELETE);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.OPTIONS), (Object)HttpMethod.OPTIONS);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.PATCH), (Object)HttpMethod.PATCH);
        Assert.assertSame((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.TRACE), (Object)HttpMethod.TRACE);
        Assert.assertEquals((Object)HttpMethod.valueOf((String)"foo").toNetty().name(), (Object)"foo");
        Assert.assertEquals((Object)HttpMethod.fromNetty((io.netty.handler.codec.http.HttpMethod)io.netty.handler.codec.http.HttpMethod.valueOf((String)"foo")).name(), (Object)"foo");
    }

    @Test
    public void testValues() {
        List list = HttpMethod.values();
        TestCase.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
        list.forEach(Assert::assertNotNull);
    }
}

