/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Expectation;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.http.HttpResponseHead;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.test.core.TestUtils;
import io.vertx.test.http.HttpTestBase;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

public class HttpResponseExpectationTest
extends HttpTestBase {
    @Test
    public void testExpectFail() throws Exception {
        this.testExpectation(true, (Expectation<HttpResponseHead>)((Expectation)resp -> false), HttpServerResponse::end);
    }

    @Test
    public void testExpectPass() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)((Expectation)resp -> true), HttpServerResponse::end);
    }

    @Test
    public void testExpectStatusFail() throws Exception {
        this.testExpectation(true, (Expectation<HttpResponseHead>)HttpResponseExpectation.status((int)200), resp -> resp.setStatusCode(201).end());
    }

    @Test
    public void testExpectStatusPass() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)HttpResponseExpectation.status((int)200), resp -> resp.setStatusCode(200).end());
    }

    @Test
    public void testExpectStatusRangeFail() throws Exception {
        this.testExpectation(true, (Expectation<HttpResponseHead>)HttpResponseExpectation.SC_SUCCESS, resp -> resp.setStatusCode(500).end());
    }

    @Test
    public void testExpectStatusRangePass1() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)HttpResponseExpectation.SC_SUCCESS, resp -> resp.setStatusCode(200).end());
    }

    @Test
    public void testExpectStatusRangePass2() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)HttpResponseExpectation.SC_SUCCESS, resp -> resp.setStatusCode(299).end());
    }

    @Test
    public void testExpectContentTypeFail() throws Exception {
        this.testExpectation(true, (Expectation<HttpResponseHead>)HttpResponseExpectation.JSON, HttpServerResponse::end);
    }

    @Test
    public void testExpectOneOfContentTypesFail() throws Exception {
        this.testExpectation(true, (Expectation<HttpResponseHead>)HttpResponseExpectation.contentType(Arrays.asList("text/plain", "text/csv")), httpServerResponse -> httpServerResponse.putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.TEXT_HTML).end());
    }

    @Test
    public void testExpectContentTypePass() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)HttpResponseExpectation.JSON, resp -> resp.putHeader("content-type", "application/JSON").end());
    }

    @Test
    public void testExpectContentTypeWithEncodingPass() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)HttpResponseExpectation.JSON, resp -> resp.putHeader("content-type", "application/JSON;charset=UTF-8").end());
    }

    @Test
    public void testExpectOneOfContentTypesPass() throws Exception {
        this.testExpectation(false, (Expectation<HttpResponseHead>)HttpResponseExpectation.contentType(Arrays.asList("text/plain", "text/HTML")), httpServerResponse -> httpServerResponse.putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.TEXT_HTML).end());
    }

    @Test
    public void testExpectCustomException() throws Exception {
        Expectation predicate = ((Expectation)value -> false).wrappingFailure((r, e) -> new CustomException("boom"));
        this.testExpectation(true, (Expectation<HttpResponseHead>)predicate, HttpServerResponse::end, ar -> {
            Throwable cause = ar.cause();
            this.assertThat(cause, CoreMatchers.instanceOf(CustomException.class));
            CustomException customException = (CustomException)cause;
            this.assertEquals("boom", customException.getMessage());
        });
    }

    @Test
    public void testExpectCustomExceptionWithStatusCode() throws Exception {
        UUID uuid = UUID.randomUUID();
        int statusCode = 400;
        Expectation predicate = HttpResponseExpectation.SC_SUCCESS.wrappingFailure((value, err) -> new CustomException(uuid, String.valueOf(value.statusCode())));
        this.testExpectation(true, (Expectation<HttpResponseHead>)predicate, httpServerResponse -> httpServerResponse.setStatusCode(statusCode).end(TestUtils.randomBuffer(2048)), ar -> {
            Throwable cause = ar.cause();
            this.assertThat(cause, CoreMatchers.instanceOf(CustomException.class));
            CustomException customException = (CustomException)cause;
            this.assertEquals(String.valueOf(statusCode), customException.getMessage());
            this.assertEquals(uuid, customException.tag);
        });
    }

    @Test
    public void testExpectFunctionThrowsException() throws Exception {
        Expectation predicate = ((Expectation)value -> false).wrappingFailure((v, e) -> {
            throw new IndexOutOfBoundsException("boom");
        });
        this.testExpectation(true, (Expectation<HttpResponseHead>)predicate, HttpServerResponse::end, ar -> this.assertThat(ar.cause(), CoreMatchers.instanceOf(IndexOutOfBoundsException.class)));
    }

    @Test
    public void testErrorConverterReturnsNull() throws Exception {
        Expectation predicate = ((Expectation)value -> false).wrappingFailure((v, e) -> null);
        this.testExpectation(true, (Expectation<HttpResponseHead>)predicate, HttpServerResponse::end, ar -> this.assertThat(ar.cause(), CoreMatchers.not((Matcher)CoreMatchers.instanceOf(NullPointerException.class))));
    }

    private void testExpectation(boolean shouldFail, Expectation<HttpResponseHead> expectation, Consumer<HttpServerResponse> server) throws Exception {
        this.testExpectation(shouldFail, expectation, server, null);
    }

    private void testExpectation(boolean shouldFail, Expectation<HttpResponseHead> expectation, Consumer<HttpServerResponse> server, Consumer<AsyncResult<?>> resultTest) throws Exception {
        this.server.requestHandler(request -> server.accept(request.response()));
        this.startServer();
        this.client.request(HttpMethod.GET, DEFAULT_HTTP_PORT, "localhost", "/test").compose(request -> request.send().expecting(expectation)).onComplete(ar -> {
            if (ar.succeeded()) {
                this.assertFalse("Expected response success", shouldFail);
            } else {
                this.assertTrue("Expected response failure", shouldFail);
            }
            if (resultTest != null) {
                resultTest.accept((AsyncResult<?>)ar);
            }
            this.testComplete();
        });
        this.await();
    }

    private static class CustomException
    extends Exception {
        UUID tag;

        CustomException(String message) {
            super(message);
        }

        CustomException(UUID tag, String message) {
            super(message);
            this.tag = tag;
        }
    }
}

