/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http;

import io.vertx.core.Completable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.test.core.VertxTestBase;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assume;
import org.junit.Test;

public class VirtualThreadHttpTest
extends VertxTestBase {
    private VertxInternal vertx;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = (VertxInternal)((VertxTestBase)this).vertx;
    }

    @Test
    public void testHttpClient1() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> req.response().end("Hello World"));
        server.listen(8088, "localhost").await(10L, TimeUnit.SECONDS);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            HttpClientAgent client = this.vertx.createHttpClient();
            for (int i = 0; i < 100; ++i) {
                HttpClientRequest req = (HttpClientRequest)client.request(HttpMethod.GET, 8088, "localhost", "/").await();
                HttpClientResponse resp = (HttpClientResponse)req.send().await();
                Buffer body = (Buffer)resp.body().await();
                String bodyString = body.toString(StandardCharsets.UTF_8);
                this.assertEquals("Hello World", bodyString);
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHttpClient2() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        this.waitFor(100);
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> req.response().end("Hello World"));
        server.listen(8088, "localhost").await(10L, TimeUnit.SECONDS);
        HttpClientAgent client = this.vertx.createHttpClient();
        this.vertx.createVirtualThreadContext().runOnContext(arg_0 -> this.lambda$testHttpClient2$6((HttpClient)client, arg_0));
        try {
            this.await();
        }
        finally {
            server.close().await();
            client.close().await();
        }
    }

    @Test
    public void testHttpClient3() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        HttpServer server = this.vertx.createHttpServer();
        int numChunks = 10;
        List expected = IntStream.range(0, numChunks).mapToObj(idx -> "chunk-" + idx).collect(Collectors.toList());
        server.requestHandler(req -> {
            HttpServerResponse response = req.response();
            response.setChunked(true);
            ArrayDeque toSend = new ArrayDeque(expected);
            this.vertx.setPeriodic(10L, id -> {
                String chunk = (String)toSend.poll();
                if (chunk != null) {
                    response.write(chunk);
                } else {
                    this.vertx.cancelTimer(id.longValue());
                    response.end();
                }
            });
        });
        server.listen(8088, "localhost").await(10L, TimeUnit.SECONDS);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            HttpClientAgent client = this.vertx.createHttpClient();
            for (int i = 0; i < 10; ++i) {
                HttpClientRequest req = (HttpClientRequest)client.request(HttpMethod.GET, 8088, "localhost", "/").await();
                HttpClientResponse resp = (HttpClientResponse)req.send().await();
                ArrayList chunks = new ArrayList();
                resp.blockingStream().forEach(chunk -> chunks.add(chunk.toString()));
                this.assertEquals(expected, chunks);
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHttpClientTimeout() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> {});
        server.listen(8088, "localhost").await(10L, TimeUnit.SECONDS);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            HttpClientAgent client = this.vertx.createHttpClient();
            ContextInternal ctx = this.vertx.getOrCreateContext();
            HttpClientRequest req = (HttpClientRequest)client.request(HttpMethod.GET, 8088, "localhost", "/").await();
            PromiseInternal promise = ctx.promise();
            req.send().onComplete((Completable)promise);
            Exception failure = new Exception("Too late");
            this.vertx.setTimer(500L, id -> promise.tryFail((Throwable)failure));
            try {
                HttpClientResponse httpClientResponse = (HttpClientResponse)promise.future().await();
            }
            catch (Exception e) {
                this.assertSame(failure, e);
                this.testComplete();
            }
        });
        this.await();
    }

    private /* synthetic */ void lambda$testHttpClient2$6(HttpClient client, Void v) {
        for (int i = 0; i < 100; ++i) {
            client.request(HttpMethod.GET, 8088, "localhost", "/").onSuccess(req -> {
                HttpClientResponse resp = (HttpClientResponse)req.send().await();
                StringBuffer body = new StringBuffer();
                resp.handler(buff -> body.append(buff.toString()));
                resp.endHandler(v2 -> {
                    this.assertEquals("Hello World", body.toString());
                    this.complete();
                });
            });
        }
    }
}

