/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.WebSocketVersion;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.http.WebSocketInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.CheckingSender;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.http.HttpTestBase;
import io.vertx.test.proxy.HAProxy;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Ignore;
import org.junit.Test;

public class WebSocketTest
extends VertxTestBase {
    private static final String TEST_REASON = "I'm moving away!";
    private static final short TEST_STATUS_CODE = 1001;
    private static final short INVALID_STATUS_CODE = 1004;
    private WebSocketClient client;
    private HttpServer server;
    private NetServer netServer;
    BiConsumer<HttpClient, Handler<AsyncResult<HttpClientResponse>>> INVALID_MISSING_CONNECTION_HEADER = (client, handler) -> client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/some/path")).onComplete(this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").send().onComplete(handler)));
    BiConsumer<HttpClient, Handler<AsyncResult<HttpClientResponse>>> INVALID_HTTP_METHOD = (client, handler) -> client.request(new RequestOptions().setMethod(HttpMethod.HEAD).setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/some/path")).onComplete(this.onSuccess(req -> {
        req.putHeader("Upgrade", "Websocket").putHeader("Connection", "Upgrade");
        req.send().onComplete(handler);
    }));
    BiConsumer<HttpClient, Handler<AsyncResult<HttpClientResponse>>> INVALID_URI = (client, handler) -> client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(":")).onComplete(this.onSuccess(req -> {
        req.putHeader("Upgrade", "Websocket").putHeader("Connection", "Upgrade");
        req.send().onComplete(handler);
    }));
    BiConsumer<HttpClient, Handler<AsyncResult<HttpClientResponse>>> INVALID_WEBSOCKET_VERSION = (client, handler) -> client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/some/path")).onComplete(this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").putHeader("Sec-Websocket-Version", "15").putHeader("Connection", "Upgrade").send().onComplete(handler)));
    BiConsumer<HttpClient, Handler<AsyncResult<HttpClientResponse>>> HANDSHAKE_EXCEPTION = (client, handler) -> client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/some/path")).onComplete(this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").putHeader("Sec-Websocket-Version", "13").putHeader("Connection", "Upgrade").send().onComplete(handler)));
    final BlockingQueue<Throwable> resultQueue = new ArrayBlockingQueue<Throwable>(10);

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.awaitFuture(this.server.close());
        }
        if (this.netServer != null) {
            this.awaitFuture(this.netServer.close());
        }
        super.tearDown();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host2.com"));
        return options;
    }

    @Test
    public void testRejectHybi00() throws Exception {
        this.testReject(WebSocketVersion.V00, null, 502, "Bad Gateway");
    }

    @Test
    public void testRejectHybi08() throws Exception {
        this.testReject(WebSocketVersion.V08, null, 502, "Bad Gateway");
    }

    @Test
    public void testRejectWithStatusCode() throws Exception {
        this.testReject(WebSocketVersion.V08, 404, 404, "Not Found");
    }

    @Test
    public void testWSBinaryHybi00() throws Exception {
        this.testWSFrames(true, WebSocketVersion.V00);
    }

    @Test
    public void testWSStringHybi00() throws Exception {
        this.testWSFrames(false, WebSocketVersion.V00);
    }

    @Test
    public void testWSBinaryHybi08() throws Exception {
        this.testWSFrames(true, WebSocketVersion.V08);
    }

    @Test
    public void testWSStringHybi08() throws Exception {
        this.testWSFrames(false, WebSocketVersion.V08);
    }

    @Test
    public void testWSBinaryHybi17() throws Exception {
        this.testWSFrames(true, WebSocketVersion.V13);
    }

    @Test
    public void testWSStringHybi17() throws Exception {
        this.testWSFrames(false, WebSocketVersion.V13);
    }

    @Test
    public void testWSStreamsHybi00() throws Exception {
        this.testWSWriteStream(WebSocketVersion.V00);
    }

    @Test
    public void testWSStreamsHybi08() throws Exception {
        this.testWSWriteStream(WebSocketVersion.V08);
    }

    @Test
    public void testWSStreamsHybi17() throws Exception {
        this.testWSWriteStream(WebSocketVersion.V13);
    }

    @Test
    public void testWriteFromConnectHybi00() throws Exception {
        this.testWriteFromConnectHandler(WebSocketVersion.V00);
    }

    @Test
    public void testWriteFromConnectHybi08() throws Exception {
        this.testWriteFromConnectHandler(WebSocketVersion.V08);
    }

    @Test
    public void testWriteFromConnectHybi17() throws Exception {
        this.testWriteFromConnectHandler(WebSocketVersion.V13);
    }

    @Test
    public void testContinuationWriteFromConnectHybi08() throws Exception {
        this.testContinuationWriteFromConnectHandler(WebSocketVersion.V08);
    }

    @Test
    public void testContinuationWriteFromConnectHybi17() throws Exception {
        this.testContinuationWriteFromConnectHandler(WebSocketVersion.V13);
    }

    @Test
    public void testValidSubProtocolHybi00() throws Exception {
        this.testValidSubProtocol(WebSocketVersion.V00);
    }

    @Test
    public void testValidSubProtocolHybi08() throws Exception {
        this.testValidSubProtocol(WebSocketVersion.V08);
    }

    @Test
    public void testValidSubProtocolHybi17() throws Exception {
        this.testValidSubProtocol(WebSocketVersion.V13);
    }

    @Test
    public void testInvalidSubProtocolHybi00() throws Exception {
        this.testInvalidSubProtocol(WebSocketVersion.V00);
    }

    @Test
    public void testInvalidSubProtocolHybi08() throws Exception {
        this.testInvalidSubProtocol(WebSocketVersion.V08);
    }

    @Test
    public void testInvalidSubProtocolHybi17() throws Exception {
        this.testInvalidSubProtocol(WebSocketVersion.V13);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertWithSNI() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE, false, false, false, false, true, true, true, true, new String[0], (WebSocketClient client) -> client.connect(HttpTestBase.DEFAULT_HTTPS_PORT, "host2.com", "/"));
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PKCS12, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PEM, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM_CA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPKCS12ServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPEMServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPKCS12() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PKCS12, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPEM() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPKCS12Required() throws Exception {
        this.testTLS(Cert.CLIENT_PKCS12, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEMRequired() throws Exception {
        this.testTLS(Cert.CLIENT_PEM, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEM_CARequired() throws Exception {
        this.testTLS(Cert.CLIENT_PEM_ROOT_CA, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM_ROOT_CA, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientRevokedServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE, false, false, false, true, false, new String[0]);
    }

    @Test
    public void testTLSRevokedClientCertServer() throws Exception {
        this.testTLS(Cert.CLIENT_PEM_ROOT_CA, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM_ROOT_CA, true, true, false, false, false, new String[0]);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, ENABLED_CIPHER_SUITES);
    }

    @Test
    public void testClearClientRequestOptionsSetSSL() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(true));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, false, true, false, new String[0], (WebSocketClient client) -> client.connect(options));
    }

    @Test
    public void testSSLClientRequestOptionsSetSSL() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(true));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, true, true, false, new String[0], (WebSocketClient client) -> client.connect(options));
    }

    @Test
    public void testClearClientRequestOptionsSetClear() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(false));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, false, false, false, new String[0], (WebSocketClient client) -> client.connect(options));
    }

    @Test
    public void testSSLClientRequestOptionsSetClear() throws Exception {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setURI("/").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(false));
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE, false, false, true, false, true, true, false, false, new String[0], (WebSocketClient client) -> client.connect(options));
    }

    private void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean serverUsesCrl, boolean clientTrustAll, boolean clientUsesCrl, boolean shouldPass, String ... enabledCipherSuites) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, serverUsesCrl, clientTrustAll, clientUsesCrl, shouldPass, true, true, false, enabledCipherSuites, (WebSocketClient client) -> client.connect(HttpTestBase.DEFAULT_HTTPS_PORT, "localhost", "/"));
    }

    private void testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust, boolean requireClientAuth, boolean serverUsesCrl, boolean clientTrustAll, boolean clientUsesCrl, boolean shouldPass, boolean clientSsl, boolean serverSsl, boolean sni, String[] enabledCipherSuites, Function<WebSocketClient, Future<WebSocket>> wsProvider) throws Exception {
        WebSocketClientOptions options = new WebSocketClientOptions();
        options.setSsl(clientSsl);
        options.setTrustAll(clientTrustAll);
        if (clientUsesCrl) {
            options.addCrlPath("tls/root-ca/crl.pem");
        }
        options.setTrustOptions((TrustOptions)clientTrust.get());
        options.setKeyCertOptions((KeyCertOptions)clientCert.get());
        for (String suite : enabledCipherSuites) {
            options.addEnabledCipherSuite(suite);
        }
        this.client = this.vertx.createWebSocketClient(options);
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setSsl(serverSsl);
        serverOptions.setSni(sni);
        serverOptions.setTrustOptions((TrustOptions)serverTrust.get());
        serverOptions.setKeyCertOptions((KeyCertOptions)serverCert.get());
        if (requireClientAuth) {
            serverOptions.setClientAuth(ClientAuth.REQUIRED);
        }
        if (serverUsesCrl) {
            serverOptions.addCrlPath("tls/root-ca/crl.pem");
        }
        for (String suite : enabledCipherSuites) {
            serverOptions.addEnabledCipherSuite(suite);
        }
        this.server = this.vertx.createHttpServer(serverOptions.setPort(HttpTestBase.DEFAULT_HTTPS_PORT));
        this.server.webSocketHandler(ws -> ws.handler(arg_0 -> ((ServerWebSocket)ws).write(arg_0)));
        this.awaitFuture(this.server.listen());
        Handler handler = ar2 -> {
            if (ar2.succeeded()) {
                WebSocket ws = (WebSocket)ar2.result();
                if (clientSsl && sni) {
                    try {
                        Certificate clientPeerCert = (Certificate)ws.peerCertificates().get(0);
                        this.assertEquals("host2.com", TestUtils.cnOf(clientPeerCert));
                    }
                    catch (Exception err) {
                        this.fail(err);
                    }
                }
                int size = 100;
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == size) {
                        ws.close();
                        this.testComplete();
                    }
                });
                Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(size));
                ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
            } else if (shouldPass) {
                ar2.cause().printStackTrace();
                this.fail("Should not throw exception");
            } else {
                this.testComplete();
            }
        };
        wsProvider.apply(this.client).onComplete(handler);
        this.await();
    }

    @Test
    public void testOverrideClientSSLOptions() throws Exception {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()));
        this.awaitFuture(this.server.webSocketHandler(ws -> {}).listen(HttpTestBase.DEFAULT_HTTPS_PORT, "localhost"));
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setVerifyHost(false).setSsl(true).setTrustOptions((TrustOptions)Trust.CLIENT_JKS.get()));
        WebSocketConnectOptions connectOptions = new WebSocketConnectOptions().setHost("localhost").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT));
        this.client.connect(connectOptions).onComplete(this.onFailure(err -> this.client.connect(new WebSocketConnectOptions(connectOptions).setSslOptions(new ClientSSLOptions().setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()))).onComplete(this.onSuccess(so -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testHandleWSManually() throws Exception {
        this.testHandleWSManually(false, false);
    }

    @Test
    public void testHandleWSManuallyDeclineExtension() throws Exception {
        this.testHandleWSManually(true, false);
    }

    @Test
    public void testHandleWSManuallyDeclineSubprotocol() throws Exception {
        this.testHandleWSManually(false, true);
    }

    private void testHandleWSManually(boolean declineExtension, boolean declineSubprotocol) throws Exception {
        String path = "/some/path";
        String message = "here is some text data";
        String extension = "permessage-deflate";
        String subProtocol = "myprotocol";
        HttpServerOptions serverOptions = new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setPerMessageWebSocketCompressionSupported(true).setPerFrameWebSocketCompressionSupported(true).addWebSocketSubProtocol(subProtocol);
        this.server = this.vertx.createHttpServer(serverOptions).requestHandler(req -> {
            HashMap<String, String> extraResponseHeaders = new HashMap<String, String>();
            if (!declineExtension) {
                this.assertEquals(extension, req.headers().get("sec-websocket-extensions"));
                extraResponseHeaders.put("sec-websocket-extensions", extension);
            }
            if (!declineSubprotocol) {
                extraResponseHeaders.put("sec-websocket-protocol", subProtocol);
            }
            this.getUpgradedNetSocket((HttpServerRequest)req, path, (Map<String, String>)extraResponseHeaders).onComplete(this.onSuccess(sock -> {
                Buffer buff = Buffer.buffer();
                buff.appendByte((byte)-127);
                buff.appendByte((byte)message.length());
                buff.appendString(message);
                sock.write((Object)buff);
            }));
        });
        this.awaitFuture(this.server.listen());
        WebSocketClientOptions clientOptions = new WebSocketClientOptions().setTryUsePerMessageCompression(true).setTryUsePerFrameCompression(false);
        this.client = this.vertx.createWebSocketClient(clientOptions);
        this.vertx.runOnContext(v -> {
            WebSocketConnectOptions connectOptions = new WebSocketConnectOptions().setHost("localhost").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setURI(path).addSubProtocol(subProtocol);
            Object handler = declineSubprotocol ? this.onFailure(err -> this.testComplete()) : this.onSuccess(ws -> {
                MultiMap headers = ws.headers();
                if (declineExtension) {
                    this.assertFalse(headers.contains("sec-websocket-extensions"));
                } else {
                    this.assertTrue(headers.contains("sec-websocket-extensions", extension, true));
                }
                this.assertTrue(headers.contains("sec-websocket-protocol", subProtocol, true));
                ws.handler(buff -> {
                    this.assertEquals(message, buff.toString("UTF-8"));
                    this.testComplete();
                });
            });
            this.client.connect(connectOptions).onComplete(handler);
        });
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        int numServers = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE / 2 - 1;
        int numConnections = numServers * 100;
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        ConcurrentHashMap.KeySetView connectedServers = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap connectCount = new ConcurrentHashMap();
        CountDownLatch latchConns = new CountDownLatch(numConnections);
        for (int i = 0; i < numServers; ++i) {
            HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
            servers.add(theServer);
            theServer.webSocketHandler(ws -> {
                connectedServers.add(theServer);
                Integer cnt = (Integer)connectCount.get(theServer);
                int icnt = cnt == null ? 0 : cnt;
                connectCount.put(theServer, ++icnt);
                latchConns.countDown();
            });
            this.awaitFuture(theServer.listen());
        }
        this.client = this.vertx.createWebSocketClient();
        CountDownLatch latchClient = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
                ws.closeHandler(v -> latchClient.countDown());
                ws.close();
            }));
        }
        this.assertTrue(latchClient.await(10L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(10L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (HttpServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, connectCount.size());
        Iterator<Object> iterator = connectCount.values().iterator();
        while (iterator.hasNext()) {
            int cnt = (Integer)iterator.next();
            this.assertEquals(numConnections / numServers, cnt);
        }
        for (HttpServer server : servers) {
            this.awaitFuture(server.close());
        }
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(4321));
        theServer.webSocketHandler(ws -> this.fail("Should not connect"));
        this.awaitFuture(theServer.listen());
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(4321));
        theServer.webSocketHandler(ws -> this.fail("Should not connect"));
        this.awaitFuture(theServer.listen());
        this.awaitFuture(theServer.close());
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testWebSocketFrameFactoryArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> WebSocketFrame.binaryFrame(null, (boolean)true));
        TestUtils.assertNullPointerException(() -> WebSocketFrame.textFrame(null, (boolean)true));
        TestUtils.assertNullPointerException(() -> WebSocketFrame.continuationFrame(null, (boolean)true));
    }

    private String sha1(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] bytes = md.digest(s.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new InternalError("Failed to compute sha-1");
        }
    }

    private Future<NetSocket> getUpgradedNetSocket(HttpServerRequest req, String path, Map<String, String> extraResponseHeaders) {
        this.assertEquals(path, req.path());
        this.assertEquals("upgrade", req.headers().get("Connection"));
        String secHeader = req.headers().get("Sec-WebSocket-Key");
        String tmp = secHeader + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        String encoded = this.sha1(tmp);
        HttpServerResponse resp = req.response();
        MultiMap headers = resp.headers();
        headers.set(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE);
        headers.set("upgrade", "WebSocket");
        headers.set("connection", "upgrade");
        headers.set("sec-websocket-accept", encoded);
        if (extraResponseHeaders != null) {
            headers.addAll(extraResponseHeaders);
        }
        return req.toNetSocket();
    }

    private void testWSWriteStream(WebSocketVersion version) throws Exception {
        String scheme = "http";
        String path = "/some/path";
        String query = "handshake=bar&wibble=eek";
        String uri = path + "?" + query;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertEquals("localhost", ws.authority().host());
            this.assertEquals(HttpTestBase.DEFAULT_HTTP_PORT, ws.authority().port());
            this.assertEquals(scheme, ws.scheme());
            this.assertEquals(uri, ws.uri());
            this.assertEquals(path, ws.path());
            this.assertEquals(query, ws.query());
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            ws.handler(data -> ws.write(data));
        });
        this.awaitFuture(this.server.listen());
        int bsize = 100;
        int sends = 10;
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path + "?" + query).setVersion(version);
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(options).onComplete(this.onSuccess(ws -> {
            Buffer received = Buffer.buffer();
            ws.handler(data -> {
                received.appendBuffer(data);
                if (received.length() == bsize * sends) {
                    ws.close();
                    this.testComplete();
                }
            });
            Buffer sent = Buffer.buffer();
            for (int i = 0; i < sends; ++i) {
                Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(bsize));
                ws.write((Object)buff);
                sent.appendBuffer(buff);
            }
        }));
        this.await();
    }

    private void testWSFrames(boolean binary, WebSocketVersion version) throws Exception {
        String scheme = "http";
        String path = "/some/path";
        String query = "handshake=bar&wibble=eek";
        String uri = path + "?" + query;
        int frames = version == WebSocketVersion.V00 ? 1 : 10;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertEquals("localhost", ws.authority().host());
            this.assertEquals(HttpTestBase.DEFAULT_HTTP_PORT, ws.authority().port());
            this.assertEquals(scheme, ws.scheme());
            this.assertEquals(uri, ws.uri());
            this.assertEquals(path, ws.path());
            this.assertEquals(query, ws.query());
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            AtomicInteger count = new AtomicInteger();
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    this.testComplete();
                } else {
                    if (count.get() == 0) {
                        if (binary) {
                            this.assertTrue(frame.isBinary());
                            this.assertFalse(frame.isText());
                        } else {
                            this.assertFalse(frame.isBinary());
                            this.assertTrue(frame.isText());
                        }
                        this.assertFalse(frame.isContinuation());
                    } else {
                        this.assertFalse(frame.isBinary());
                        this.assertFalse(frame.isText());
                        this.assertTrue(frame.isContinuation());
                    }
                    if (count.get() == frames - 1) {
                        this.assertTrue(frame.isFinal());
                    } else {
                        this.assertFalse(frame.isFinal());
                    }
                    ws.writeFrame(frame);
                    if (count.incrementAndGet() == frames) {
                        count.set(0);
                    }
                }
            });
        });
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path + "?" + query).setVersion(version);
        this.client = this.vertx.createWebSocketClient();
        int bsize = 100;
        int msgs = 10;
        Future webSocketFuture = this.client.connect(options);
        webSocketFuture.onComplete(this.onSuccess(ws -> {
            ArrayList<Buffer> sent = new ArrayList<Buffer>();
            ArrayList received = new ArrayList();
            MultiMap headers = ws.headers();
            String webSocketLocation = headers.get("sec-websocket-location");
            if (version == WebSocketVersion.V00) {
                this.assertEquals("ws://" + HttpTestBase.DEFAULT_HTTP_HOST_AND_PORT + uri, webSocketLocation);
            } else {
                this.assertNull(webSocketLocation);
            }
            AtomicReference<Buffer> currentReceived = new AtomicReference<Buffer>(Buffer.buffer());
            ws.frameHandler(frame -> {
                ((Buffer)currentReceived.get()).appendBuffer(frame.binaryData());
                if (frame.isFinal()) {
                    received.add((Buffer)currentReceived.get());
                    currentReceived.set(Buffer.buffer());
                }
                if (received.size() == msgs) {
                    int pos = 0;
                    for (Buffer rec : received) {
                        this.assertEquals(rec, sent.get(pos++));
                    }
                    ws.close();
                }
            });
            AtomicReference<Buffer> currentSent = new AtomicReference<Buffer>(Buffer.buffer());
            for (int i = 0; i < msgs; ++i) {
                for (int j = 0; j < frames; ++j) {
                    WebSocketFrame frame2;
                    Buffer buff;
                    if (binary) {
                        buff = Buffer.buffer((byte[])TestUtils.randomByteArray(bsize));
                        frame2 = j == 0 ? WebSocketFrame.binaryFrame((Buffer)buff, (boolean)false) : WebSocketFrame.continuationFrame((Buffer)buff, (j == frames - 1 ? 1 : 0) != 0);
                    } else {
                        String str = TestUtils.randomAlphaString(bsize);
                        buff = Buffer.buffer((String)str);
                        frame2 = j == 0 ? WebSocketFrame.textFrame((String)str, (boolean)false) : WebSocketFrame.continuationFrame((Buffer)buff, (j == frames - 1 ? 1 : 0) != 0);
                    }
                    currentSent.get().appendBuffer(buff);
                    ws.writeFrame(frame2);
                    if (j != frames - 1) continue;
                    sent.add(currentSent.get());
                    currentSent.set(Buffer.buffer());
                }
            }
        }));
        this.await();
    }

    @Test
    public void testWriteFinalTextFrame() throws Exception {
        this.testWriteFinalFrame(false);
    }

    @Test
    public void testWriteFinalBinaryFrame() throws Exception {
        this.testWriteFinalFrame(true);
    }

    private void testWriteFinalFrame(boolean binary) throws Exception {
        this.waitFor(2);
        String text = TestUtils.randomUnicodeString(100);
        Buffer data = TestUtils.randomBuffer(100);
        Consumer<WebSocketFrame> frameConsumer = frame -> {
            if (binary) {
                this.assertTrue(frame.isBinary());
                this.assertFalse(frame.isText());
                this.assertEquals(data, frame.binaryData());
            } else {
                this.assertFalse(frame.isBinary());
                this.assertTrue(frame.isText());
                this.assertEquals(text, frame.textData());
            }
            this.assertTrue(frame.isFinal());
        };
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> ws.frameHandler(frame -> {
            if (frame.isClose()) {
                this.complete();
            } else {
                frameConsumer.accept((WebSocketFrame)frame);
                if (binary) {
                    ws.writeFinalBinaryFrame(frame.binaryData());
                } else {
                    ws.writeFinalTextFrame(frame.textData());
                }
            }
        }));
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    this.complete();
                } else {
                    frameConsumer.accept((WebSocketFrame)frame);
                    ws.close();
                }
            });
            if (binary) {
                ws.writeFinalBinaryFrame(data);
            } else {
                ws.writeFinalTextFrame(text);
            }
        }));
        this.await();
    }

    private void testContinuationWriteFromConnectHandler(WebSocketVersion version) throws Exception {
        String path = "/some/path";
        String firstFrame = "AAA";
        String continuationFrame = "BBB";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).requestHandler(req -> this.getUpgradedNetSocket((HttpServerRequest)req, path, null).onComplete(this.onSuccess(sock -> {
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)1);
            buff.appendByte((byte)firstFrame.length());
            buff.appendString(firstFrame);
            sock.write((Object)buff);
            buff = Buffer.buffer();
            buff.appendByte((byte)-128);
            buff.appendByte((byte)continuationFrame.length());
            buff.appendString(continuationFrame);
            sock.write((Object)buff);
        })));
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path).setVersion(version);
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setClosingTimeout(0));
        this.vertx.runOnContext(v -> this.client.connect(options).onComplete(this.onSuccess(ws -> {
            AtomicBoolean receivedFirstFrame = new AtomicBoolean();
            ws.frameHandler(received -> {
                Buffer receivedBuffer = Buffer.buffer((String)received.textData());
                if (!received.isFinal()) {
                    this.assertEquals(firstFrame, receivedBuffer.toString());
                    receivedFirstFrame.set(true);
                } else if (receivedFirstFrame.get() && received.isFinal()) {
                    this.assertEquals(continuationFrame, receivedBuffer.toString());
                    ws.close();
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    private void testWriteFromConnectHandler(WebSocketVersion version) throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path).setVersion(version);
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(options).onComplete(this.onSuccess(ws -> {
            Buffer received = Buffer.buffer();
            ws.handler(data -> {
                received.appendBuffer(data);
                if (received.length() == buff.length()) {
                    this.assertEquals(buff, received);
                    ws.close();
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    @Test
    public void testNormalWSDeflateFrameCompressionNegotiation() throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertEquals("deflate-frame", ws.headers().get("sec-websocket-extensions"));
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.awaitFuture(this.server.listen());
        WebSocketClientOptions options = new WebSocketClientOptions();
        options.setTryUsePerFrameCompression(true);
        this.client = this.vertx.createWebSocketClient(options);
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> {
            Buffer received = Buffer.buffer();
            ws.handler(data -> {
                received.appendBuffer(data);
                if (received.length() == buff.length()) {
                    this.assertEquals(buff, received);
                    ws.close();
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    @Test
    public void testNormalWSPermessageDeflateCompressionNegotiation() throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertEquals("permessage-deflate", ws.headers().get("sec-websocket-extensions"));
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.awaitFuture(this.server.listen());
        WebSocketClientOptions options = new WebSocketClientOptions();
        options.setTryUsePerMessageCompression(true);
        this.client = this.vertx.createWebSocketClient(options);
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> {
            Buffer received = Buffer.buffer();
            ws.handler(data -> {
                received.appendBuffer(data);
                if (received.length() == buff.length()) {
                    this.assertEquals(buff, received);
                    ws.close();
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    @Test
    public void testWSPermessageDeflateCompressionEnabled() throws InterruptedException {
        this.waitFor(2);
        HttpClientAgent client = this.vertx.createHttpClient(new PoolOptions().setHttp1MaxSize(1));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertEquals("permessage-deflate", ws.headers().get("sec-websocket-extensions"));
            this.complete();
        });
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/")).onComplete(this.onSuccess(req -> req.putHeader("origin", "localhost").putHeader("Upgrade", "Websocket").putHeader("Connection", "upgrade").putHeader("Sec-WebSocket-Extensions", "permessage-deflate").send().onComplete(this.onSuccess(resp -> {
            this.assertEquals(101L, resp.statusCode());
            this.assertEquals("permessage-deflate", resp.headers().get("sec-websocket-extensions"));
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testConnectWithWebSocketCompressionDisabled() throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setPerFrameWebSocketCompressionSupported(false).setPerMessageWebSocketCompressionSupported(false)).webSocketHandler(ws -> {
            this.assertEquals("upgrade", ws.headers().get("Connection"));
            this.assertNull(ws.headers().get("sec-websocket-extensions"));
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> {
            Buffer received = Buffer.buffer();
            ws.handler(data -> {
                received.appendBuffer(data);
                if (received.length() == buff.length()) {
                    this.assertEquals(buff, received);
                    ws.close();
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    private void testValidSubProtocol(WebSocketVersion version) throws Exception {
        String path = "/some/path";
        List<String> clientSubProtocols = Arrays.asList("clientproto", "commonproto");
        List<String> serverSubProtocols = Arrays.asList("serverproto", "commonproto");
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setWebSocketSubProtocols(serverSubProtocols)).webSocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            this.assertEquals("commonproto", ws.subProtocol());
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path).setVersion(version).setSubProtocols(clientSubProtocols);
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(options).onComplete(this.onSuccess(ws -> {
            this.assertEquals("commonproto", ws.subProtocol());
            Buffer received = Buffer.buffer();
            ws.handler(data -> {
                received.appendBuffer(data);
                if (received.length() == buff.length()) {
                    this.assertEquals(buff, received);
                    ws.close();
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    private void testInvalidSubProtocol(WebSocketVersion version) throws Exception {
        String path = "/some/path";
        String subProtocol = "myprotocol";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).addWebSocketSubProtocol("invalid")).webSocketHandler(ws -> {});
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path).setVersion(version).addSubProtocol(subProtocol);
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(options).onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }

    @Test
    public void testInvalidMissingConnectionHeader() {
        this.testInvalidHandshake(this.INVALID_MISSING_CONNECTION_HEADER, false, false, 400);
        this.await();
    }

    @Test
    public void testInvalidMissingConnectionHeaderRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_MISSING_CONNECTION_HEADER, false, true, 400);
        this.await();
    }

    @Test
    public void testInvalidMethod() {
        this.testInvalidHandshake(this.INVALID_HTTP_METHOD, false, false, 405);
        this.await();
    }

    @Test
    public void testInvalidMethodRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_HTTP_METHOD, false, true, 405);
        this.await();
    }

    @Test
    public void testInvalidUri() {
        this.testInvalidHandshake(this.INVALID_URI, false, false, 400);
        this.await();
    }

    @Test
    public void testInvalidUriRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_URI, false, true, 400);
        this.await();
    }

    @Test
    public void testInvalidWebSocketVersion() {
        this.testInvalidHandshake(this.INVALID_WEBSOCKET_VERSION, false, false, 426);
        this.await();
    }

    @Test
    public void testInvalidWebSocketVersionRequestUpgrade() {
        this.testInvalidHandshake(this.INVALID_WEBSOCKET_VERSION, false, true, 426);
        this.await();
    }

    @Test
    public void testHandshakeException() {
        this.testInvalidHandshake(this.HANDSHAKE_EXCEPTION, true, false, 400);
        this.await();
    }

    @Test
    public void testHandshakeExceptionRequestUpgrade() {
        this.testInvalidHandshake(this.HANDSHAKE_EXCEPTION, true, true, 400);
        this.await();
    }

    private void testInvalidHandshake(BiConsumer<HttpClient, Handler<AsyncResult<HttpClientResponse>>> requestProvider, boolean expectEvent, boolean upgradeRequest, int expectedStatus) {
        HttpClientAgent client = this.vertx.createHttpClient(new PoolOptions().setHttp1MaxSize(1));
        if (upgradeRequest) {
            this.server = this.vertx.createHttpServer().webSocketHandler(ws -> this.assertTrue(expectEvent)).requestHandler(req -> req.response().end());
        } else {
            AtomicBoolean first = new AtomicBoolean();
            this.server = this.vertx.createHttpServer().requestHandler(req -> {
                if (first.compareAndSet(false, true)) {
                    try {
                        req.toWebSocket();
                    }
                    catch (Exception exception) {}
                } else {
                    req.response().end();
                }
            });
        }
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(arg_0 -> this.lambda$testInvalidHandshake$87(requestProvider, (HttpClient)client, expectedStatus, arg_0)));
    }

    private void testReject(WebSocketVersion version, Integer rejectionStatus, int expectedRejectionStatus, String expectedBody) throws Exception {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {}).webSocketHandshakeHandler(ws -> {
            this.assertEquals(path, ws.path());
            if (rejectionStatus != null) {
                ws.reject(rejectionStatus.intValue());
            } else {
                ws.reject();
            }
        });
        this.server.listen().onComplete(this.onSuccess(s -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path).setVersion(version);
            this.client = this.vertx.createWebSocketClient();
            this.client.connect(options).onComplete(this.onFailure(t -> {
                this.assertTrue(t instanceof UpgradeRejectedException);
                UpgradeRejectedException rejection = (UpgradeRejectedException)t;
                this.assertEquals(expectedRejectionStatus, rejection.getStatus());
                this.assertEquals("" + expectedBody.length(), rejection.getHeaders().get(HttpHeaders.CONTENT_LENGTH));
                this.assertEquals(expectedBody, rejection.getBody().toString());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testAsyncAccept() throws InterruptedException {
        AtomicBoolean resolved = new AtomicBoolean();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {}).webSocketHandshakeHandler(handshake -> this.vertx.setTimer(500L, id -> {
            resolved.set(true);
            handshake.accept();
        }));
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/some/path").onComplete(this.onSuccess(ws -> {
            this.assertTrue(resolved.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testServerClose() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.testClose(false, true, true);
    }

    @Test
    public void testClientClose() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.testClose(true, false, true);
    }

    @Test
    public void testClientAndServerClose() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.testClose(true, false, true);
    }

    @Test
    public void testConnectionClose() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setIdleTimeout(1));
        this.testClose(false, false, false);
    }

    public void testClose(boolean closeClient, boolean closeServer, boolean regularClose) throws InterruptedException {
        this.waitFor(4);
        Consumer<WebSocketBase> test = ws -> {
            this.assertFalse(ws.isClosed());
            AtomicInteger cnt = new AtomicInteger();
            ws.exceptionHandler(err -> {
                if (regularClose) {
                    this.fail();
                } else if (cnt.getAndIncrement() == 0) {
                    this.complete();
                }
            });
            ws.endHandler(v -> {
                if (regularClose) {
                    this.complete();
                } else {
                    this.fail();
                }
            });
            ws.closeHandler(v -> {
                this.assertTrue(ws.isClosed());
                try {
                    ws.close();
                }
                catch (Exception e) {
                    this.fail();
                }
                this.complete();
            });
        };
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            test.accept((WebSocketBase)ws);
            if (closeServer) {
                ws.close();
            }
        });
        this.awaitFuture(this.server.listen());
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/some/path").onComplete(this.onSuccess(ws -> {
            test.accept((WebSocketBase)ws);
            if (closeClient) {
                ws.close();
            }
        })));
        this.await();
    }

    @Test
    public void testCloseBeforeHandshake() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).requestHandler(req -> req.connection().close());
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/some/path").onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }

    @Test
    public void testRequestEntityTooLarge() throws InterruptedException {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> this.fail());
        this.awaitFuture(this.server.listen());
        HttpClientAgent client = this.vertx.createHttpClient();
        client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setURI(path)).onComplete(this.onSuccess(req -> req.putHeader("Upgrade", "Websocket").putHeader("Connection", "Upgrade").send(TestUtils.randomBuffer(8193)).onComplete(this.onSuccess(resp -> {
            this.assertEquals(413L, resp.statusCode());
            resp.request().connection().closeHandler(v -> this.testComplete());
        }))));
        this.await();
    }

    @Test
    public void testWriteMessageHybi00() throws InterruptedException {
        this.testWriteMessage(256, WebSocketVersion.V00);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi00() throws InterruptedException {
        this.testWriteMessage(65792, WebSocketVersion.V00);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi00() throws InterruptedException {
        this.testWriteMessage(131328, WebSocketVersion.V00);
    }

    @Test
    public void testWriteMessageHybi08() throws InterruptedException {
        this.testWriteMessage(256, WebSocketVersion.V08);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi08() throws InterruptedException {
        this.testWriteMessage(65792, WebSocketVersion.V08);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi08() throws InterruptedException {
        this.testWriteMessage(131328, WebSocketVersion.V08);
    }

    @Test
    public void testWriteMessageHybi17() throws InterruptedException {
        this.testWriteMessage(256, WebSocketVersion.V13);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi17() throws InterruptedException {
        this.testWriteMessage(65792, WebSocketVersion.V13);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi17() throws InterruptedException {
        this.testWriteMessage(131328, WebSocketVersion.V13);
    }

    private void testWriteMessage(int size, WebSocketVersion version) throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.waitFor(2);
        String path = "/some/path";
        byte[] expected = TestUtils.randomByteArray(size);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            AtomicInteger count = new AtomicInteger();
            ws.writeBinaryMessage(Buffer.buffer((byte[])expected)).onComplete(this.onSuccess(v -> {
                this.assertEquals(1L, count.incrementAndGet());
                this.complete();
            }));
            ws.close();
        });
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost("localhost").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setURI(path).setVersion(version);
        this.vertx.runOnContext(v1 -> this.client.connect(options).onComplete(this.onSuccess(ws -> {
            Buffer actual = Buffer.buffer();
            ws.handler(arg_0 -> ((Buffer)actual).appendBuffer(arg_0));
            ws.closeHandler(v2 -> {
                this.assertArrayEquals(expected, actual.getBytes(0, actual.length()));
                this.complete();
            });
        })));
        this.await();
    }

    @Test
    public void testNonFragmentedTextMessage2Hybi00() throws InterruptedException {
        String messageToSend = TestUtils.randomAlphaString(256);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V00);
    }

    @Test
    public void testFragmentedTextMessage2Hybi07() throws InterruptedException {
        String messageToSend = TestUtils.randomAlphaString(131328);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V07);
    }

    @Test
    public void testFragmentedTextMessage2Hybi08() throws InterruptedException {
        String messageToSend = TestUtils.randomAlphaString(131328);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V08);
    }

    @Test
    public void testFragmentedTextMessage2Hybi13() throws InterruptedException {
        String messageToSend = TestUtils.randomAlphaString(131328);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V13);
    }

    @Test
    public void testMaxLengthFragmentedTextMessage() throws InterruptedException {
        String messageToSend = TestUtils.randomAlphaString(262144);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V13);
    }

    @Test
    public void testFragmentedUnicodeTextMessage2Hybi07() throws InterruptedException {
        String messageToSend = TestUtils.randomUnicodeString(65792);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V07);
    }

    @Test
    public void testFragmentedUnicodeTextMessage2Hybi08() throws InterruptedException {
        String messageToSend = TestUtils.randomUnicodeString(65792);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V08);
    }

    @Test
    public void testFragmentedUnicodeTextMessage2Hybi13() throws InterruptedException {
        String messageToSend = TestUtils.randomUnicodeString(65792);
        this.testWriteSingleTextMessage(messageToSend, WebSocketVersion.V13);
    }

    @Test
    public void testTooLargeMessage() throws InterruptedException {
        String messageToSend = TestUtils.randomAlphaString(262145);
        SocketMessages socketMessages = this.testWriteTextMessages(Collections.singletonList(messageToSend), WebSocketVersion.V13);
        List<String> receivedMessages = socketMessages.getReceivedMessages();
        List expectedMessages = Collections.emptyList();
        this.assertEquals("Should not have received any messages", expectedMessages, receivedMessages);
        List<Throwable> receivedExceptions = socketMessages.getReceivedExceptions();
        this.assertEquals("Should have received a single exception", 1L, receivedExceptions.size());
        this.assertTrue("Should have received IllegalStateException", receivedExceptions.get(0) instanceof IllegalStateException);
    }

    @Test
    public void testContinueAfterTooLargeMessage() throws InterruptedException {
        int shortMessageLength = 65536;
        String shortFirstMessage = TestUtils.randomAlphaString(shortMessageLength);
        String tooLongMiddleMessage = TestUtils.randomAlphaString(524288);
        String shortLastMessage = TestUtils.randomAlphaString(shortMessageLength);
        List<String> messagesToSend = Arrays.asList(shortFirstMessage, tooLongMiddleMessage, shortLastMessage);
        SocketMessages socketMessages = this.testWriteTextMessages(messagesToSend, WebSocketVersion.V13);
        List<String> receivedMessages = socketMessages.getReceivedMessages();
        List<String> expectedMessages = Arrays.asList(shortFirstMessage, shortLastMessage);
        this.assertEquals("Incorrect received messages", expectedMessages, receivedMessages);
    }

    private void testWriteSingleTextMessage(String messageToSend, WebSocketVersion version) throws InterruptedException {
        List<String> messagesToSend = Collections.singletonList(messageToSend);
        SocketMessages socketMessages = this.testWriteTextMessages(messagesToSend, version);
        this.assertEquals("Did not receive all messages", messagesToSend, socketMessages.getReceivedMessages());
        List expectedExceptions = Collections.emptyList();
        this.assertEquals("Should not have received any exceptions", expectedExceptions, socketMessages.getReceivedExceptions());
    }

    private SocketMessages testWriteTextMessages(List<String> messagesToSend, WebSocketVersion version) throws InterruptedException {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            for (String messageToSend : messagesToSend) {
                ws.writeTextMessage(messageToSend);
            }
            ws.close();
        });
        ArrayList<String> receivedMessages = new ArrayList<String>();
        ArrayList<Throwable> receivedExceptions = new ArrayList<Throwable>();
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path).setVersion(version);
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v1 -> this.client.connect(options).onComplete(this.onSuccess(ws -> {
            ws.textMessageHandler(receivedMessages::add);
            ws.exceptionHandler(receivedExceptions::add);
            ws.closeHandler(v2 -> this.testComplete());
        })));
        this.await();
        return new SocketMessages(receivedMessages, receivedExceptions);
    }

    @Test
    public void testHandshakeTimeoutFires() throws Exception {
        try (NetServer server = (NetServer)this.vertx.createNetServer().connectHandler(so -> {}).listen(1234, "localhost").await(20L, TimeUnit.SECONDS);){
            this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setConnectTimeout(1000));
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(1234)).setHost("localhost").setURI("/").setTimeout(1000L);
            this.client.connect(options).onComplete(this.onFailure(err -> {
                this.assertEquals(WebSocketHandshakeException.class, err.getClass());
                this.testComplete();
            }));
            this.await();
        }
    }

    @Test
    public void testHandshakeTimeoutDoesNotFire() throws Exception {
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {});
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").await();
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setConnectTimeout(1000));
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/").setTimeout(1000L);
        this.client.connect(options).onComplete(this.onSuccess(ws -> {
            AtomicBoolean closed = new AtomicBoolean();
            ws.closeHandler(v -> closed.set(true));
            this.vertx.setTimer(1100L, id -> {
                this.assertFalse(closed.get());
                this.testComplete();
            });
        }));
        this.await();
    }

    private void connectUntilWebSocketReject(WebSocketClient client, int count, Handler<AsyncResult<Void>> doneHandler) {
        this.vertx.runOnContext(v -> client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/some/path").onComplete(ar -> {
            if (ar.succeeded()) {
                if (count < 100) {
                    this.connectUntilWebSocketReject(client, count + 1, doneHandler);
                } else {
                    doneHandler.handle((Object)Future.failedFuture((Throwable)((Object)new AssertionError())));
                }
            } else {
                Throwable err = ar.cause();
                if (err instanceof UpgradeRejectedException || err instanceof IOException) {
                    doneHandler.handle((Object)Future.succeededFuture());
                } else if (count < 100) {
                    this.connectUntilWebSocketReject(client, count + 1, doneHandler);
                } else {
                    doneHandler.handle((Object)Future.failedFuture((Throwable)err));
                }
            }
        }));
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.close().onComplete(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close().onComplete(ar2 -> this.server.close().onComplete(ar3 -> this.testComplete()));
        });
        this.await();
    }

    @Test
    public void testClearClientHandlersOnEnd() throws InterruptedException {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(WebSocketBase::close);
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> ws.endHandler(v2 -> {
            try {
                ws.endHandler(null);
                ws.exceptionHandler(null);
                ws.handler(null);
            }
            catch (Exception e) {
                this.fail("Was expecting to set to null the handlers when the socket is closed");
                return;
            }
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testWriteOnEnd() throws InterruptedException {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(WebSocketBase::close);
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> ws.endHandler(v2 -> ws.write((Object)Buffer.buffer((String)"test")).onComplete(this.onFailure(err -> this.testComplete()))))));
        this.await();
    }

    @Test
    public void testReceiveHttpResponseHeadersOnClient() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).requestHandler(req -> this.handshakeWithCookie((HttpServerRequest)req));
        AtomicReference webSocketRef = new AtomicReference();
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/some/path").onComplete(this.onSuccess(ws -> {
            MultiMap entries = ws.headers();
            this.assertNotNull(entries);
            this.assertFalse(entries.isEmpty());
            this.assertEquals("websocket".toLowerCase(), entries.get("Upgrade").toLowerCase());
            this.assertEquals("upgrade".toLowerCase(), entries.get("Connection").toLowerCase());
            HashSet cookiesToSet = new HashSet(entries.getAll("Set-Cookie"));
            this.assertEquals(2L, cookiesToSet.size());
            this.assertTrue(cookiesToSet.contains("SERVERID=test-server-id"));
            this.assertTrue(cookiesToSet.contains("JSONID=test-json-id"));
            webSocketRef.set(ws);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUpgrade() throws InterruptedException {
        this.testUpgrade(false);
    }

    @Test
    public void testUpgradeDelayed() throws InterruptedException {
        this.testUpgrade(true);
    }

    private void testUpgrade(boolean delayed) throws InterruptedException {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        this.server.requestHandler(request -> {
            Runnable runner = () -> request.toWebSocket().onComplete(this.onSuccess(ws -> {
                HttpServerResponse response = request.response();
                this.assertTrue(response.ended());
                try {
                    response.putHeader("foo", "bar");
                    this.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    response.end();
                    this.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ws.handler(buff -> {
                    ws.write((Object)Buffer.buffer((String)"helloworld"));
                    ws.close();
                });
            }));
            if (delayed) {
                request.pause();
                this.vertx.runOnContext(v -> runner.run());
            } else {
                runner.run();
            }
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v1 -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> {
            Buffer buff = Buffer.buffer();
            ws.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
            ws.endHandler(v2 -> {
                this.assertEquals("helloworld", buff.toString("UTF-8"));
                this.testComplete();
            });
            ws.write((Object)Buffer.buffer((String)"foo"));
        })));
        this.await();
    }

    @Test
    public void testUpgradeFailure() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        this.server.requestHandler(request -> request.toWebSocket().onComplete(this.onFailure(err -> this.testComplete())));
        this.awaitFuture(this.server.listen());
        HttpClientAgent client = this.vertx.createHttpClient();
        this.handshake((HttpClient)client, (Handler<HttpClientRequest>)((Handler)req -> {
            req.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"100");
            req.sendHead().onComplete(this.onSuccess(v -> req.connection().close()));
        }));
        this.await();
    }

    @Test
    public void testUnmaskedFrameRequest() {
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setSendUnmaskedFrames(true));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setAcceptUnmaskedFrames(true));
        this.server.requestHandler(req -> req.response().setChunked(true).write("connect"));
        this.server.webSocketHandler(ws -> ws.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer data) {
                WebSocketTest.this.assertEquals(data.toString(), "first unmasked frame");
                WebSocketTest.this.testComplete();
            }
        }));
        this.server.listen().onComplete(this.onSuccess(server -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.writeFinalTextFrame("first unmasked frame")))));
        this.await();
    }

    @Test
    public void testInvalidUnmaskedFrameRequest() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setSendUnmaskedFrames(true));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setAcceptUnmaskedFrames(false));
        this.server.requestHandler(req -> req.response().setChunked(true).write("connect"));
        this.server.webSocketHandler(ws -> {
            ws.exceptionHandler(exception -> {
                ws.exceptionHandler(null);
                this.testComplete();
            });
            ws.handler(result -> this.fail("Cannot decode unmasked message because I require masked frame as configured"));
        });
        this.awaitFuture(this.server.listen());
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.writeFinalTextFrame("first unmasked frame")));
        this.await();
    }

    @Test
    public void testUpgradeInvalidRequest() throws InterruptedException {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        this.server.requestHandler(request -> {
            request.toWebSocket().onComplete(this.onFailure(err -> this.complete()));
            request.response().end();
        });
        this.awaitFuture(this.server.listen());
        HttpClientAgent client = this.vertx.createHttpClient();
        client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.complete()));
        this.await();
    }

    @Test
    public void testRaceConditionWithWebSocketClientEventLoop() {
        this.testRaceConditionWithWebSocketClient(this.vertx.getOrCreateContext());
    }

    @Test
    public void testRaceConditionWithWebSocketClientWorker() throws Exception {
        final CompletableFuture fut = new CompletableFuture();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                fut.complete(this.context);
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER)).onComplete(ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        this.testRaceConditionWithWebSocketClient((Context)fut.get());
    }

    private Future<NetSocket> handshakeWithCookie(HttpServerRequest req) {
        return ((Http1xServerConnection)req.connection()).netSocket().compose(so -> {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] inputBytes = (req.getHeader("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes();
                digest.update(inputBytes);
                byte[] hashedBytes = digest.digest();
                byte[] accept = Base64.getEncoder().encode(hashedBytes);
                Buffer data = Buffer.buffer();
                data.appendString("HTTP/1.1 101 Switching Protocols\r\n");
                data.appendString("Upgrade: websocket\r\n");
                data.appendString("Connection: upgrade\r\n");
                data.appendString("Sec-WebSocket-Accept: " + new String(accept) + "\r\n");
                data.appendString("Set-Cookie: SERVERID=test-server-id\r\n");
                data.appendString("Set-Cookie: JSONID=test-json-id\r\n");
                data.appendString("\r\n");
                so.write((Object)data);
                return Future.succeededFuture((Object)so);
            }
            catch (NoSuchAlgorithmException e) {
                req.response().setStatusCode(500).end();
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    private Future<NetSocket> handshake(HttpServerRequest req) {
        return ((Http1xServerConnection)req.connection()).netSocket().flatMap(so -> {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] inputBytes = (req.getHeader("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes();
                digest.update(inputBytes);
                byte[] hashedBytes = digest.digest();
                byte[] accept = Base64.getEncoder().encode(hashedBytes);
                Buffer data = Buffer.buffer();
                data.appendString("HTTP/1.1 101 Switching Protocols\r\n");
                data.appendString("Upgrade: websocket\r\n");
                data.appendString("Connection: upgrade\r\n");
                data.appendString("Sec-WebSocket-Accept: " + new String(accept) + "\r\n");
                data.appendString("\r\n");
                so.write((Object)data);
                return Future.succeededFuture((Object)so);
            }
            catch (NoSuchAlgorithmException e) {
                req.response().setStatusCode(500).end();
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    private void handshake(HttpClient client, Handler<HttpClientRequest> handler) {
        client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setURI("/")).onComplete(this.onSuccess(req -> {
            req.putHeader("Upgrade", "websocket").putHeader("Connection", "Upgrade").putHeader("Sec-WebSocket-Key", "dGhlIHNhbXBsZSBub25jZQ==").putHeader("Sec-WebSocket-Protocol", "chat").putHeader("Sec-WebSocket-Version", "13").putHeader("Origin", "http://example.com");
            handler.handle(req);
        }));
    }

    private void testRaceConditionWithWebSocketClient(Context context) {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        this.server.requestHandler(req -> this.handshake((HttpServerRequest)req).onComplete(this.onSuccess(so -> so.write((Object)Buffer.buffer((byte[])new byte[]{-126, 5, 104, 101, 108, 108, 111})))));
        this.server.listen().onComplete(this.onSuccess(s -> context.runOnContext(v -> {
            this.client = this.vertx.createWebSocketClient();
            this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            })));
        })));
        this.await();
    }

    @Test
    public void testRaceConditionWithWebSocketClientWorker2() throws Exception {
        int size = this.getOptions().getWorkerPoolSize() - 4;
        List<Context> workers = this.createWorkers(size + 1);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        this.server.webSocketHandler(ws -> ws.write((Object)Buffer.buffer((String)"hello")));
        this.server.listen().onComplete(this.onSuccess(s -> {
            this.client = this.vertx.createWebSocketClient();
            ((Context)workers.get(0)).runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            }))));
        }));
        this.await();
    }

    @Test
    public void testWorker() {
        this.waitFor(2);
        DeploymentOptions deploymentOptions = new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER);
        this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start(Promise<Void> startPromise) {
                WebSocketTest.this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
                WebSocketTest.this.server.webSocketHandler(ws -> {
                    WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                    ws.handler(msg -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        ws.write((Object)Buffer.buffer((String)"pong"));
                    });
                    ws.endHandler(v -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        WebSocketTest.this.complete();
                    });
                });
                WebSocketTest.this.server.listen().mapEmpty().onComplete(startPromise);
            }
        }, deploymentOptions).onComplete(this.onSuccess(serverID -> this.vertx.deployVerticle(() -> new AbstractVerticle(){

            public void start() {
                WebSocketTest.this.client = this.vertx.createWebSocketClient();
                Future fut = WebSocketTest.this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/");
                fut.onComplete(WebSocketTest.this.onSuccess(ws -> {
                    WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                    ws.write((Object)Buffer.buffer((String)"ping"));
                    ws.handler(buf -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        ws.end();
                    });
                    ws.endHandler(v -> {
                        WebSocketTest.this.assertTrue(Context.isOnWorkerThread());
                        WebSocketTest.this.complete();
                    });
                }));
            }
        }, deploymentOptions).onComplete(this.onSuccess(id -> {}))));
        this.await();
    }

    @Test
    public void httpClientWebSocketConnectionFailureHandlerShouldBeCalled() throws Exception {
        int port = 7867;
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(port, "localhost", "").onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }

    @Test
    public void testClientWebSocketWithHttp2Client() throws Exception {
        this.client = this.vertx.createWebSocketClient();
        HttpClientAgent client = this.vertx.createHttpClient(new HttpClientOptions().setHttp2ClearTextUpgrade(false).setProtocolVersion(HttpVersion.HTTP_2));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT));
        this.server.requestHandler(req -> req.response().setChunked(true).write("connect"));
        this.server.webSocketHandler(ws -> ws.writeFinalTextFrame("ok"));
        this.awaitFuture(this.server.listen());
        client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost")).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.handler(buff -> {
            this.assertEquals("ok", buff.toString());
            this.testComplete();
        })))))));
        this.await();
    }

    @Test
    public void testClientWebSocketConnectionCloseOnBadResponseWithKeepalive() throws Throwable {
        this.doTestClientWebSocketConnectionCloseOnBadResponse(true);
    }

    @Test
    public void testClientWebSocketConnectionCloseOnBadResponseWithoutKeepalive() throws Throwable {
        this.doTestClientWebSocketConnectionCloseOnBadResponse(false);
    }

    void addResult(Throwable result) {
        try {
            this.resultQueue.put(result);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void doTestClientWebSocketConnectionCloseOnBadResponse(boolean keepAliveInOptions) throws Throwable {
        Exception serverGotCloseException = new Exception();
        this.netServer = this.vertx.createNetServer().connectHandler(sock -> {
            Buffer fullReq = Buffer.buffer((int)230);
            sock.handler(b -> {
                fullReq.appendBuffer(b);
                String reqPart = b.toString();
                if (fullReq.toString().contains("\r\n\r\n")) {
                    try {
                        Object content = "0123456789";
                        content = (String)content + (String)content;
                        content = (String)content + (String)content + (String)content + (String)content + (String)content;
                        Object resp = "HTTP/1.1 200 OK\r\n";
                        if (keepAliveInOptions) {
                            resp = (String)resp + "Connection: close\r\n";
                        }
                        resp = (String)resp + "Content-Length: 100\r\n\r\n" + (String)content;
                        sock.write((Object)Buffer.buffer((byte[])((String)resp).getBytes("ASCII")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.addResult(e);
                    }
                }
            });
            sock.closeHandler(v -> this.addResult(serverGotCloseException));
        });
        this.netServer.listen().onComplete(ar -> {
            if (ar.failed()) {
                this.addResult(ar.cause());
                return;
            }
            NetServer server = (NetServer)ar.result();
            int port = server.actualPort();
            this.client = this.vertx.createWebSocketClient();
            this.client.connect(port, "localhost", "/").onComplete(ar2 -> {
                if (ar2.succeeded()) {
                    this.addResult((Throwable)((Object)new AssertionError((Object)"WebSocket unexpectedly connected")));
                    ((WebSocket)ar2.result()).close();
                } else {
                    this.addResult(ar2.cause());
                }
            });
        });
        boolean serverGotClose = false;
        boolean clientGotCorrectException = false;
        while (!serverGotClose || !clientGotCorrectException) {
            Throwable result = this.resultQueue.poll(20L, TimeUnit.SECONDS);
            if (result == null) {
                throw new AssertionError((Object)("Timed out waiting for expected state, current: serverGotClose = " + serverGotClose + ", clientGotCorrectException = " + clientGotCorrectException));
            }
            if (result == serverGotCloseException) {
                serverGotClose = true;
                continue;
            }
            if (result instanceof UpgradeRejectedException && ((UpgradeRejectedException)result).getStatus() == 200) {
                clientGotCorrectException = true;
                continue;
            }
            throw result;
        }
    }

    @Test
    public void testClearClientSslOptions() throws InterruptedException {
        HttpServerOptions serverOptions = new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTPS_PORT).setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get());
        WebSocketClientOptions clientOptions = new WebSocketClientOptions().setTrustAll(true).setVerifyHost(false);
        this.client = this.vertx.createWebSocketClient(clientOptions);
        this.server = this.vertx.createHttpServer(serverOptions).webSocketHandler(WebSocketBase::close);
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT)).setSsl(Boolean.valueOf(true));
        this.vertx.runOnContext(v1 -> this.client.connect(options).onComplete(this.onSuccess(ws -> ws.closeHandler(v2 -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testServerWebSocketPingPong() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost"));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> {
                this.assertEquals("ping", buff.toString());
                ws.close();
            });
            ws.writePing(Buffer.buffer((String)"ping"));
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.handler(buff -> this.fail("Should not receive a buffer"));
            ws.closeHandler(v2 -> this.testComplete());
        })));
        this.await();
    }

    @Test
    public void testWebSocketPausePing() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost"));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> {
                this.assertEquals("ping", buff.toString());
                ws.close();
            });
            ws.writePing(Buffer.buffer((String)"ping"));
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.pause();
            ws.handler(buff -> this.fail("Should not receive a buffer"));
            ws.fetch(1L);
            ws.endHandler(v2 -> this.testComplete());
        })));
        this.await();
    }

    @Test
    public void testServerWebSocketPingExceeds125Bytes() throws InterruptedException {
        this.testServerWebSocketPingPongCheck(255, ws -> ws.writePing(Buffer.buffer((String)TestUtils.randomAlphaString(126))));
    }

    @Test
    public void testServerWebSocketPongExceeds125Bytes() throws InterruptedException {
        this.testServerWebSocketPingPongCheck(255, ws -> ws.writePong(Buffer.buffer((String)TestUtils.randomAlphaString(126))));
    }

    @Test
    public void testServerWebSocketPingExceedsMaxFrameSize() throws InterruptedException {
        this.testServerWebSocketPingPongCheck(100, ws -> ws.writePing(Buffer.buffer((String)TestUtils.randomAlphaString(101))));
    }

    @Test
    public void testServerWebSocketPongExceedsMaxFrameSize() throws InterruptedException {
        this.testServerWebSocketPingPongCheck(100, ws -> ws.writePong(Buffer.buffer((String)TestUtils.randomAlphaString(101))));
    }

    private void testServerWebSocketPingPongCheck(int maxFrameSize, Function<ServerWebSocket, Future<Void>> check) throws InterruptedException {
        Pattern pattern = Pattern.compile("^P[io]ng cannot exceed maxWebSocketFrameSize or 125 bytes$");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> this.fail());
            ((Future)check.apply((ServerWebSocket)ws)).onComplete(this.onFailure(err -> {
                Matcher matcher = pattern.matcher(err.getMessage());
                if (matcher.matches()) {
                    ws.close();
                } else {
                    this.fail("Unexpected error message" + err.getMessage());
                }
            }));
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.closeHandler(v2 -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testServerWebSocketSendPingExceeds125Bytes() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> this.fail());
            ws.writeFrame(WebSocketFrame.pingFrame((Buffer)Buffer.buffer((String)pingBody)));
            this.vertx.setTimer(2000L, id -> this.testComplete());
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {}));
        this.await();
    }

    @Test
    public void testClientWebSocketSendPingExceeds125Bytes() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {});
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.pongHandler(buffer -> this.fail());
            ws.writeFrame(WebSocketFrame.pingFrame((Buffer)Buffer.buffer((String)pingBody)));
            this.vertx.setTimer(2000L, id -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testServerWebSocketSendPongExceeds125Bytes() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> ws.writeFrame(WebSocketFrame.pongFrame((Buffer)Buffer.buffer((String)pingBody))));
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.pongHandler(buff -> this.fail());
            this.vertx.setTimer(2000L, id -> this.testComplete());
        })));
        this.await();
    }

    @Test
    public void testClientWebSocketSendPongExceeds125Bytes() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(126);
        int maxFrameSize = 256;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize));
        this.server.webSocketHandler(ws -> {
            ws.pongHandler(buff -> this.fail());
            this.vertx.setTimer(2000L, id -> this.testComplete());
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.writeFrame(WebSocketFrame.pongFrame((Buffer)Buffer.buffer((String)pingBody)))));
        this.await();
    }

    @Test
    public void testServerWebSocketReceivePongExceedsMaxFrameSize() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {
            ArrayList pongs = new ArrayList();
            ws.pongHandler(pong -> {
                pongs.add(pong);
                if (pongs.size() == 2) {
                    this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                    this.testComplete();
                }
            });
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            try {
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ((BufferInternal)ping1.copy()).getByteBuf(), false));
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ((BufferInternal)ping2.copy()).getByteBuf(), true));
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }));
        this.await();
    }

    @Test
    public void testClientWebSocketReceivePongExceedsMaxFrameSize() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {
            try {
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ((BufferInternal)ping1.copy()).getByteBuf(), false));
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PONG, ((BufferInternal)ping2.copy()).getByteBuf(), true));
            }
            catch (Throwable t) {
                this.fail(t);
            }
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ArrayList pongs = new ArrayList();
            ws.pongHandler(pong -> {
                pongs.add(pong);
                if (pongs.size() == 2) {
                    this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                    this.testComplete();
                }
            });
        })));
        this.await();
    }

    @Test
    public void testServerWebSocketReceivePingExceedsMaxFrameSize() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {});
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ArrayList pongs = new ArrayList();
            ws.pongHandler(pong -> {
                pongs.add(pong);
                if (pongs.size() == 2) {
                    this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                    this.testComplete();
                }
            });
            try {
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ((BufferInternal)ping1.copy()).getByteBuf(), false));
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ((BufferInternal)ping2.copy()).getByteBuf(), true));
            }
            catch (Throwable t) {
                this.fail(t);
            }
        })));
        this.await();
    }

    @Test
    public void testClientWebSocketReceivePingExceedsMaxFrameSize() throws InterruptedException {
        String pingBody = TestUtils.randomAlphaString(113);
        Integer maxFrameSize = 64;
        Buffer ping1 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(0, maxFrameSize.intValue()));
        Buffer ping2 = Buffer.buffer((byte[])Buffer.buffer((byte[])pingBody.getBytes()).getBytes(maxFrameSize.intValue(), pingBody.length()));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost").setMaxWebSocketFrameSize(maxFrameSize.intValue()));
        this.server.webSocketHandler(ws -> {});
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ArrayList pongs = new ArrayList();
            ws.pongHandler(pong -> {
                pongs.add(pong);
                if (pongs.size() == 2) {
                    this.assertEquals(pongs, Arrays.asList(ping1, ping2));
                    this.testComplete();
                }
            });
            try {
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ((BufferInternal)ping1.copy()).getByteBuf(), false));
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(WebSocketFrameType.PING, ((BufferInternal)ping2.copy()).getByteBuf(), true));
            }
            catch (Throwable t) {
                this.fail(t);
            }
        })));
        this.await();
    }

    @Test
    public void testClientWebSocketPingPong() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost"));
        this.server.webSocketHandler(ws -> {});
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.pongHandler(pong -> {
                this.assertEquals("ping", pong.toString());
                this.testComplete();
            });
            ws.writePing(Buffer.buffer((String)"ping"));
        }));
        this.await();
    }

    @Test
    public void testWebSocketAbs() throws InterruptedException {
        HttpServerOptions serverOptions = new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTPS_PORT).setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get());
        WebSocketClientOptions clientOptions = new WebSocketClientOptions().setTrustAll(true).setVerifyHost(false);
        this.client = this.vertx.createWebSocketClient(clientOptions);
        this.server = this.vertx.createHttpServer(serverOptions).requestHandler(request -> {
            if ("/test".equals(request.path())) {
                request.toWebSocket().onComplete(this.onSuccess(ServerWebSocket::close));
            } else {
                request.response().end();
            }
        });
        this.awaitFuture(this.server.listen());
        String url = "wss://localhost:" + HttpTestBase.DEFAULT_HTTPS_PORT + "/test";
        this.client.connect(new WebSocketConnectOptions().setAbsoluteURI(url)).onComplete(this.onSuccess(ws -> ws.closeHandler(v -> this.testComplete())));
        this.await();
    }

    @Test
    public void testCloseStatusCodeFromServer() throws InterruptedException {
        this.waitFor(3);
        this.testCloseStatusCodeFromServer(ServerWebSocket::close);
    }

    @Test
    public void testCloseStatusCodeFromServerWithHandler() throws InterruptedException {
        this.waitFor(4);
        this.testCloseStatusCodeFromServer(ws -> ws.close().onComplete(this.onSuccess(v -> this.complete())));
    }

    private void testCloseStatusCodeFromServer(Consumer<ServerWebSocket> closeOp) throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(socket -> {
            socket.closeHandler(a -> this.complete());
            this.vertx.setTimer(100L, id -> closeOp.accept((ServerWebSocket)socket));
        });
        this.awaitFuture(this.server.listen());
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.frameHandler(frame -> {
                this.assertEquals(1000L, ((BufferInternal)frame.binaryData()).getByteBuf().getShort(0));
                this.assertEquals(1000L, frame.closeStatusCode());
                this.assertNull(frame.closeReason());
                this.complete();
            });
            ws.closeHandler(sc -> {
                this.assertEquals((Object)1000, ws.closeStatusCode());
                this.complete();
            });
        })));
        this.await();
    }

    @Test
    public void testCloseStatusCodeFromClient() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(2);
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(socket -> {
            socket.closeHandler(a -> latch.countDown());
            socket.frameHandler(frame -> {
                this.assertEquals(1000L, ((BufferInternal)frame.binaryData()).getByteBuf().getShort(0));
                this.assertEquals(1000L, frame.closeStatusCode());
                this.assertNull(frame.closeReason());
                latch.countDown();
            });
        });
        this.awaitFuture(this.server.listen());
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(WebSocketBase::close));
        this.awaitLatch(latch);
    }

    @Test
    public void testCloseFrame() throws InterruptedException {
        this.waitFor(3);
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(socket -> {
            socket.closeHandler(a -> {
                this.assertEquals((Object)1001, socket.closeStatusCode());
                this.assertEquals(TEST_REASON, socket.closeReason());
                this.complete();
            });
            socket.frameHandler(frame -> {
                if (frame.isText()) {
                    TestUtils.assertIllegalStateException(() -> ((WebSocketFrame)frame).closeStatusCode());
                    this.complete();
                } else {
                    this.assertEquals(frame.closeReason(), TEST_REASON);
                    this.assertEquals(frame.closeStatusCode(), 1001L);
                    this.complete();
                }
            });
        });
        this.awaitFuture(this.server.listen());
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.writeTextMessage("Hello");
            ws.close((short)1001, TEST_REASON);
        }));
        this.await();
    }

    @Test
    public void testCloseCustomPayloadFromServer() throws InterruptedException {
        this.waitFor(2);
        this.testCloseCustomPayloadFromServer(ws -> ws.close((short)1001, TEST_REASON));
    }

    @Test
    public void testCloseCustomPayloadFromServerWithHandler() throws InterruptedException {
        this.waitFor(3);
        this.testCloseCustomPayloadFromServer(ws -> ws.close((short)1001, TEST_REASON).onComplete(this.onSuccess(v -> this.complete())));
    }

    private void testCloseCustomPayloadFromServer(Consumer<ServerWebSocket> closeOp) throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(socket -> {
            socket.closeHandler(a -> {
                this.assertEquals((Object)1001, socket.closeStatusCode());
                this.assertEquals(TEST_REASON, socket.closeReason());
                this.complete();
            });
            this.vertx.setTimer(100L, ar -> closeOp.accept((ServerWebSocket)socket));
        });
        this.awaitFuture(this.server.listen());
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> ws.frameHandler(frame -> {
            this.assertEquals(TEST_REASON, ((BufferInternal)frame.binaryData()).getByteBuf().readerIndex(2).toString(StandardCharsets.UTF_8));
            this.assertEquals(1001L, ((BufferInternal)frame.binaryData()).getByteBuf().getShort(0));
            this.assertEquals(TEST_REASON, frame.closeReason());
            this.assertEquals(1001L, frame.closeStatusCode());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testCloseCustomPayloadFromClient() throws InterruptedException {
        this.waitFor(2);
        this.testCloseCustomPayloadFromClient(ws -> ws.close((short)1001, TEST_REASON));
    }

    @Test
    public void testCloseCustomPayloadFromClientWithHandler() throws InterruptedException {
        this.waitFor(3);
        this.testCloseCustomPayloadFromClient(ws -> ws.close((short)1001, TEST_REASON).onComplete(this.onSuccess(v -> this.complete())));
    }

    private void testCloseCustomPayloadFromClient(Consumer<WebSocket> closeOp) throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(socket -> {
            socket.closeHandler(a -> this.complete());
            socket.frameHandler(frame -> {
                this.assertEquals(TEST_REASON, ((BufferInternal)frame.binaryData()).getByteBuf().readerIndex(2).toString(StandardCharsets.UTF_8));
                this.assertEquals(1001L, ((BufferInternal)frame.binaryData()).getByteBuf().getShort(0));
                this.assertEquals(TEST_REASON, frame.closeReason());
                this.assertEquals(1001L, frame.closeStatusCode());
                this.complete();
            });
        });
        this.awaitFuture(this.server.listen());
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(closeOp));
        this.await();
    }

    @Test
    public void testServerWebSocketHandshakeWithNonPersistentHTTP1_0Connection() {
        this.testServerWebSocketHandshakeWithNonPersistentConnection(HttpVersion.HTTP_1_0);
    }

    @Ignore
    @Test
    public void testServerWebSocketHandshakeWithNonPersistentHTTP1_1Connection() {
        this.testServerWebSocketHandshakeWithNonPersistentConnection(HttpVersion.HTTP_1_1);
    }

    private void testServerWebSocketHandshakeWithNonPersistentConnection(HttpVersion version) {
        this.server = this.vertx.createHttpServer();
        AtomicBoolean webSocketClose = new AtomicBoolean();
        this.server.webSocketHandler(ws -> ws.frameHandler(frame -> {
            webSocketClose.set(true);
            ws.close();
        }));
        HttpClientAgent client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(version).setKeepAlive(false));
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v1 -> this.handshake((HttpClient)client, (Handler<HttpClientRequest>)((Handler)req -> req.send().onComplete(this.onSuccess(resp -> {
            this.assertEquals(101L, resp.statusCode());
            resp.endHandler(v -> {
                Http1xClientConnection conn = (Http1xClientConnection)req.connection();
                NetSocketInternal soi = conn.toNetSocket();
                soi.messageHandler(msg -> {
                    if (msg instanceof CloseWebSocketFrame) {
                        soi.close();
                    }
                });
                ChannelPipeline pipeline = soi.channelHandlerContext().pipeline();
                pipeline.addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
                pipeline.addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, 1000));
                pipeline.remove("codec");
                Future pingSent = soi.writeMessage((Object)new PingWebSocketFrame());
                soi.closeHandler(v2 -> {
                    this.assertTrue(webSocketClose.get());
                    this.assertTrue(pingSent.succeeded());
                    this.testComplete();
                });
            });
        }))))));
        this.await();
    }

    @Test
    public void testServerCloseHandshake() {
        short status = (short)(4000 + TestUtils.randomPositiveInt() % 100);
        this.waitFor(2);
        this.server = this.vertx.createHttpServer();
        this.server.webSocketHandler(ws -> ws.closeHandler(sc -> {
            this.assertEquals((Object)status, ws.closeStatusCode());
            this.complete();
        }));
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v1 -> {
            HttpClientAgent client = this.vertx.createHttpClient();
            this.handshake((HttpClient)client, (Handler<HttpClientRequest>)((Handler)req -> req.send().onComplete(this.onSuccess(resp -> {
                this.assertEquals(101L, resp.statusCode());
                Http1xClientConnection conn = (Http1xClientConnection)req.connection();
                NetSocketInternal soi = conn.toNetSocket();
                ChannelPipeline pipeline = soi.channelHandlerContext().pipeline();
                pipeline.addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
                pipeline.addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, 1000));
                pipeline.remove("codec");
                String reason = TestUtils.randomAlphaString(10);
                soi.writeMessage((Object)new CloseWebSocketFrame((int)status, reason));
                AtomicBoolean closeFrameReceived = new AtomicBoolean();
                soi.messageHandler(msg -> {
                    try {
                        if (msg instanceof CloseWebSocketFrame) {
                            CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
                            this.assertEquals(status, frame.statusCode());
                            this.assertEquals(reason, frame.reasonText());
                            closeFrameReceived.set(true);
                        }
                    }
                    finally {
                        ReferenceCountUtil.release((Object)msg);
                    }
                });
                soi.closeHandler(v2 -> {
                    this.assertTrue(closeFrameReceived.get());
                    this.complete();
                });
            }))));
        }));
        this.await();
    }

    @Test
    public void testClientCloseHandshake() {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> this.handshake((HttpServerRequest)req).onComplete(this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(false));
            soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(true, false, 1000));
            ArrayDeque received = new ArrayDeque();
            soi.messageHandler(msg -> {
                received.add(msg);
                if (msg instanceof CloseWebSocketFrame) {
                    so.close();
                }
            });
            int status = 4000 + TestUtils.randomPositiveInt() % 100;
            String reason = TestUtils.randomAlphaString(10);
            soi.writeMessage((Object)new CloseWebSocketFrame(status, reason));
            soi.closeHandler(v -> {
                this.assertEquals(1L, received.size());
                Object msg = received.getFirst();
                this.assertEquals(msg.getClass(), CloseWebSocketFrame.class);
                CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
                try {
                    this.assertEquals(status, frame.statusCode());
                    this.assertEquals(reason, frame.reasonText());
                }
                finally {
                    ReferenceCountUtil.release(msg);
                }
                this.complete();
            });
        })));
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v1 -> {
            this.client = this.vertx.createWebSocketClient();
            this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/chat").onComplete(this.onSuccess(ws -> ws.closeHandler(v -> this.complete())));
        }));
        this.await();
    }

    @Test
    public void testClientConnectionCloseTimeout() {
        this.testClientConnectionCloseTimeout(1, true, 1000);
    }

    @Test
    public void testClientConnectionCloseImmediately() {
        this.testClientConnectionCloseTimeout(0, true, 1000);
    }

    @Test
    public void testClientConnectionCloseTimeoutWithoutCloseFrame() {
        this.testClientConnectionCloseTimeout(1, false, 1006);
    }

    public void testClientConnectionCloseTimeout(int timeout, boolean respondWithCloseFrame, int expectedStatusCode) {
        this.waitFor(3);
        List received = Collections.synchronizedList(new ArrayList());
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> this.handshake((HttpServerRequest)req).onComplete(this.onSuccess(so -> {
            NetSocketInternal soi = (NetSocketInternal)so;
            soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(false));
            soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(true, false, 1000));
            soi.messageHandler(msg -> {
                received.add(msg);
                if (msg instanceof CloseWebSocketFrame && respondWithCloseFrame) {
                    CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
                    soi.writeMessage((Object)new CloseWebSocketFrame(frame.statusCode(), frame.reasonText()));
                }
            });
            soi.closeHandler(v -> this.complete());
        })));
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").await();
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setClosingTimeout(timeout));
        WebSocket ws = (WebSocket)this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/chat").await();
        ws.endHandler(v -> this.complete());
        ws.exceptionHandler(err -> this.complete());
        ws.closeHandler(v -> {
            if ((long)timeout > 0L) {
                this.assertEquals(1L, received.size());
                Object msg = received.get(0);
                try {
                    this.assertNotNull(ws.closeStatusCode());
                    this.assertEquals(expectedStatusCode, ws.closeStatusCode().shortValue());
                    this.assertEquals(msg.getClass(), CloseWebSocketFrame.class);
                }
                finally {
                    ReferenceCountUtil.release(msg);
                }
            }
            this.complete();
        });
        ws.close();
        this.await();
    }

    @Test
    public void testServerCloseTimeout() throws InterruptedException {
        this.testServerConnectionClose(1);
    }

    @Test
    public void testServerImmediateClose() throws InterruptedException {
        this.testServerConnectionClose(0);
    }

    public void testServerConnectionClose(int timeout) throws InterruptedException {
        this.waitFor(3);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setWebSocketClosingTimeout(timeout)).webSocketHandler(ws -> {
            long now = System.currentTimeMillis();
            ws.endHandler(v -> this.fail());
            ws.exceptionHandler(ignore -> this.complete());
            ws.closeHandler(v -> {
                long elapsed = System.currentTimeMillis() - now;
                this.assertTrue((long)timeout <= elapsed && elapsed < 5000L);
                this.complete();
            });
            ws.close();
        });
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        HttpClientAgent client = this.vertx.createHttpClient();
        this.handshake((HttpClient)client, (Handler<HttpClientRequest>)((Handler)req -> req.send().onComplete(this.onSuccess(resp -> {
            this.assertEquals(101L, resp.statusCode());
            Http1xClientConnection conn = (Http1xClientConnection)req.connection();
            NetSocketInternal soi = conn.toNetSocket();
            soi.channelHandlerContext().pipeline().addBefore("handler", "encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
            soi.channelHandlerContext().pipeline().addBefore("handler", "decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, false, 1000));
            soi.closeHandler(v -> this.complete());
        }))));
        this.await();
    }

    @Test
    public void testCloseServer() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(socket -> socket.textMessageHandler(msg -> this.server.close()));
        this.awaitFuture(this.server.listen());
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.writeTextMessage("ping");
            AtomicBoolean closeFrameReceived = new AtomicBoolean();
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    closeFrameReceived.set(true);
                }
            });
            ws.endHandler(v -> {
                this.assertTrue(closeFrameReceived.get());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testCloseClient() throws InterruptedException {
        this.client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            AtomicBoolean closeFrameReceived = new AtomicBoolean();
            ws.frameHandler(frame -> {
                if (frame.isClose()) {
                    closeFrameReceived.set(true);
                }
            });
            ws.endHandler(v -> {
                this.assertTrue(closeFrameReceived.get());
                this.testComplete();
            });
        });
        this.awaitFuture(this.server.listen());
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> this.client.close()));
        this.await();
    }

    @Test
    public void testReportProtocolViolationOnClient() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).requestHandler(req -> this.getUpgradedNetSocket((HttpServerRequest)req, "/some/path", null).onComplete(this.onSuccess(sock -> {
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)8).appendByte((byte)0);
            sock.write((Object)buff);
        })));
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/some/path").setVersion(WebSocketVersion.V13);
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v1 -> this.client.connect(options).onComplete(this.onSuccess(ws -> {
            AtomicReference failure = new AtomicReference();
            ws.closeHandler(v2 -> {
                this.assertNotNull(failure.get());
                this.testComplete();
            });
            ws.exceptionHandler(failure::set);
        })));
        this.await();
    }

    @Test
    public void testReportProtocolViolationOnServer() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            AtomicReference failure = new AtomicReference();
            ws.closeHandler(v -> {
                this.assertNotNull(failure.get());
                this.testComplete();
            });
            ws.exceptionHandler(failure::set);
        });
        this.awaitFuture(this.server.listen());
        HttpClientAgent client = this.vertx.createHttpClient();
        this.handshake((HttpClient)client, (Handler<HttpClientRequest>)((Handler)req -> req.connect().onComplete(this.onSuccess(resp -> {
            this.assertEquals(101L, resp.statusCode());
            NetSocket sock = resp.netSocket();
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)8).appendByte((byte)0);
            sock.write((Object)buff);
        }))));
        this.await();
    }

    @Test
    public void testServerWebSocketShouldBeClosedWhenTheClosedHandlerIsCalled() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)ws);
            sender.send();
            ws.closeHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.testComplete();
                }
            });
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.vertx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> this.vertx.setTimer(1000L, id -> ws.close()))));
        this.await();
    }

    @Test
    public void testClientWebSocketShouldBeClosedWhenTheClosedHandlerIsCalled() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> this.vertx.setTimer(1000L, id -> ws.close()));
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)ws);
            sender.send();
            ws.closeHandler(v -> {
                Throwable failure = sender.close();
                if (failure != null) {
                    this.fail(failure);
                } else {
                    this.testComplete();
                }
            });
        }));
        this.await();
    }

    @Test
    public void testDontReceiveMessagerAfterCloseHandlerCalled() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            boolean[] closed = new boolean[1];
            ws.handler(msg -> {
                if (closed[0]) {
                    this.fail("Should not receive a message after close handler callback");
                }
            });
            ws.closeHandler(v -> {
                closed[0] = true;
                this.vertx.setTimer(10L, id -> this.testComplete());
            });
            this.vertx.setTimer(500L, id -> {
                while (!ws.writeQueueFull()) {
                    ws.write((Object)TestUtils.randomBuffer(1000));
                }
                ws.close();
            });
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
            CheckingSender sender = new CheckingSender(this.vertx.getOrCreateContext(), (WriteStream<Buffer>)ws);
            ws.closeHandler(v -> sender.close());
            sender.send();
        }));
        this.await();
    }

    @Test
    public void testNoRequestHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.createHttpServer().webSocketHandler(ws -> this.fail()).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        HttpClientAgent client = this.vertx.createHttpClient();
        client.request(new RequestOptions().setHost("localhost").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT))).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> resp.endHandler(v -> {
            this.assertEquals(400L, resp.statusCode());
            this.testComplete();
        })))));
        this.await();
    }

    @Test
    public void testPausedDuringClose() throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            AtomicBoolean paused = new AtomicBoolean(true);
            ws.pause();
            ws.closeHandler(v1 -> {
                paused.set(false);
                this.vertx.runOnContext(v2 -> ws.resume());
            });
            ws.endHandler(v -> {
                this.assertFalse(paused.get());
                this.testComplete();
            });
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> ws.close()));
        this.await();
    }

    @Test
    public void testPausedBeforeClosed() throws InterruptedException {
        this.waitFor(2);
        Buffer expected = TestUtils.randomBuffer(128);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            AtomicBoolean paused = new AtomicBoolean(true);
            ws.pause();
            ws.closeHandler(v1 -> {
                paused.set(false);
                this.vertx.runOnContext(v2 -> ws.resume());
            });
            ws.handler(buffer -> {
                this.assertFalse(paused.get());
                this.assertEquals(expected, buffer);
                this.complete();
            });
            ws.endHandler(v -> {
                this.assertFalse(paused.get());
                this.complete();
            });
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
            ws.write((Object)expected);
            ws.close();
        }));
        this.await();
    }

    @Test
    public void testContext() throws Exception {
        int num = 10;
        this.waitFor(num);
        Context serverCtx = this.vertx.getOrCreateContext();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {
            Context current = Vertx.currentContext();
            this.assertSameEventLoop(serverCtx, current);
            ws.handler(buff -> this.assertEquals(current, Vertx.currentContext()));
            ws.frameHandler(frame -> this.assertEquals(current, Vertx.currentContext()));
            ws.closeHandler(v -> this.assertEquals(current, Vertx.currentContext()));
            ws.endHandler(v -> {
                this.assertEquals(current, Vertx.currentContext());
                this.complete();
            });
        });
        CountDownLatch latch = new CountDownLatch(1);
        serverCtx.runOnContext(v -> this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(s -> latch.countDown())));
        this.awaitLatch(latch);
        this.client = this.vertx.createWebSocketClient();
        for (int i = 0; i < num; ++i) {
            Context clientCtx = this.vertx.getOrCreateContext();
            clientCtx.runOnContext(v -> this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
                this.assertEquals(clientCtx, Vertx.currentContext());
                ws.write((Object)Buffer.buffer((String)"data"));
                ws.pongHandler(pong -> {
                    this.assertEquals(clientCtx, Vertx.currentContext());
                    ws.close();
                });
                ws.writePing(Buffer.buffer((String)"ping"));
            })));
        }
        this.await();
    }

    private void fillQueue(WebSocketBase ws, Handler<Void> onFull) {
        if (!ws.writeQueueFull()) {
            ws.writeFrame(WebSocketFrame.textFrame((String)TestUtils.randomAlphaString(512), (boolean)true));
            this.vertx.runOnContext(v -> this.fillQueue(ws, onFull));
        } else {
            onFull.handle(null);
        }
    }

    @Test
    public void testDrainServerWebSocket() throws InterruptedException {
        Promise resume = Promise.promise();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> this.fillQueue((WebSocketBase)ws, (Handler<Void>)((Handler)v1 -> {
            resume.complete();
            ws.drainHandler(v2 -> this.testComplete());
        })));
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT));
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
            ws.pause();
            resume.future().onComplete(this.onSuccess(v2 -> ws.resume()));
        }));
        this.await();
    }

    @Test
    public void testDrainClientWebSocket() throws InterruptedException {
        this.testDrainClientWebSocket(this.vertx.getOrCreateContext());
    }

    @Test
    public void testDrainClientWorkerWebSocket() throws InterruptedException {
        this.testDrainClientWebSocket((Context)((VertxInternal)this.vertx).createWorkerContext());
    }

    private void testDrainClientWebSocket(Context ctx) throws InterruptedException {
        Promise resume = Promise.promise();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {
            ws.pause();
            resume.future().onComplete(this.onSuccess(v2 -> ws.resume()));
        });
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT));
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
            while (!ws.writeQueueFull()) {
                ws.writeFrame(WebSocketFrame.textFrame((String)TestUtils.randomAlphaString(512), (boolean)true));
            }
            ws.drainHandler(v -> this.testComplete());
            resume.complete();
        }));
        this.await();
    }

    @Test
    public void testWriteHandlerSuccess() throws InterruptedException {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> ws.handler(buff -> this.complete()));
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT));
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> ws.write((Object)Buffer.buffer((String)"foo")).onComplete(this.onSuccess(v -> this.complete()))));
        this.await();
    }

    @Test
    public void testWriteHandlerFailure() throws InterruptedException {
        this.server = this.vertx.createHttpServer().webSocketHandler(ServerWebSocket::pause);
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT));
        Buffer buffer = TestUtils.randomBuffer(1024);
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(this.onSuccess(ws -> {
            while (!ws.writeQueueFull()) {
                ws.write((Object)buffer);
            }
            ws.write((Object)buffer).onComplete(this.onFailure(err -> this.testComplete()));
            ((WebSocketInternal)ws).channelHandlerContext().close();
        }));
        this.await();
    }

    @Test
    public void testCloseClientImmediately() throws InterruptedException {
        WebSocketClient client = this.vertx.createWebSocketClient();
        this.server = this.vertx.createHttpServer().requestHandler(req -> {});
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT));
        client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/someuri").onComplete(ar -> {
            if (ar.succeeded()) {
                this.fail();
            } else {
                this.testComplete();
            }
        });
        client.close();
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAProxy() throws Exception {
        this.waitFor(2);
        SocketAddress remote = SocketAddress.inetSocketAddress((int)56324, (String)"192.168.0.1");
        SocketAddress local = SocketAddress.inetSocketAddress((int)443, (String)"192.168.0.11");
        Buffer header = HAProxy.createVersion1TCP4ProtocolHeader(remote, local);
        HAProxy proxy = new HAProxy("localhost", HttpTestBase.DEFAULT_HTTP_PORT, header);
        proxy.start(this.vertx);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setUseProxyProtocol(true)).webSocketHandler(ws -> {
            this.assertEquals(remote, ws.remoteAddress());
            this.assertEquals(local, ws.localAddress());
            ws.handler(buff -> this.complete());
        });
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(proxy.getPort(), proxy.getHost(), "/someuri").onComplete(this.onSuccess(ws -> ws.write((Object)Buffer.buffer((String)"foo")).onComplete(this.onSuccess(v -> this.complete()))));
        try {
            this.await();
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void testWebSocketDisablesALPN() throws InterruptedException {
    }

    @Test
    public void testSetOriginHeaderV13() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V13, true, "http://www.example.com", HttpHeaders.ORIGIN, "http://www.example.com");
    }

    @Test
    public void testEnableOriginHeaderV13() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V13, true, null, HttpHeaders.ORIGIN, "http://" + HttpTestBase.DEFAULT_HTTP_HOST_AND_PORT);
    }

    @Test
    public void testDisableOriginHeaderV13() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V13, false, null, HttpHeaders.ORIGIN, null);
    }

    @Test
    public void testSetOriginHeaderV08() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V08, true, "http://www.example.com", (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://www.example.com");
    }

    @Test
    public void testEnableOriginHeaderV08() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V08, true, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://" + HttpTestBase.DEFAULT_HTTP_HOST_AND_PORT);
    }

    @Test
    public void testDisableOriginHeaderV08() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V08, false, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, null);
    }

    @Test
    public void testSetOriginHeaderV07() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V07, true, "http://www.example.com", (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://www.example.com");
    }

    @Test
    public void testEnableOriginHeaderV07() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V07, true, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, "http://" + HttpTestBase.DEFAULT_HTTP_HOST_AND_PORT);
    }

    @Test
    public void testDisableOriginHeaderV07() throws InterruptedException {
        this.testOriginHeader(WebSocketVersion.V07, false, null, (CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, null);
    }

    private void testOriginHeader(WebSocketVersion version, boolean allow, String origin, CharSequence header, String expected) throws InterruptedException {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost"));
        this.server.webSocketHandler(ws -> {
            if (expected != null) {
                this.assertEquals(expected, ws.headers().get(header));
            } else {
                this.assertNull(ws.headers().get(header));
            }
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        WebSocketConnectOptions options = new WebSocketConnectOptions().setVersion(version).setAllowOriginHeader(allow).setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/");
        if (origin != null) {
            options.addHeader(header, (CharSequence)origin);
        }
        this.client.connect(options).onComplete(this.onSuccess(ws -> this.testComplete()));
        this.await();
    }

    @Test
    public void testWriteHandlerIdNullByDefault() throws Exception {
        String path = "/some/path";
        Buffer hello = Buffer.buffer((String)"hello");
        Buffer bye = Buffer.buffer((String)"bye");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).webSocketHandler(ws -> {
            this.assertNull(ws.textHandlerID());
            this.assertNull(ws.binaryHandlerID());
            ws.binaryMessageHandler(data -> {
                this.assertEquals(hello, data);
                ws.writeBinaryMessage(bye).eventually(() -> ((ServerWebSocket)ws).close());
            });
        });
        this.waitFor(2);
        this.awaitFuture(this.server.listen());
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path);
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(options).onComplete(this.onSuccess(ws -> {
            this.assertNull(ws.textHandlerID());
            this.assertNull(ws.binaryHandlerID());
            ws.closeHandler(v -> this.complete()).binaryMessageHandler(data -> {
                this.assertEquals(bye, data);
                this.complete();
            }).write((Object)hello);
        }));
        this.await();
    }

    @Test
    public void testFanoutWithBinary() throws Exception {
        this.testFanout(Buffer.buffer((String)"hello"), Buffer.buffer((String)"bye"), WebSocketBase::binaryHandlerID, WebSocketBase::binaryMessageHandler, WebSocketBase::writeBinaryMessage);
    }

    @Test
    public void testFanoutWithText() throws Exception {
        this.testFanout("hello", "bye", WebSocketBase::textHandlerID, WebSocketBase::textMessageHandler, WebSocketBase::writeTextMessage);
    }

    private <T> void testFanout(T hello, T bye, Function<WebSocketBase, String> handlerIDGetter, BiConsumer<WebSocketBase, Handler<T>> messageHandlerSetter, BiFunction<WebSocket, T, Future<Void>> messageWriter) throws Exception {
        String path = "/some/path";
        int numConnections = 10;
        ConcurrentHashMap.KeySetView connections = ConcurrentHashMap.newKeySet();
        HttpServerOptions httpServerOptions = new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setRegisterWebSocketWriteHandlers(true);
        this.server = this.vertx.createHttpServer(httpServerOptions).webSocketHandler(ws -> {
            String handlerID = (String)handlerIDGetter.apply((WebSocketBase)ws);
            this.assertNotNull(handlerID);
            messageHandlerSetter.accept((WebSocketBase)ws, data -> {
                this.assertEquals(hello, data);
                connections.add(handlerID);
                if (connections.size() == numConnections) {
                    for (String actorID : connections) {
                        this.vertx.eventBus().send(actorID, bye);
                    }
                }
            });
        });
        this.waitFor(numConnections);
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        for (int i = 0; i < numConnections; ++i) {
            WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI(path);
            this.client.connect(options).onComplete(this.onSuccess(ws -> {
                messageHandlerSetter.accept((WebSocketBase)ws, data -> {
                    this.assertEquals(bye, data);
                    this.complete();
                });
                messageWriter.apply((WebSocket)ws, hello);
            }));
        }
        this.await();
    }

    @Test
    public void testConnect() throws Exception {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost")).webSocketHandler(ws -> {
            ws.write((Object)Buffer.buffer((String)"Ping"));
            ws.handler(buff -> ws.close());
        });
        this.awaitFuture(this.server.listen());
        this.client = this.vertx.createWebSocketClient();
        ClientWebSocket ws2 = this.client.webSocket();
        WebSocketConnectOptions options = new WebSocketConnectOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost");
        ws2.handler(buff -> {
            ws2.write(buff);
            ws2.connect(options).onComplete(this.onFailure(err -> this.complete()));
        }).closeHandler(v -> this.complete()).connect(options).onComplete(this.onSuccess(v -> {}));
        this.await();
    }

    @Test
    public void testServerWebSocketExceptionHandlerIsCalled() throws InterruptedException {
        this.waitFor(2);
        AtomicBoolean failed = new AtomicBoolean();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT).setHost("localhost")).exceptionHandler(t -> this.fail()).connectionHandler(connection -> connection.exceptionHandler(t -> this.fail())).webSocketHandler(ws -> {
            ws.endHandler(v -> this.fail());
            ws.closeHandler(v -> this.complete());
            ws.exceptionHandler(t -> {
                if (failed.compareAndSet(false, true)) {
                    this.complete();
                }
            });
        });
        this.awaitFuture(this.server.listen());
        this.vertx.createWebSocketClient().connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onSuccess(ws -> ws.close((short)1004));
        this.await();
    }

    @Test
    public void testClientShutdownClose() throws Exception {
        final int num = 4;
        this.waitFor(num);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> ws.handler(buff -> {
            latch2.countDown();
            try {
                latch1.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.fail(e);
            }
        }));
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setMaxConnections(1));
        final CountDownLatch failures = new CountDownLatch(num - 1);
        final CountDownLatch closure = new CountDownLatch(1);
        final CountDownLatch shutdown = new CountDownLatch(1);
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                int i = 0;
                while (i < num) {
                    int val = i++;
                    WebSocketTest.this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(ar -> {
                        if (val == 0) {
                            WebSocketTest.this.assertTrue(ar.succeeded());
                            WebSocket ws = (WebSocket)ar.result();
                            ws.write((Object)Buffer.buffer((String)"ping"));
                            ws.closeHandler(v -> closure.countDown());
                            ws.shutdownHandler(v -> shutdown.countDown());
                        } else {
                            failures.countDown();
                        }
                    });
                }
            }
        });
        this.awaitLatch(latch2);
        Future fut = this.client.shutdown(2L, TimeUnit.SECONDS);
        this.awaitLatch(failures);
        latch1.countDown();
        this.awaitLatch(closure);
        this.awaitLatch(shutdown);
        this.awaitFuture(fut);
    }

    @Test
    public void testServerShutdownClose() throws Exception {
        long now = System.currentTimeMillis();
        AtomicInteger shutdown = new AtomicInteger();
        AtomicInteger closure = new AtomicInteger();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> ws.handler(buff -> {
            ws.write((Object)Buffer.buffer((String)"pong"));
            ws.shutdownHandler(v -> {
                this.assertTrue(System.currentTimeMillis() - now < 1000L);
                shutdown.incrementAndGet();
            });
            ws.closeHandler(v -> {
                this.assertTrue(System.currentTimeMillis() - now > 2000L);
                closure.incrementAndGet();
            });
        }));
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        this.client = this.vertx.createWebSocketClient();
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        final AtomicReference wsRef = new AtomicReference();
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() {
                WebSocketTest.this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(WebSocketTest.this.onSuccess(ws -> {
                    wsRef.set(ws);
                    ws.handler(buff -> {
                        latch2.countDown();
                        try {
                            latch1.await(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            WebSocketTest.this.fail(e);
                        }
                    });
                    ws.write((Object)Buffer.buffer((String)"ping"));
                }));
            }
        });
        this.awaitLatch(latch2);
        Future fut = this.server.shutdown(2L, TimeUnit.SECONDS);
        this.awaitFuture(fut);
        long elapsed = System.currentTimeMillis() - now;
        this.assertTrue(elapsed >= 2000L);
        this.assertTrue(elapsed < 4000L);
        latch1.countDown();
        WebSocketTest.assertWaitUntil(() -> shutdown.get() == 1);
        WebSocketTest.assertWaitUntil(() -> closure.get() == 1);
    }

    @Test
    public void testServerShutdownOverride() throws Exception {
        this.waitFor(2);
        long now = System.currentTimeMillis();
        this.server = this.vertx.createHttpServer().webSocketHandler(ws -> {
            ws.shutdownHandler(v -> this.vertx.setTimer(200L, id -> ws.close()));
            ws.closeHandler(v -> {
                long d = System.currentTimeMillis() - now;
                this.assertTrue(d >= 200L);
                this.assertTrue(d <= 2000L);
                this.complete();
            });
            ws.handler(buff -> ws.shutdown(10L, TimeUnit.SECONDS));
        });
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        this.client = this.vertx.createWebSocketClient();
        AtomicReference wsRef = new AtomicReference();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.write((Object)Buffer.buffer((String)"ping"));
            ws.closeHandler(v -> this.complete());
        }));
        this.await();
    }

    @Test
    public void testCustomResponseHeadersBeforeUpgrade() throws InterruptedException {
        String path = "/some/path";
        String message = "here is some text data";
        String headerKey = "custom";
        String headerValue = "value";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(HttpTestBase.DEFAULT_HTTP_PORT)).requestHandler(req -> {
            req.response().headers().set(headerKey, headerValue);
            req.toWebSocket().onComplete(this.onSuccess(ws -> ws.writeFinalTextFrame(message)));
        });
        this.awaitFuture(this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        this.client = this.vertx.createWebSocketClient();
        this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", path).onComplete(this.onSuccess(ws -> {
            this.assertTrue(ws.headers().contains(headerKey));
            this.assertEquals(headerValue, ws.headers().get(headerKey));
            ws.handler(buff -> {
                this.assertEquals(message, buff.toString("UTF-8"));
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testPoolShouldNotStarveOnConnectError() throws Exception {
        this.server = this.vertx.createHttpServer();
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        AtomicInteger accepted = new AtomicInteger();
        this.server.webSocketHandler(ws -> {
            ws.shutdownHandler(v -> shutdownLatch.countDown());
            this.assertTrue(accepted.getAndIncrement() == 0);
        });
        this.server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").toCompletionStage().toCompletableFuture().get();
        int maxConnections = 5;
        this.client = this.vertx.createWebSocketClient(new WebSocketClientOptions().setMaxConnections(maxConnections).setConnectTimeout(4000));
        Future wsFut = this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").andThen(this.onSuccess(v -> {}));
        wsFut.toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        this.server.shutdown(30L, TimeUnit.SECONDS);
        this.awaitLatch(shutdownLatch);
        int num = maxConnections + 10;
        CountDownLatch latch = new CountDownLatch(num);
        for (int i = 0; i < num; ++i) {
            this.client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(ar -> latch.countDown());
        }
        this.awaitLatch(latch, 10L, TimeUnit.SECONDS);
    }

    private /* synthetic */ void lambda$testInvalidHandshake$87(BiConsumer requestProvider, HttpClient client, int expectedStatus, HttpServer s) {
        requestProvider.accept(client, this.onSuccess(resp -> {
            this.assertEquals(expectedStatus, resp.statusCode());
            resp.endHandler(v1 -> client.request(new RequestOptions().setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost")).onComplete(this.onSuccess(req2 -> req2.send().onComplete(this.onSuccess(resp2 -> resp2.endHandler(v2 -> this.testComplete()))))));
        }));
    }

    private static class SocketMessages {
        private final List<String> receivedMessages;
        private final List<Throwable> receivedExceptions;

        public SocketMessages(List<String> receivedMessages, List<Throwable> receivedExceptions) {
            this.receivedMessages = receivedMessages;
            this.receivedExceptions = receivedExceptions;
        }

        public List<String> getReceivedMessages() {
            return this.receivedMessages;
        }

        public List<Throwable> getReceivedExceptions() {
            return this.receivedExceptions;
        }
    }
}

