/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.tests.http.compression.HttpCompressionTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class GzipHttpCompressionTestBase
extends HttpCompressionTest {
    private int compressionLevel;

    @Parameterized.Parameters(name="{index}: compressionLevel = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({1}, {6}, {9});
    }

    public GzipHttpCompressionTestBase(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    protected String encoding() {
        return "gzip";
    }

    @Override
    protected MessageToByteEncoder<ByteBuf> encoder() {
        return new JdkZlibEncoder(ZlibWrapper.GZIP, this.compressionLevel);
    }

    @Override
    protected void configureServerCompression(HttpServerOptions options) {
        options.setCompressionSupported(true).setCompressionLevel(this.compressionLevel);
    }
}

