/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.tests.http.compression.HttpCompressionTest;
import org.junit.Test;

public class Http1xCompressionThresholdTest
extends HttpCompressionTest {
    @Override
    protected String encoding() {
        return "gzip";
    }

    @Override
    protected MessageToByteEncoder<ByteBuf> encoder() {
        return new JdkZlibEncoder(ZlibWrapper.GZIP);
    }

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return new HttpServerOptions().setPort(DEFAULT_HTTP_PORT).setHost("localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return new HttpClientOptions().setDefaultPort(DEFAULT_HTTP_PORT).setDefaultHost("localhost");
    }

    @Override
    protected void configureServerCompression(HttpServerOptions options) {
        options.setCompressionSupported(true);
    }

    @Test
    public void testServerCompressionBelowThreshold() throws Exception {
        HttpServerOptions httpServerOptions = this.createBaseServerOptions();
        this.configureServerCompression(httpServerOptions);
        httpServerOptions.setCompressionContentSizeThreshold("/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */".length() * 2);
        this.doTest(httpServerOptions, this.onSuccess(resp -> {
            this.assertNull(resp.getHeader(HttpHeaders.CONTENT_ENCODING));
            resp.body().onComplete(this.onSuccess(responseBuffer -> {
                String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
                this.assertEquals("/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */", responseBody);
                this.testComplete();
            }));
        }));
    }

    @Test
    public void testServerCompressionAboveThreshold() throws Exception {
        HttpServerOptions httpServerOptions = this.createBaseServerOptions();
        this.configureServerCompression(httpServerOptions);
        httpServerOptions.setCompressionContentSizeThreshold("/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */".length() / 2);
        this.doTest(httpServerOptions, this.onSuccess(resp -> {
            this.assertEquals(this.encoding(), resp.getHeader(HttpHeaders.CONTENT_ENCODING));
            resp.body().onComplete(this.onSuccess(responseBuffer -> {
                this.assertEquals(StringUtil.toHexString((byte[])this.compressedTestString.getBytes()), StringUtil.toHexString((byte[])responseBuffer.getBytes()));
                this.testComplete();
            }));
        }));
    }

    private void doTest(HttpServerOptions httpServerOptions, Handler<AsyncResult<HttpClientResponse>> handler) throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(httpServerOptions);
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            req.response().end(Buffer.buffer((String)"/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */").toString(CharsetUtil.UTF_8));
        });
        this.startServer();
        this.client.request(new RequestOptions()).onComplete(this.onSuccess(req -> {
            req.putHeader(HttpHeaders.ACCEPT_ENCODING, (CharSequence)this.encoding());
            req.send().onComplete(handler);
        }));
        this.await();
    }
}

