/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdEncoder;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.tests.http.compression.HttpCompressionTest;
import org.junit.Assert;
import org.junit.BeforeClass;

public class Http1xZstdCompressionTest
extends HttpCompressionTest {
    @BeforeClass
    public static void zstdLibraryIsAvailable() {
        Assert.assertTrue((boolean)Zstd.isAvailable());
    }

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return new HttpServerOptions().setPort(DEFAULT_HTTP_PORT).setHost("localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return new HttpClientOptions().setDefaultPort(DEFAULT_HTTP_PORT).setDefaultHost("localhost");
    }

    @Override
    protected MessageToByteEncoder<ByteBuf> encoder() {
        return new ZstdEncoder();
    }

    @Override
    protected String encoding() {
        return "zstd";
    }

    @Override
    protected void configureServerCompression(HttpServerOptions options) {
        options.setCompressionSupported(true).addCompressor((CompressionOptions)StandardCompressionOptions.zstd());
    }
}

