/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.test.http.HttpTestBase;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Queue;
import java.util.function.Function;
import org.junit.Test;

public abstract class HttpCompressionTest
extends HttpTestBase {
    protected static final String COMPRESS_TEST_STRING = "/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */";
    protected Buffer compressedTestString;

    protected abstract String encoding();

    protected abstract MessageToByteEncoder<ByteBuf> encoder();

    protected void configureServerCompression(HttpServerOptions options) {
    }

    protected Buffer compress(Buffer src) {
        ByteBuf buf;
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addFirst(new ChannelHandler[]{this.encoder()});
        channel.writeAndFlush((Object)Unpooled.copiedBuffer((ByteBuf)((BufferInternal)src).getByteBuf()));
        channel.close();
        Queue messages = channel.outboundMessages();
        Buffer dst = Buffer.buffer();
        while ((buf = (ByteBuf)messages.poll()) != null) {
            byte[] tmp = new byte[buf.readableBytes()];
            buf.readBytes(tmp);
            buf.release();
            dst.appendBytes(tmp);
        }
        return dst;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.compressedTestString = this.compress(Buffer.buffer((String)COMPRESS_TEST_STRING));
    }

    @Test
    public void testSkipEncoding() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setCompressionSupported(true));
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            req.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY).end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(CharsetUtil.UTF_8));
        });
        this.startServer();
        this.client.request(new RequestOptions()).onComplete(this.onSuccess(req -> {
            req.putHeader(HttpHeaders.ACCEPT_ENCODING, (CharSequence)this.encoding());
            req.send().onComplete(this.onSuccess(resp -> {
                this.assertNull(resp.getHeader(HttpHeaders.CONTENT_ENCODING));
                resp.body().onComplete(this.onSuccess(responseBuffer -> {
                    String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
                    this.assertEquals(COMPRESS_TEST_STRING, responseBody);
                    this.testComplete();
                }));
            }));
        }));
        this.await();
    }

    @Test
    public void testServerStandardCompression() throws Exception {
        this.testServerStandardCompression(resp -> resp.end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(StandardCharsets.UTF_8)));
    }

    @Test
    public void testServerStandardCompressionSendFile() throws Exception {
        File f = File.createTempFile("vertx", ".txt");
        Files.write(f.toPath(), COMPRESS_TEST_STRING.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        f.deleteOnExit();
        this.testServerStandardCompression(resp -> resp.sendFile(f.getAbsolutePath()));
    }

    private void testServerStandardCompression(Function<HttpServerResponse, Future<?>> sender) throws Exception {
        this.waitFor(2);
        this.server.close();
        HttpServerOptions options = this.createBaseServerOptions();
        this.configureServerCompression(options);
        this.server = this.vertx.createHttpServer(options);
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            ((Future)sender.apply(req.response())).onComplete(this.onSuccess(v -> this.complete()));
        });
        this.startServer();
        this.client.request(new RequestOptions().addHeader(HttpHeaders.ACCEPT_ENCODING, (CharSequence)this.encoding())).onComplete(this.onSuccess(req -> req.send().flatMap(HttpClientResponse::body).onComplete(this.onSuccess(body -> {
            this.assertEquals(StringUtil.toHexString((byte[])this.compressedTestString.getBytes()), StringUtil.toHexString((byte[])body.getBytes()));
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testServerDecompression() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setDecompressionSupported(true));
        this.server.requestHandler(req -> req.body().onComplete(this.onSuccess(body -> {
            this.assertEquals(COMPRESS_TEST_STRING, body.toString());
            req.response().end();
        })));
        this.startServer();
        this.client.request(new RequestOptions().setMethod(HttpMethod.PUT).putHeader(HttpHeaders.CONTENT_ENCODING, (CharSequence)this.encoding())).onComplete(this.onSuccess(req -> req.send(this.compressedTestString).flatMap(HttpClientResponse::body).onComplete(this.onSuccess(body -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testClientDecompression() throws Exception {
        this.server.requestHandler(req -> {
            this.assertNotNull(req.headers().get(HttpHeaders.ACCEPT_ENCODING));
            req.response().putHeader(HttpHeaders.CONTENT_ENCODING, (CharSequence)this.encoding()).end(this.compressedTestString);
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setDecompressionSupported(true));
        this.client.request(new RequestOptions()).onComplete(this.onSuccess(req -> req.send().flatMap(HttpClientResponse::body).onComplete(this.onSuccess(body -> {
            this.assertEquals(COMPRESS_TEST_STRING, body.toString());
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testClientAcceptEncoding() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        this.server.requestHandler(req -> {
            String acceptEncoding = req.headers().get(HttpHeaders.ACCEPT_ENCODING);
            this.assertTrue("Expects accept-encoding '" + acceptEncoding + "' to contain " + this.encoding(), acceptEncoding.contains(this.encoding()));
            req.response().end();
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setDecompressionSupported(true));
        this.client.request(new RequestOptions()).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> resp.end().onComplete(this.onSuccess(v -> this.testComplete()))))));
        this.await();
    }
}

