/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.connection;

import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnectOptions;
import io.vertx.core.net.Address;
import io.vertx.tests.http.connection.HttpClientConnectionTest;
import org.junit.Test;

public class Http1xClientConnectionTest
extends HttpClientConnectionTest {
    @Test
    public void testResetStreamBeforeSend() throws Exception {
        this.server.requestHandler(req -> req.response().end("Hello World"));
        this.startServer(this.testAddress);
        this.client.connect(new HttpConnectOptions().setServer((Address)this.testAddress)).onComplete(this.onSuccess(conn -> conn.request().onComplete(this.onSuccess(req -> {
            req.reset();
            this.vertx.runOnContext(v -> conn.request().compose(req2 -> req2.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
                this.assertEquals("Hello World", body.toString());
                this.testComplete();
            })));
        }))));
        this.await();
    }

    @Test
    public void testResetStreamRequestSent() throws Exception {
        this.waitFor(2);
        Promise continuation = Promise.promise();
        this.server.requestHandler(req -> continuation.complete());
        this.startServer(this.testAddress);
        HttpConnectOptions connect = new HttpConnectOptions().setServer((Address)this.testAddress);
        this.client.connect(connect).onComplete(this.onSuccess(conn -> {
            conn.closeHandler(v -> this.complete());
            conn.request().onComplete(this.onSuccess(req -> {
                req.send().onComplete(this.onFailure(err -> this.complete()));
                continuation.future().onSuccess(v -> req.reset());
            }));
        }));
        this.await();
    }

    @Test
    public void testServerConnectionClose() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.response().putHeader("Connection", "close").end("Hello World"));
        this.startServer(this.testAddress);
        this.client.connect(new HttpConnectOptions().setServer((Address)this.testAddress)).onComplete(this.onSuccess(conn -> {
            conn.closeHandler(v -> this.complete());
            conn.request().compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
                this.assertEquals("Hello World", body.toString());
                this.complete();
            }));
        }));
        this.await();
    }
}

