/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.connection;

import io.vertx.core.Expectation;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnectOptions;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.net.Address;
import io.vertx.test.core.AssertExpectations;
import io.vertx.test.http.HttpTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public abstract class HttpClientConnectionTest
extends HttpTestBase {
    protected HttpClientInternal client;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = (HttpClientInternal)((HttpTestBase)this).client;
    }

    @Test
    public void testGet() throws Exception {
        this.server.requestHandler(req -> req.response().end("Hello World"));
        this.startServer(this.testAddress);
        this.client.connect(new HttpConnectOptions().setServer((Address)this.testAddress).setHost(this.requestOptions.getHost()).setPort(this.requestOptions.getPort())).compose(HttpClient::request).compose(request -> request.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
            this.assertEquals("Hello World", body.toString());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStreamGet() throws Exception {
        this.server.requestHandler(req -> req.response().end("Hello World"));
        this.startServer(this.testAddress);
        HttpConnectOptions connect = new HttpConnectOptions().setServer((Address)this.testAddress).setHost(this.requestOptions.getHost()).setPort(this.requestOptions.getPort());
        this.client.connect(connect).compose(conn -> conn.request().compose(req -> req.send().compose(HttpClientResponse::body).expecting(AssertExpectations.that(body -> this.assertEquals("Hello World", body.toString()))))).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testConnectionClose() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> req.connection().close());
        this.startServer(this.testAddress);
        HttpConnectOptions connect = new HttpConnectOptions().setServer((Address)this.testAddress).setHost(this.requestOptions.getHost()).setPort(this.requestOptions.getPort());
        this.client.connect(connect).onComplete(this.onSuccess(conn -> {
            conn.closeHandler(v -> this.complete());
            conn.request().compose(req -> req.send().compose(HttpClientResponse::body)).onComplete(this.onFailure(err -> this.complete()));
        }));
        this.await();
    }

    @Test
    public void testRequestQueuing() throws Exception {
        int num = 1;
        this.server.requestHandler(req -> req.response().end("Echo:" + req.getHeader("id")));
        this.startServer(this.testAddress);
        List collected = Collections.synchronizedList(new ArrayList());
        this.client.connect(new HttpConnectOptions().setServer((Address)this.testAddress).setHost(this.requestOptions.getHost()).setPort(this.requestOptions.getPort())).onComplete(this.onSuccess(conn -> {
            int concurrency = (int)conn.maxActiveStreams();
            int i = 0;
            while (i < concurrency + num) {
                int val = i++;
                conn.request().compose(req -> req.putHeader("id", "" + val).send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(body -> {
                    collected.add(body.toString());
                    if (val == concurrency + num - 1) {
                        List expected = IntStream.range(0, concurrency + num).mapToObj(idx -> "Echo:" + idx).collect(Collectors.toList());
                        this.assertEquals(expected, collected);
                        this.testComplete();
                    }
                }));
            }
        }));
        this.await();
    }
}

