/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.fileupload;

import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientForm;
import io.vertx.core.http.ClientMultipartForm;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamResetException;
import io.vertx.test.core.TestUtils;
import io.vertx.test.http.HttpTestBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HttpClientFileUploadTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void testFormUrlEncoded() throws Exception {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                this.assertEquals("param1_value", req.getFormAttribute("param1"));
                req.response().end();
            });
        });
        this.startServer(this.testAddress);
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("param1", "param1_value");
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).compose(req -> req.send(ClientForm.form((MultiMap)form)).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFormUrlEncodedWithCharset() throws Exception {
        String str = "\u00f8";
        String expected = URLDecoder.decode(URLEncoder.encode(str, StandardCharsets.ISO_8859_1.name()), StandardCharsets.UTF_8.name());
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                String val = req.getFormAttribute("param1");
                this.assertEquals(expected, val);
                req.response().end();
            });
        });
        this.startServer();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("param1", str);
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).compose(req -> req.send(ClientForm.form((MultiMap)form).charset(StandardCharsets.ISO_8859_1)).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFormUrlEncodedUnescaped() throws Exception {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.bodyHandler(body -> {
                this.assertEquals("grant_type=client_credentials&resource=https%3A%2F%2Fmanagement.core.windows.net%2F", body.toString());
                req.response().end();
            });
        });
        this.startServer();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.set("grant_type", "client_credentials").set("resource", "https://management.core.windows.net/");
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).compose(req -> req.send(ClientForm.form((MultiMap)form)).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFormUrlEncodedMultipleHeaders() throws Exception {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                this.assertEquals(Arrays.asList("1", "2"), req.headers().getAll("bla"));
                req.response().end();
            });
        });
        this.startServer();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        this.client.request(new RequestOptions(this.requestOptions).putHeader((CharSequence)"bla", Arrays.asList("1", "2")).setMethod(HttpMethod.POST)).compose(req -> req.send(ClientForm.form((MultiMap)form)).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFormMultipart() throws Exception {
        this.server.requestHandler(req -> {
            this.assertTrue(req.getHeader(HttpHeaders.CONTENT_TYPE).startsWith("multipart/form-data"));
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                this.assertEquals("param1_value", req.getFormAttribute("param1"));
                req.response().end();
            });
        });
        this.startServer();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("param1", "param1_value");
        this.client.request(new RequestOptions(this.requestOptions).putHeader("content-type", "multipart/form-data").setMethod(HttpMethod.POST)).compose(req -> req.send(ClientForm.form((MultiMap)form)).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFormMultipartWithCharset() throws Exception {
        this.server.requestHandler(req -> req.body().onComplete(this.onSuccess(body -> {
            this.assertTrue(body.toString().contains("content-type: text/plain; charset=ISO-8859-1"));
            req.response().end();
        })));
        this.startServer();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("param1", "param1_value");
        this.client.request(new RequestOptions(this.requestOptions).putHeader("content-type", "multipart/form-data").setMethod(HttpMethod.POST)).compose(req -> req.send(ClientForm.form((MultiMap)form).charset(StandardCharsets.ISO_8859_1)).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFileUploadFormMultipart32B() throws Exception {
        this.testFileUploadFormMultipart(32, false);
    }

    @Test
    public void testFileUploadFormMultipart32K() throws Exception {
        this.testFileUploadFormMultipart(32768, false);
    }

    @Test
    public void testFileUploadFormMultipart32M() throws Exception {
        this.testFileUploadFormMultipart(0x2000000, false);
    }

    @Test
    public void testMemoryFileUploadFormMultipart() throws Exception {
        this.testFileUploadFormMultipart(32768, true);
    }

    private void testFileUploadFormMultipart(int size, boolean memory) throws Exception {
        Buffer content = Buffer.buffer((String)TestUtils.randomAlphaString(size));
        Upload upload = memory ? Upload.memoryUpload("test", "test.txt", content) : Upload.fileUpload("test", "test.txt", content);
        ClientMultipartForm form = ClientMultipartForm.multipartForm().attribute("toolkit", "vert.x").attribute("runtime", "jvm");
        this.testFileUploadFormMultipart(form, Collections.singletonList(upload), (req, uploads) -> {
            this.assertEquals("vert.x", req.getFormAttribute("toolkit"));
            this.assertEquals("jvm", req.getFormAttribute("runtime"));
            this.assertEquals(1L, uploads.size());
            this.assertEquals("test", ((Upload)uploads.get((int)0)).name);
            this.assertEquals("test.txt", ((Upload)uploads.get((int)0)).filename);
            this.assertEquals(content, ((Upload)uploads.get((int)0)).data);
        });
    }

    @Test
    public void testFileUploadsFormMultipart() throws Exception {
        Buffer content1 = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        Buffer content2 = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        List<Upload> toUpload = Arrays.asList(Upload.fileUpload("test1", "test1.txt", content1), Upload.fileUpload("test2", "test2.txt", content2));
        ClientMultipartForm form = ClientMultipartForm.multipartForm();
        this.testFileUploadFormMultipart(form, toUpload, (req, uploads) -> {
            this.assertEquals(2L, uploads.size());
            this.assertEquals("test1", ((Upload)uploads.get((int)0)).name);
            this.assertEquals("test1.txt", ((Upload)uploads.get((int)0)).filename);
            this.assertEquals("UTF-8", ((Upload)uploads.get((int)0)).charset);
            this.assertEquals(content1, ((Upload)uploads.get((int)0)).data);
            this.assertEquals("test2", ((Upload)uploads.get((int)1)).name);
            this.assertEquals("test2.txt", ((Upload)uploads.get((int)1)).filename);
            this.assertEquals("UTF-8", ((Upload)uploads.get((int)1)).charset);
            this.assertEquals(content2, ((Upload)uploads.get((int)1)).data);
        });
    }

    @Test
    public void testFileUploadsFormMultipartWithCharset() throws Exception {
        Buffer content = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        List<Upload> toUpload = Collections.singletonList(Upload.fileUpload("test1", "test1.txt", content));
        ClientMultipartForm form = ClientMultipartForm.multipartForm().charset(StandardCharsets.ISO_8859_1);
        this.testFileUploadFormMultipart(form, toUpload, (req, uploads) -> {
            this.assertEquals(1L, uploads.size());
            this.assertEquals("test1", ((Upload)uploads.get((int)0)).name);
            this.assertEquals("test1.txt", ((Upload)uploads.get((int)0)).filename);
            this.assertEquals("ISO-8859-1", ((Upload)uploads.get((int)0)).charset);
        });
    }

    @Test
    public void testFileUploadsSameNameFormMultipart() throws Exception {
        Buffer content1 = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        Buffer content2 = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        List<Upload> toUpload = Arrays.asList(Upload.fileUpload("test", "test1.txt", content1), Upload.fileUpload("test", "test2.txt", content2));
        ClientMultipartForm form = ClientMultipartForm.multipartForm();
        this.testFileUploadFormMultipart(form, toUpload, (req, uploads) -> {
            this.assertEquals(2L, uploads.size());
            this.assertEquals("test", ((Upload)uploads.get((int)0)).name);
            this.assertEquals("test1.txt", ((Upload)uploads.get((int)0)).filename);
            this.assertEquals(content1, ((Upload)uploads.get((int)0)).data);
            this.assertEquals("test", ((Upload)uploads.get((int)1)).name);
            this.assertEquals("test2.txt", ((Upload)uploads.get((int)1)).filename);
            this.assertEquals(content2, ((Upload)uploads.get((int)1)).data);
        });
    }

    @Test
    public void testFileUploadsSameNameFormMultipartDisableMultipartMixed() throws Exception {
        Buffer content1 = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        Buffer content2 = Buffer.buffer((String)TestUtils.randomAlphaString(16));
        List<Upload> toUpload = Arrays.asList(Upload.fileUpload("test", "test1.txt", content1), Upload.fileUpload("test", "test2.txt", content2));
        ClientMultipartForm form = ClientMultipartForm.multipartForm().mixed(false);
        this.testFileUploadFormMultipart(form, toUpload, (req, uploads) -> {
            this.assertEquals(2L, uploads.size());
            this.assertEquals("test", ((Upload)uploads.get((int)0)).name);
            this.assertEquals("test1.txt", ((Upload)uploads.get((int)0)).filename);
            this.assertEquals(content1, ((Upload)uploads.get((int)0)).data);
            this.assertEquals("test", ((Upload)uploads.get((int)1)).name);
            this.assertEquals("test2.txt", ((Upload)uploads.get((int)1)).filename);
            this.assertEquals(content2, ((Upload)uploads.get((int)1)).data);
        });
    }

    private void testFileUploadFormMultipart(ClientMultipartForm form, List<Upload> toUpload, BiConsumer<HttpServerRequest, List<Upload>> checker) throws Exception {
        File[] testFiles = new File[toUpload.size()];
        for (int i = 0; i < testFiles.length; ++i) {
            Upload upload = toUpload.get(i);
            if (upload.file) {
                String name = upload.filename;
                testFiles[i] = this.testFolder.newFile(name);
                this.vertx.fileSystem().writeFileBlocking(testFiles[i].getPath(), upload.data);
                form.textFileUpload(toUpload.get((int)i).name, toUpload.get((int)i).filename, "text/plain", testFiles[i].getPath());
                continue;
            }
            form.textFileUpload(toUpload.get((int)i).name, toUpload.get((int)i).filename, "text/plain", upload.data);
        }
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            ArrayList uploads = new ArrayList();
            req.uploadHandler(upload -> {
                Buffer fileBuffer = Buffer.buffer();
                this.assertEquals("text/plain", upload.contentType());
                upload.handler(arg_0 -> ((Buffer)fileBuffer).appendBuffer(arg_0));
                upload.endHandler(v -> uploads.add(new Upload(upload.name(), upload.filename(), true, upload.charset(), fileBuffer)));
            });
            req.endHandler(v -> {
                checker.accept((HttpServerRequest)req, uploads);
                req.response().end();
            });
        });
        this.startServer();
        this.client.request(new RequestOptions(this.requestOptions).setMethod(HttpMethod.POST)).compose(req -> req.send((ClientForm)form).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testMultipartFormMultipleHeaders() throws Exception {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                this.assertEquals(Arrays.asList("1", "2"), req.headers().getAll("bla"));
                req.response().end();
            });
        });
        this.startServer();
        this.client.request(new RequestOptions(this.requestOptions).putHeader((CharSequence)"bla", Arrays.asList("1", "2")).setMethod(HttpMethod.POST)).compose(req -> req.send((ClientForm)ClientMultipartForm.multipartForm()).expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body)).await();
    }

    @Test
    public void testFileUploadWhenFileDoesNotExist() throws Exception {
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        HttpClientRequest request = (HttpClientRequest)this.client.request(new RequestOptions(this.requestOptions).putHeader((CharSequence)"bla", Arrays.asList("1", "2")).setMethod(HttpMethod.POST)).await();
        Future response = request.send((ClientForm)ClientMultipartForm.multipartForm().textFileUpload("file", "nonexistentFilename", "nonexistentPathname", "text/plain"));
        try {
            response.expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body).await();
        }
        catch (Exception err) {
            this.assertEquals(err.getClass(), StreamResetException.class);
            this.assertEquals(err.getCause().getClass(), HttpPostRequestEncoder.ErrorDataEncoderException.class);
            this.assertEquals(err.getCause().getCause().getClass(), FileNotFoundException.class);
        }
        this.assertTrue(request.response().failed());
    }

    @Test
    public void testInvalidMultipartContentType() throws Exception {
        this.testInvalidContentType((ClientForm)ClientMultipartForm.multipartForm(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
    }

    @Test
    public void testInvalidContentType() throws Exception {
        this.testInvalidContentType((ClientForm)ClientMultipartForm.multipartForm(), HttpHeaders.TEXT_HTML.toString());
    }

    private void testInvalidContentType(ClientForm form, String contentType) throws Exception {
        this.server.requestHandler(req -> this.fail());
        this.startServer();
        try {
            this.client.request(new RequestOptions(this.requestOptions).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType).setMethod(HttpMethod.POST)).compose(request -> request.send(form)).await();
            this.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class Upload {
        final String name;
        final String filename;
        final String charset;
        final Buffer data;
        final boolean file;

        private Upload(String name, String filename, boolean file, String charset, Buffer data) {
            this.name = name;
            this.filename = filename;
            this.charset = charset;
            this.data = data;
            this.file = file;
        }

        static Upload fileUpload(String name, String filename, Buffer data) {
            return new Upload(name, filename, true, null, data);
        }

        static Upload memoryUpload(String name, String filename, Buffer data) {
            return new Upload(name, filename, false, null, data);
        }
    }
}

