/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.fileupload;

import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientForm;
import io.vertx.core.http.ClientMultipartForm;
import io.vertx.core.http.impl.ClientMultipartFormImpl;
import io.vertx.core.http.impl.ClientMultipartFormUpload;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.test.core.TestUtils;
import io.vertx.test.http.HttpTestBase;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class MultipartFormUploadTest
extends HttpTestBase {
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    private VertxInternal vertx;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = (VertxInternal)Vertx.vertx();
    }

    @Test
    public void testSimpleAttribute() throws Exception {
        Buffer result = Buffer.buffer();
        ContextInternal context = this.vertx.getOrCreateContext();
        ClientMultipartFormUpload upload = new ClientMultipartFormUpload(context, (ClientMultipartFormImpl)ClientForm.form().attribute("foo", "bar"), false, HttpPostRequestEncoder.EncoderMode.RFC1738);
        upload.endHandler(v -> {
            this.assertEquals("foo=bar", result.toString());
            this.testComplete();
        });
        upload.handler(arg_0 -> ((Buffer)result).appendBuffer(arg_0));
        upload.resume();
        context.runOnContext(v -> upload.pump());
    }

    @Test
    public void testFileUploadEventLoopContext() throws Exception {
        this.testFileUpload(this.vertx.createEventLoopContext(), false);
    }

    @Test
    public void testFileUploadWorkerContext() throws Exception {
        this.testFileUpload(this.vertx.createWorkerContext(), false);
    }

    @Test
    public void testFileUploadVirtualThreadContext() throws Exception {
        Assume.assumeTrue((boolean)this.vertx.isVirtualThreadAvailable());
        this.testFileUpload(this.vertx.createVirtualThreadContext(), false);
    }

    @Test
    public void testFileUploadPausedEventLoopContext() throws Exception {
        this.testFileUpload(this.vertx.createEventLoopContext(), true);
    }

    @Test
    public void testFileUploadPausedWorkerContext() throws Exception {
        this.testFileUpload(this.vertx.createWorkerContext(), true);
    }

    @Test
    public void testFileUploadPausedVirtualThreadContext() throws Exception {
        Assume.assumeTrue((boolean)this.vertx.isVirtualThreadAvailable());
        this.testFileUpload(this.vertx.createVirtualThreadContext(), true);
    }

    private void testFileUpload(ContextInternal context, boolean paused) throws Exception {
        File file = testFolder.newFile();
        Files.write(file.toPath(), TestUtils.randomByteArray(32768), new OpenOption[0]);
        String filename = file.getName();
        String pathname = file.getAbsolutePath();
        context.runOnContext(v1 -> {
            try {
                ClientMultipartFormUpload upload = new ClientMultipartFormUpload(context, (ClientMultipartFormImpl)ClientMultipartForm.multipartForm().textFileUpload("the-file", filename, "text/plain", pathname), true, HttpPostRequestEncoder.EncoderMode.RFC1738);
                List buffers = Collections.synchronizedList(new ArrayList());
                AtomicInteger end = new AtomicInteger();
                upload.endHandler(v2 -> {
                    this.assertEquals(0L, end.getAndIncrement());
                    this.assertFalse(buffers.isEmpty());
                    this.testComplete();
                });
                upload.handler(buffer -> {
                    this.assertEquals(0L, end.get());
                    buffers.add(buffer);
                });
                if (!paused) {
                    upload.resume();
                }
                upload.pump();
                if (paused) {
                    context.runOnContext(v3 -> upload.resume());
                }
            }
            catch (Exception e) {
                this.fail(e);
            }
        });
    }
}

