/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.http.headers;

import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.tests.http.headers.VertxHttpHeadersTest;
import org.junit.Assert;
import org.junit.Test;

public class CaseInsensitiveHeadersTest
extends VertxHttpHeadersTest {
    public CaseInsensitiveHeadersTest() {
        this.sameHash1 = "AZ";
        this.sameHash2 = "\u0080Y";
        this.sameBucket1 = "A";
        this.sameBucket2 = "R";
    }

    @Override
    protected HeadersMultiMap newMultiMap() {
        return (HeadersMultiMap)MultiMap.caseInsensitiveMultiMap();
    }

    @Override
    @Test
    public void checkNameCollision() {
        Assert.assertEquals((long)CaseInsensitiveHeadersTest.hash(this.sameHash1), (long)CaseInsensitiveHeadersTest.hash(this.sameHash2));
        Assert.assertNotEquals((long)CaseInsensitiveHeadersTest.hash(this.sameBucket1), (long)CaseInsensitiveHeadersTest.hash(this.sameBucket2));
        Assert.assertEquals((long)CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(this.sameBucket1)), (long)CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(this.sameBucket2)));
    }

    private static int hash(String name) {
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static int index(int hash) {
        return hash % 17;
    }

    @Test
    public void testHashMININT() {
        HeadersMultiMap mm = this.newMultiMap();
        Object name1 = "";
        long value = Integer.MAX_VALUE;
        ++value;
        int base = 31;
        long pow = 1L;
        while (value > pow * (long)base) {
            pow *= (long)base;
        }
        while (pow != 0L) {
            long mul = value / pow;
            name1 = (char)mul + (String)name1;
            value -= pow * mul;
            pow /= (long)base;
        }
        name1 = (char)value + (String)name1;
        mm.add((String)name1, "value");
        Assert.assertEquals((Object)"value", (Object)mm.get((String)name1));
    }
}

