/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.vertx.core.ThreadingModel;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class JacksonDatabindTest
extends VertxTestBase {
    @Test
    public void testGetMapper() {
        ObjectMapper mapper = DatabindCodec.mapper();
        this.assertNotNull(mapper);
    }

    @Test
    public void testGenericDecoding() {
        Pojo original = new Pojo();
        original.value = "test";
        String json = Json.encode(Collections.singletonList(original));
        DatabindCodec databindCodec = new DatabindCodec();
        List correct = (List)databindCodec.fromString(json, (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        correct = (List)databindCodec.fromBuffer(Buffer.buffer((String)json, (String)"UTF8"), (TypeReference)new TypeReference<List<Pojo>>(){});
        this.assertTrue(correct.get(0) instanceof Pojo);
        this.assertEquals(original.value, ((Pojo)correct.get((int)0)).value);
        List incorrect = (List)Json.decodeValue((String)json, List.class);
        this.assertFalse(incorrect.get(0) instanceof Pojo);
        this.assertTrue(incorrect.get(0) instanceof Map);
        this.assertEquals(original.value, ((Map)incorrect.get(0)).get("value"));
    }

    @Test
    public void testInstantDecoding() {
        Pojo original = new Pojo();
        original.instant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse("2018-06-20T07:25:38.397Z"));
        Pojo decoded = (Pojo)Json.decodeValue((String)"{\"instant\":\"2018-06-20T07:25:38.397Z\"}", Pojo.class);
        this.assertEquals(original.instant, decoded.instant);
    }

    @Test
    public void testNullInstantDecoding() {
        Pojo original = new Pojo();
        Pojo decoded = (Pojo)Json.decodeValue((String)"{\"instant\":null}", Pojo.class);
        this.assertEquals(original.instant, decoded.instant);
    }

    @Test
    public void testBytesDecoding() {
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        Pojo original = new Pojo();
        original.bytes = TestUtils.randomByteArray(12);
        Pojo decoded = (Pojo)Json.decodeValue((String)("{\"bytes\":\"" + TestUtils.toBase64String(original.bytes) + "\"}"), Pojo.class);
        this.assertArrayEquals(original.bytes, decoded.bytes);
    }

    @Test
    public void testNullBytesDecoding() {
        Pojo original = new Pojo();
        Pojo decoded = (Pojo)Json.decodeValue((String)"{\"bytes\":null}", Pojo.class);
        this.assertEquals((Object)original.bytes, (Object)decoded.bytes);
    }

    @Test
    public void testJsonArrayDeserializer() throws JsonProcessingException {
        String jsonArrayString = "[1, 2, 3]";
        JsonArray jsonArray = (JsonArray)DatabindCodec.mapper().readValue(jsonArrayString, JsonArray.class);
        this.assertEquals(3L, jsonArray.size());
        this.assertEquals(new JsonArray().add((Object)1).add((Object)2).add((Object)3), jsonArray);
    }

    @Test
    public void testJsonObjectDeserializer() throws JsonProcessingException {
        String jsonObjectString = "{\"key1\": \"value1\", \"key2\": \"value2\", \"key3\": \"value3\"}";
        JsonObject jsonObject = (JsonObject)DatabindCodec.mapper().readValue(jsonObjectString, JsonObject.class);
        this.assertEquals("value1", jsonObject.getString("key1"));
        this.assertEquals("value2", jsonObject.getString("key2"));
    }

    @Test
    public void testJsonObjectSerializer() throws JsonProcessingException {
        ObjectMapper objectMapper = DatabindCodec.mapper();
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("key1", (Object)"value1");
        jsonObject.put("key2", (Object)"value2");
        jsonObject.put("key3", (Object)"value3");
        String jsonString = objectMapper.writeValueAsString((Object)jsonObject);
        this.assertEquals("{\"key1\":\"value1\",\"key2\":\"value2\",\"key3\":\"value3\"}", jsonString);
    }

    @Test
    public void testJsonArraySerializer() throws JsonProcessingException {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Object)"value1");
        jsonArray.add((Object)"value2");
        jsonArray.add((Object)"value3");
        String jsonString = DatabindCodec.mapper().writeValueAsString((Object)jsonArray);
        this.assertEquals("[\"value1\",\"value2\",\"value3\"]", jsonString);
    }

    @Test
    public void testInstantSerializer() throws IOException {
        Instant instant = Instant.parse("2023-06-09T12:34:56.789Z");
        String jsonString = DatabindCodec.mapper().writeValueAsString((Object)instant);
        this.assertEquals("\"2023-06-09T12:34:56.789Z\"", jsonString);
    }

    @Test
    public void testInstantDeserializer() throws IOException {
        String jsonString = "\"2023-06-09T12:34:56.789Z\"";
        Instant instant = (Instant)DatabindCodec.mapper().readValue(jsonString, Instant.class);
        Instant expectedInstant = Instant.parse("2023-06-09T12:34:56.789Z");
        this.assertEquals(expectedInstant, instant);
    }

    @Test
    public void testByteArraySerializer() throws IOException {
        byte[] byteArray = "Hello, World!".getBytes();
        String jsonString = DatabindCodec.mapper().writeValueAsString((Object)byteArray);
        String expectedBase64String = Base64.getEncoder().withoutPadding().encodeToString(byteArray);
        this.assertEquals("\"" + expectedBase64String + "\"", jsonString);
    }

    @Test
    public void testByteArrayDeserializer() throws IOException {
        String jsonString = "\"SGVsbG8sIFdvcmxkIQ\"";
        byte[] byteArray = (byte[])DatabindCodec.mapper().readValue(jsonString, byte[].class);
        byte[] expectedByteArray = Base64.getDecoder().decode("SGVsbG8sIFdvcmxkIQ");
        this.assertArrayEquals(expectedByteArray, byteArray);
    }

    @Test
    public void testBufferSerializer() throws IOException {
        Buffer buffer = Buffer.buffer((String)"Hello, World!");
        String jsonString = DatabindCodec.mapper().writeValueAsString((Object)buffer);
        this.assertEquals("\"SGVsbG8sIFdvcmxkIQ\"", jsonString);
    }

    @Test
    public void testBufferDeserializer() throws IOException {
        String jsonString = "\"SGVsbG8sIFdvcmxkIQ\"";
        Buffer buffer = (Buffer)DatabindCodec.mapper().readValue(jsonString, Buffer.class);
        Buffer expectedBuffer = Buffer.buffer((String)"Hello, World!");
        this.assertEquals(expectedBuffer, buffer);
    }

    @Test
    public void testPrettyPrinting() {
        JsonObject jsonObject = new JsonObject().put("key1", (Object)"value1").put("key2", (Object)"value2").put("key3", (Object)"value3");
        String compact = Json.encode((Object)jsonObject);
        String pretty = Json.encodePrettily((Object)jsonObject);
        this.assertFalse(compact.equals(pretty));
        this.assertEquals(jsonObject, Json.decodeValue((String)pretty));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObjectMapperConfigAppliesToPrettyPrinting() {
        ObjectMapper om = DatabindCodec.mapper();
        SerializationConfig sc = om.getSerializationConfig();
        this.assertNotNull(sc);
        try {
            om.setConfig(sc.with(SerializationFeature.WRITE_ENUMS_USING_INDEX));
            ThreadingModel vt = ThreadingModel.VIRTUAL_THREAD;
            String expected = String.valueOf(vt.ordinal());
            this.assertEquals(expected, Json.encodePrettily((Object)vt));
            this.assertEquals(expected, Json.encode((Object)vt));
        }
        finally {
            om.setConfig(sc);
        }
    }

    private static class Pojo {
        @JsonProperty
        String value;
        @JsonProperty
        Instant instant;
        @JsonProperty
        byte[] bytes;

        private Pojo() {
        }
    }
}

