/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.json;

import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.test.core.VertxTestBase;
import org.junit.Assert;
import org.junit.Test;

public class JacksonTest
extends VertxTestBase {
    private final JacksonCodec codec = new JacksonCodec();

    @Test
    public void testEncodeUnknownNumber() {
        String result = this.codec.toString((Object)new Number(){

            @Override
            public int intValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long longValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public float floatValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public double doubleValue() {
                return 4.0;
            }
        });
        this.assertEquals("4.0", result);
    }

    @Test
    public void testEncodePojoFailure() {
        try {
            this.codec.toString((Object)new MyPojo());
            this.fail();
        }
        catch (EncodeException e) {
            this.assertTrue(e.getMessage().contains(MyPojo.class.getName()));
        }
    }

    @Test(expected=EncodeException.class)
    public void encodeToBuffer() {
        this.codec.toBuffer((Object)new RuntimeException("Unsupported"));
    }

    @Test
    public void testDefaultConstraints() {
        JacksonTest.testReadConstraints(1000, 1000, 20000000, 50000);
    }

    public static void testReadConstraints(int defaultMaxDepth, int maxNumberLength, int defaultMaxStringLength, int defaultMaxNameLength) {
        JacksonTest.testMaxNestingDepth(defaultMaxDepth);
        try {
            JacksonTest.testMaxNestingDepth(defaultMaxDepth + 1);
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
        JacksonTest.testMaxNumberLength(maxNumberLength);
        try {
            JacksonTest.testMaxNumberLength(maxNumberLength + 1);
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
        JacksonTest.testMaxStringLength(defaultMaxStringLength);
        try {
            JacksonTest.testMaxStringLength(defaultMaxStringLength + 1);
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
        JacksonTest.testMaxNameLength(defaultMaxNameLength);
        try {
            JacksonTest.testMaxNameLength(defaultMaxNameLength + 1);
            Assert.fail();
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
    }

    private static JsonArray testMaxNestingDepth(int depth) {
        String json = "[".repeat(depth) + "]".repeat(depth);
        return new JsonArray(json);
    }

    private static JsonObject testMaxNumberLength(int len) {
        String json = "{\"number\":" + "1".repeat(len) + "}";
        return new JsonObject(json);
    }

    private static JsonObject testMaxStringLength(int len) {
        String json = "{\"string\":\"" + "a".repeat(len) + "\"}";
        return new JsonObject(json);
    }

    private static JsonObject testMaxNameLength(int len) {
        String json = "{\"" + "a".repeat(len) + "\":3}";
        return new JsonObject(json);
    }

    public static class MyPojo {
    }
}

