/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.json.jackson;

import com.fasterxml.jackson.core.util.BufferRecycler;
import io.vertx.core.json.jackson.HybridJacksonPool;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class HybridJacksonPoolTest {
    @Test
    public void testVirtualThreadPoolWithSingleThread() {
        HybridJacksonPool.StripedLockFreePool virtualPool = new HybridJacksonPool.StripedLockFreePool(4);
        BufferRecycler pooledResource = virtualPool.acquirePooled();
        Assert.assertEquals((long)0L, (long)virtualPool.size());
        virtualPool.releasePooled(pooledResource);
        Assert.assertEquals((long)1L, (long)virtualPool.size());
        Assert.assertSame((Object)pooledResource, (Object)virtualPool.acquirePooled());
        Assert.assertEquals((long)0L, (long)virtualPool.size());
    }

    @Test
    public void testVirtualThreadPoolWithMultipleThreads() {
        Assume.assumeTrue((boolean)VirtualThreadRunner.hasVirtualThread());
        int stripesCount = 4;
        HybridJacksonPool.StripedLockFreePool virtualPool = new HybridJacksonPool.StripedLockFreePool(stripesCount);
        int nThreads = 100;
        BufferRecycler[] resources = new BufferRecycler[nThreads];
        CountDownLatch latch = new CountDownLatch(nThreads);
        int i = 0;
        while (i < nThreads) {
            int threadIndex = i++;
            VirtualThreadRunner.runOnVirtualThread(() -> {
                resources[threadIndex] = virtualPool.acquirePooled();
                latch.countDown();
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((long)0L, (long)virtualPool.size());
        for (i = 0; i < nThreads; ++i) {
            virtualPool.releasePooled(resources[i]);
        }
        Assert.assertEquals((long)nThreads, (long)virtualPool.size());
        int avgResourcesNrPerStripe = nThreads / stripesCount;
        int minResourcesNrPerStripe = avgResourcesNrPerStripe / 2;
        int maxResourcesNrPerStripe = avgResourcesNrPerStripe * 2;
        int[] poolStats = virtualPool.stackStats();
        for (int i2 = 0; i2 < stripesCount; ++i2) {
            Assert.assertTrue((poolStats[i2] >= minResourcesNrPerStripe ? 1 : 0) != 0);
            Assert.assertTrue((poolStats[i2] <= maxResourcesNrPerStripe ? 1 : 0) != 0);
        }
    }

    private static class VirtualThreadRunner {
        static final MethodHandle virtualMh = VirtualThreadRunner.findVirtualMH();

        private VirtualThreadRunner() {
        }

        static MethodHandle findVirtualMH() {
            try {
                return MethodHandles.publicLookup().findStatic(Thread.class, "startVirtualThread", MethodType.methodType(Thread.class, Runnable.class));
            }
            catch (Exception e) {
                return null;
            }
        }

        static boolean hasVirtualThread() {
            return virtualMh != null;
        }

        static void runOnVirtualThread(Runnable runnable) {
            try {
                virtualMh.invoke(runnable);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

