/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.metrics;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.metrics.Measured;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import io.vertx.test.fakemetrics.FakeTCPMetrics;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.http.HttpTestBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public abstract class HttpMetricsTestBase
extends HttpTestBase {
    private final HttpVersion protocol;
    private final ThreadingModel threadingModel;

    public HttpMetricsTestBase(HttpVersion protocol, ThreadingModel threadingModel) {
        this.protocol = protocol;
        this.threadingModel = threadingModel;
    }

    @Override
    protected void startServer(SocketAddress bindAddress, Context context, HttpServer server) throws Exception {
        if (this.threadingModel == ThreadingModel.WORKER) {
            context = ((VertxInternal)this.vertx).createWorkerContext();
        }
        super.startServer(bindAddress, context, server);
    }

    @Override
    protected void tearDown() throws Exception {
        FakeMetricsBase.sanityCheck();
        super.tearDown();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.setMetricsOptions(new MetricsOptions().setEnabled(true));
        return options;
    }

    @Override
    protected Vertx createVertx(VertxOptions options) {
        return Vertx.builder().with(options).withMetrics((VertxMetricsFactory)new FakeMetricsFactory()).build();
    }

    @Test
    public void testHttpMetricsLifecycle() throws Exception {
        int numBuffers = 10;
        int chunkSize = 1000;
        int contentLength = numBuffers * chunkSize;
        AtomicReference serverMetric = new AtomicReference();
        this.server.requestHandler(req -> {
            this.assertEquals(this.protocol, req.version());
            FakeHttpServerMetrics serverMetrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            this.assertNotNull(serverMetrics);
            HttpServerMetric metric = serverMetrics.getRequestMetric((HttpServerRequest)req);
            serverMetric.set(metric);
            this.assertSame(((HttpServerRequestInternal)req).metric(), metric);
            this.assertNotNull(serverMetric.get());
            this.assertNotNull(((HttpServerMetric)serverMetric.get()).socket);
            this.assertNull(((HttpServerMetric)serverMetric.get()).response.get());
            this.assertTrue(((HttpServerMetric)serverMetric.get()).socket.connected.get());
            this.assertNull(((HttpServerMetric)serverMetric.get()).route.get());
            req.routed("/route/:param");
            HttpMetricsTestBase.assertWaitUntil(() -> ((HttpServerMetric)serverMetric.get()).route.get() != null);
            this.assertEquals("/route/:param", ((HttpServerMetric)serverMetric.get()).route.get());
            req.bodyHandler(buff -> {
                this.assertEquals(contentLength, buff.length());
                this.assertTrue(((HttpServerMetric)serverMetric.get()).requestEnded.get());
                this.assertEquals(contentLength, ((HttpServerMetric)serverMetric.get()).bytesRead.get());
                HttpServerResponse resp = req.response().setChunked(true);
                AtomicInteger numBuffer = new AtomicInteger(numBuffers);
                this.vertx.setPeriodic(1L, timerID -> {
                    Buffer chunk = TestUtils.randomBuffer(chunkSize);
                    if (numBuffer.decrementAndGet() == 0) {
                        resp.end(chunk).onComplete(this.onSuccess(v -> {
                            this.assertTrue(((HttpServerMetric)serverMetric.get()).responseEnded.get());
                            this.assertFalse(((HttpServerMetric)serverMetric.get()).failed.get());
                            this.assertEquals(contentLength, ((HttpServerMetric)serverMetric.get()).bytesWritten.get());
                            this.assertNull(serverMetrics.getRequestMetric((HttpServerRequest)req));
                        }));
                        this.vertx.cancelTimer(timerID.longValue());
                    } else {
                        resp.write((Object)chunk).onComplete(this.onSuccess(v -> this.assertSame(((HttpServerMetric)serverMetric.get()).response.get(), resp)));
                    }
                });
            });
        });
        this.startServer(this.testAddress);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference clientMetric = new AtomicReference();
        AtomicReference clientSocketMetric = new AtomicReference();
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        NetClientInternal netClient = ((HttpClientInternal)this.client).netClient();
        FakeTCPMetrics tcpMetrics = (FakeTCPMetrics)FakeMetricsBase.getMetrics((Measured)netClient);
        this.assertSame(metrics, tcpMetrics);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            this.assertEquals(Collections.emptySet(), metrics.endpoints());
            this.client.request(new RequestOptions(this.requestOptions).setURI(TestUtils.randomAlphaString(16))).onComplete(this.onSuccess(req -> {
                req.response().onComplete(this.onSuccess(resp -> {
                    clientSocketMetric.set(metrics.firstMetric(this.testAddress));
                    this.assertNotNull(clientSocketMetric.get());
                    this.assertEquals(Collections.singleton(this.testAddress.toString()), metrics.endpoints());
                    clientMetric.set(metrics.getMetric(resp.request()));
                    this.assertNotNull(clientMetric.get());
                    this.assertEquals(contentLength, ((HttpClientMetric)clientMetric.get()).bytesWritten.get());
                    this.assertEquals((Object)1, metrics.connectionCount(this.testAddress));
                    resp.bodyHandler(buff -> {
                        this.assertEquals(contentLength, ((HttpClientMetric)clientMetric.get()).bytesRead.get());
                        this.assertNull(metrics.getMetric(resp.request()));
                        this.assertEquals(contentLength, buff.length());
                        latch.countDown();
                    });
                }));
                req.exceptionHandler(this::fail).setChunked(true);
                this.assertNull(metrics.getMetric((HttpClientRequest)req));
                for (int i = 0; i < numBuffers; ++i) {
                    req.write((Object)TestUtils.randomBuffer(chunkSize));
                }
                req.end();
            }));
        });
        this.awaitLatch(latch);
        this.client.close();
        AsyncTestBase.assertWaitUntil(() -> metrics.endpoints().isEmpty());
        this.assertEquals(null, metrics.connectionCount(DEFAULT_HTTP_HOST_AND_PORT));
        AsyncTestBase.assertWaitUntil(() -> !((HttpServerMetric)serverMetric.get()).socket.connected.get());
        AsyncTestBase.assertWaitUntil(() -> (long)contentLength == ((HttpServerMetric)serverMetric.get()).socket.bytesRead.get());
        AsyncTestBase.assertWaitUntil(() -> (long)contentLength == ((HttpServerMetric)serverMetric.get()).socket.bytesWritten.get());
        AsyncTestBase.assertWaitUntil(() -> !((SocketMetric)clientSocketMetric.get()).connected.get());
        this.assertEquals(contentLength, ((SocketMetric)clientSocketMetric.get()).bytesRead.get());
        this.assertEquals(contentLength, ((SocketMetric)clientSocketMetric.get()).bytesWritten.get());
        for (Iterator it : Arrays.asList(((SocketMetric)clientSocketMetric.get()).bytesReadEvents.iterator(), ((HttpServerMetric)serverMetric.get()).socket.bytesWrittenEvents.iterator())) {
            while (it.hasNext()) {
                long val = (Long)it.next();
                if (it.hasNext()) {
                    this.assertEquals(4096L, val);
                    continue;
                }
                this.assertTrue(val < 4096L);
            }
        }
    }

    @Test
    public void testHttpClientLifecycle() throws Exception {
        HttpClientOptions opts = this.createBaseClientOptions();
        if (opts.getProtocolVersion() == HttpVersion.HTTP_2 && !opts.isSsl() && opts.isHttp2ClearTextUpgrade()) {
            return;
        }
        CountDownLatch requestBeginLatch = new CountDownLatch(1);
        CountDownLatch requestBodyLatch = new CountDownLatch(1);
        CountDownLatch requestEndLatch = new CountDownLatch(1);
        CompletableFuture<Object> beginResponse = new CompletableFuture<Object>();
        CompletableFuture<Object> endResponse = new CompletableFuture<Object>();
        this.server.requestHandler(req -> {
            this.assertEquals(this.protocol, req.version());
            requestBeginLatch.countDown();
            req.handler(buff -> requestBodyLatch.countDown());
            req.endHandler(v -> requestEndLatch.countDown());
            Context ctx = this.vertx.getOrCreateContext();
            beginResponse.thenAccept(v1 -> ctx.runOnContext(v2 -> req.response().setChunked(true).write(TestUtils.randomAlphaString(1024))));
            endResponse.thenAccept(v1 -> ctx.runOnContext(v2 -> req.response().end()));
        });
        this.startServer(this.testAddress);
        FakeHttpClientMetrics clientMetrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        CountDownLatch responseBeginLatch = new CountDownLatch(1);
        CountDownLatch responseEndLatch = new CountDownLatch(1);
        Future request = this.client.request(new RequestOptions().setMethod(HttpMethod.POST).setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/somepath")).onComplete(this.onSuccess(req -> {
            req.response().onComplete(this.onSuccess(resp -> {
                responseBeginLatch.countDown();
                resp.endHandler(v -> responseEndLatch.countDown());
            }));
            req.setChunked(true);
            req.sendHead();
        }));
        this.awaitLatch(requestBeginLatch);
        HttpClientMetric reqMetric = clientMetrics.getMetric((HttpClientRequest)request.result());
        HttpMetricsTestBase.waitUntil(() -> reqMetric.requestEnded.get() == 0);
        HttpMetricsTestBase.waitUntil(() -> reqMetric.responseBegin.get() == 0);
        ((HttpClientRequest)request.result()).write(TestUtils.randomAlphaString(1024));
        this.awaitLatch(requestBodyLatch);
        this.assertEquals(0L, reqMetric.requestEnded.get());
        this.assertEquals(0L, reqMetric.responseBegin.get());
        ((HttpClientRequest)request.result()).end();
        this.awaitLatch(requestEndLatch);
        HttpMetricsTestBase.waitUntil(() -> reqMetric.requestEnded.get() == 1);
        this.assertEquals(0L, reqMetric.responseBegin.get());
        beginResponse.complete(null);
        this.awaitLatch(responseBeginLatch);
        this.assertEquals(1L, reqMetric.requestEnded.get());
        HttpMetricsTestBase.waitUntil(() -> reqMetric.responseBegin.get() == 1);
        endResponse.complete(null);
        this.awaitLatch(responseEndLatch);
        HttpMetricsTestBase.waitUntil(() -> clientMetrics.getMetric((HttpClientRequest)request.result()) == null);
        this.assertEquals(1L, reqMetric.requestEnded.get());
        this.assertEquals(1L, reqMetric.responseBegin.get());
    }

    @Test
    public void testClientConnectionClosed() throws Exception {
        this.server.requestHandler(req -> req.response().setChunked(true).write((Object)Buffer.buffer((String)"some-data")));
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setIdleTimeout(2));
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> {
            HttpClientMetric metric = metrics.getMetric(resp.request());
            this.assertNotNull(metric);
            this.assertFalse(metric.failed.get());
            req.connection().closeHandler(v1 -> this.vertx.runOnContext(v2 -> {
                this.assertNull(metrics.getMetric(resp.request()));
                this.assertTrue(metric.failed.get());
                this.testComplete();
            }));
        }))));
        this.await();
    }

    @Test
    public void testServerConnectionClosed() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setIdleTimeout(2));
        this.server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric metric = metrics.getRequestMetric((HttpServerRequest)req);
            this.assertNotNull(metric);
            this.assertFalse(metric.failed.get());
            req.response().closeHandler(v -> {
                this.assertNull(metrics.getRequestMetric((HttpServerRequest)req));
                this.assertTrue(metric.failed.get());
                this.testComplete();
            });
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setURI(TestUtils.randomAlphaString(16))).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testRouteMetrics() throws Exception {
        this.server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric metric = metrics.getRequestMetric((HttpServerRequest)req);
            this.assertNull(metric.route.get());
            req.routed("MyRoute");
            HttpMetricsTestBase.assertWaitUntil(() -> metric.route.get() != null);
            this.assertEquals("MyRoute", metric.route.get());
            metric.route.set(null);
            req.routed("MyRoute - rerouted");
            HttpMetricsTestBase.assertWaitUntil(() -> metric.route.get() != null);
            this.assertEquals("MyRoute - rerouted", metric.route.get());
            req.response().end();
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setURI(TestUtils.randomAlphaString(16))).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testRouteMetricsIgnoredAfterResponseEnd() throws Exception {
        this.server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric metric = metrics.getRequestMetric((HttpServerRequest)req);
            this.assertNull(metric.route.get());
            req.response().end();
            req.routed("Routed after ending");
            this.assertNull(metric.route.get());
            this.testComplete();
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setURI(TestUtils.randomAlphaString(16))).onComplete(this.onSuccess(HttpClientRequest::send));
        this.await();
    }

    @Test
    public void testResetImmediately() {
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        this.server.requestHandler(req -> {}).listen(this.testAddress).onComplete(this.onSuccess(v -> this.client.request(this.requestOptions).onComplete(this.onSuccess(request -> {
            this.assertNull(metrics.getMetric((HttpClientRequest)request));
            request.reset(0L);
            this.vertx.setTimer(10L, id -> this.testComplete());
        }))));
        this.await();
    }
}

